/**
 * JASMINe
 * Copyright (C) 2007-2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.fdf;

import java.io.Serializable;


/**
 * @author Julien Legrand
 *
 */
public class JASMINeNodeImpl implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 200599862509277853L;

    /**
     *
     */
    private String name = "JASMINeNode";

    /**
     *
     */
    private String host = "127.0.0.1";

    /**
     *
     */
    private String user = null;

    /**
     *
     */
    private String password = null;

    /**
     *
     */
    private String sshKey = null;

    /**
     *
     */
    private String installDir = null;

    /**
     *
     */
    private String nodeId = null;

    /**
     *
     */
    private String registryHost = "127.0.0.1";

    /**
     *
     */
    private String registryPort = "1238";

    /**
     *
     */
    private String discoveryHost = "127.0.0.1";

    /**
     *
     */
    private String discoveryPort = "9998";

    /**
     *
     */
    private String jndiPort = "1239";

    /**
     *
     */
    private String felixProfile = "jasminenode";

    /**
     *
     */
    private String repositoryURL = null;

    /**
     *
     */
    private String jreHome = null;

    // ------------------------------------------------------------------------
    // Constructor
    // ------------------------------------------------------------------------

    public JASMINeNodeImpl() {
    }

    // ------------------------------------------------------------------------
    // Getters
    // ------------------------------------------------------------------------

    public String getDiscoveryHost() {
        return discoveryHost;
    }

    public void setDiscoveryHost(String newDiscoveryHost) {
        discoveryHost = newDiscoveryHost;
    }

    public String getDiscoveryPort() {
        return discoveryPort;
    }

    public void setDiscoveryPort(String newDiscoveryPort) {
        discoveryPort = newDiscoveryPort;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String newHost) {
        host = newHost;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String newUser) {
        user = newUser;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String newPassword) {
        password = newPassword;
    }

    public String getSshKey() {
        return sshKey;
    }

    public void setSshKey(String newSshKey) {
        sshKey = newSshKey;
    }

    public String getInstallDir() {
        return installDir;
    }

    public void setInstallDir(String newInstallDir) {
        installDir = newInstallDir;
    }

    public String getJndiPort() {
        return jndiPort;
    }

    public String getJreHome() {
        return jreHome;
    }


    // ------------------------------------------------------------------------
    // Setters
    // ------------------------------------------------------------------------

    public void setJndiPort(String newJndiPort) {
        jndiPort = newJndiPort;
    }

    public String getNodeId() {
        return nodeId;
    }

    public void setNodeId(String newNodeId) {
        nodeId = newNodeId;
    }

    public String getFelixProfile() {
        return felixProfile;
    }

    public void setFelixProfile(String newFelixProfile) {
        felixProfile = newFelixProfile;
    }

    public String getRegistryHost() {
        return registryHost;
    }

    public void setRegistryHost(String newRegistryHost) {
        registryHost = newRegistryHost;
    }

    public String getRegistryPort() {
        return registryPort;
    }

    public void setRegistryPort(String newRegistryPort) {
        registryPort = newRegistryPort;
    }

    public String getRepositoryURL() {
        return repositoryURL;
    }

    public void setRepositoryURL(String newRepositoryURL) {
        repositoryURL = newRepositoryURL;
    }

    public String getName() {
        return name;
    }

    public void setName(String newName) {
        name = newName;
    }

    public void setJreHome(String jreHome) {
        this.jreHome = jreHome;
    }

    // ------------------------------------------------------------------------
    // Overidden methods
    // ------------------------------------------------------------------------

    /**
     */
    @Override
    public String toString() {

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(name);
        result.append(", host: ");
        result.append(host);
        result.append(", user: ");
        result.append(user);
        result.append(", password: ");
        result.append(password);
        result.append(", sshKey: ");
        result.append(sshKey);
        result.append(", installDir: ");
        result.append(installDir);
        result.append(", nodeId: ");
        result.append(nodeId);
        result.append(", registryHost: ");
        result.append(registryHost);
        result.append(", registryPort: ");
        result.append(registryPort);
        result.append(", discoveryHost: ");
        result.append(discoveryHost);
        result.append(", discoveryPort: ");
        result.append(discoveryPort);
        result.append(", jndiPort: ");
        result.append(jndiPort);
        result.append(", felixProfile: ");
        result.append(felixProfile);
        result.append(", repositoryURL: ");
        result.append(repositoryURL);
        result.append(')');
        return result.toString();
    }

} //JASMINeNodeImpl
