/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.fdf.ra.outbound;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;

import org.ow2.jasmine.fdf.ra.api.FdfConnectionFactory;

/**
 * @author Julien Legrand
 *
 */
public class FdfConnectionFactoryImpl implements FdfConnectionFactory {

    /**
     *
     */
    private static final long serialVersionUID = 7458016789813845367L;

    /**
     *
     */
    private static Logger logger = Logger
            .getLogger(FdfConnectionFactoryImpl.class.getName());

    /**
     *
     */
    private Reference ref = null;

    // ------------------------------------------------------------------------
    // Implementation of the FdfConnectionFactory interface
    // ------------------------------------------------------------------------

    /* (non-Javadoc)
     * @see javax.resource.cci.ConnectionFactory#getConnection()
     */
    public Connection getConnection() throws ResourceException {
        return new FdfConnectionImpl();
    }

    /* (non-Javadoc)
     * @see javax.resource.cci.ConnectionFactory#getConnection(javax.resource.cci.ConnectionSpec)
     */
    public Connection getConnection(ConnectionSpec arg0)
            throws ResourceException {
        return new FdfConnectionImpl();
    }

    /* (non-Javadoc)
     * @see javax.resource.cci.ConnectionFactory#getMetaData()
     */
    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        logger.log(Level.INFO, "not implemented");
        return null;
    }

    /* (non-Javadoc)
     * @see javax.resource.cci.ConnectionFactory#getRecordFactory()
     */
    public RecordFactory getRecordFactory() throws ResourceException {
        logger.log(Level.INFO, "not implemented");
        return null;
    }

    /* (non-Javadoc)
     * @see javax.resource.Referenceable#setReference(javax.naming.Reference)
     */
    public void setReference(Reference arg0) {
        logger.log(Level.FINE, "set reference <= " + arg0);
        this.ref = arg0;
    }

    /* (non-Javadoc)
     * @see javax.naming.Referenceable#getReference()
     */
    public Reference getReference() throws NamingException {
        logger.log(Level.FINE, "get reference => " + ref);
        return ref;
    }

}
