/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.fdf.ra.api;

import java.io.File;

import javax.resource.cci.Connection;

import org.ow2.jasmine.fdf.JASMINeNodeImpl;

/**
 * @author Julien Legrand
 *
 */
public interface FdfConnection extends Connection {

    /**
     * @param fdfFile
     * @throws Exception
     */
    void install(File fdfFile) throws Exception;

    /**
     * @param fdfFile
     * @throws Exception
     *
     */
    void start(File fdfFile) throws Exception;

    /**
     * @param fdfFile
     * @throws Exception
     *
     */
    void stop(File fdfFile) throws Exception;

    /**
     * @param jasmineNode
     * @throws Exception
     */
    void install(JASMINeNodeImpl jasmineNode) throws Exception;

    /**
     * @param jasmineNode
     * @throws Exception
     *
     */
    void start(JASMINeNodeImpl jasmineNode) throws Exception;

    /**
     * @param jasmineNode
     * @throws Exception
     *
     */
    void stop(JASMINeNodeImpl jasmineNode) throws Exception;

}
