/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.fdf.ra.inbound;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

/**
 * @author Julien Legrand
 *
 */
public class FdfResourceAdapterImpl implements ResourceAdapter {

    /**
     *
     */
    private static Logger logger = Logger
            .getLogger(FdfResourceAdapterImpl.class.getName());

    // ------------------------------------------------------------------------
    // Implementation of the ResourceAdapter interface
    // ------------------------------------------------------------------------

    /* (non-Javadoc)
     * @see javax.resource.spi.ResourceAdapter#endpointActivation(javax.resource.spi.endpoint.MessageEndpointFactory, javax.resource.spi.ActivationSpec)
     */
    public void endpointActivation(MessageEndpointFactory arg0,
            ActivationSpec arg1) throws ResourceException {
        logger.log(Level.INFO, "not implemented");
    }

    /* (non-Javadoc)
     * @see javax.resource.spi.ResourceAdapter#endpointDeactivation(javax.resource.spi.endpoint.MessageEndpointFactory, javax.resource.spi.ActivationSpec)
     */
    public void endpointDeactivation(MessageEndpointFactory arg0,
            ActivationSpec arg1) {
        logger.log(Level.INFO, "not implemented");
    }

    /* (non-Javadoc)
     * @see javax.resource.spi.ResourceAdapter#getXAResources(javax.resource.spi.ActivationSpec[])
     */
    public XAResource[] getXAResources(ActivationSpec[] arg0)
            throws ResourceException {
        logger.log(Level.INFO, "not implemented");
        return null;
    }

    /* (non-Javadoc)
     * @see javax.resource.spi.ResourceAdapter#start(javax.resource.spi.BootstrapContext)
     */
    public void start(BootstrapContext arg0)
            throws ResourceAdapterInternalException {

        logger.log(Level.INFO, "FDF resource adpater started !");

    }

    /* (non-Javadoc)
     * @see javax.resource.spi.ResourceAdapter#stop()
     */
    public void stop() {

        logger.log(Level.INFO, "FDF resource adpater stopped !");

    }

}
