package org.ow2.jasmine.fdf.ra.outbound;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.sql.Timestamp;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;

import org.ow2.jasmine.fdf.JASMINeNodeImpl;
import org.ow2.jasmine.fdf.ra.api.FdfConnection;

import com.developpez.adiguba.shell.ProcessConsumer;
import com.developpez.adiguba.shell.Shell;

public class FdfConnectionImpl implements FdfConnection {

    /**
     *
     */
    private static Logger logger = Logger.getLogger(FdfConnectionImpl.class
            .getName());

    /**
     *
     */
    Shell sh;

    /**
     *
     */
    Future<Integer> process = null;

    // ------------------------------------------------------------------------
    // Constructor
    // ------------------------------------------------------------------------

    public FdfConnectionImpl() {
        sh = new Shell();
        sh.setDirectory(new File(System.getProperty("java.io.tmpdir")));
    }

    // ------------------------------------------------------------------------
    // Implementation of the FdfConnection interface
    // ------------------------------------------------------------------------

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.jasmine.fdf.api.FdfConnection#install()
     */
    public void install(File fdfFile) throws Exception {

        this.execute(fdfFile, "install");
    }

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.jasmine.fdf.api.FdfConnection#start()
     */
    public void start(File fdfFile) throws Exception {

        this.execute(fdfFile, "start");
    }

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.jasmine.fdf.api.FdfConnection#stop()
     */
    public void stop(File fdfFile) throws Exception {

        this.execute(fdfFile, "stop");
    }

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.jasmine.fdf.ra.api.FdfConnection#install(org.ow2.jasmine.fdf.JASMINeNodeImpl)
     */
    public void install(JASMINeNodeImpl jasmineNode) throws Exception {
        this.execute(generateFdfFile(jasmineNode), "install");
    }

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.jasmine.fdf.ra.api.FdfConnection#start(org.ow2.jasmine.fdf.JASMINeNodeImpl)
     */
    public void start(JASMINeNodeImpl jasmineNode) throws Exception {
        this.execute(generateFdfFile(jasmineNode), "start");
    }

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.jasmine.fdf.ra.api.FdfConnection#stop(org.ow2.jasmine.fdf.JASMINeNodeImpl)
     */
    public void stop(JASMINeNodeImpl jasmineNode) throws Exception {
        this.execute(generateFdfFile(jasmineNode), "stop");
    }

    // ------------------------------------------------------------------------
    // Implementation of the Connection interface
    // ------------------------------------------------------------------------

    public void close() throws ResourceException {
        if (process != null) {
            process.cancel(true);
        }
    }

    public Interaction createInteraction() throws ResourceException {
        logger.log(Level.INFO, "not implemented");
        return null;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        logger.log(Level.INFO, "not implemented");
        return null;
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        logger.log(Level.INFO, "not implemented");
        return null;
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        logger.log(Level.INFO, "not implemented");
        return null;
    }

    // ------------------------------------------------------------------------
    // Private methods
    // ------------------------------------------------------------------------

    /**
     * @param jasminenode
     * @return
     * @throws IllegalStateException
     * @throws IOException
     */
    private File generateFdfFile(JASMINeNodeImpl jasminenode)
            throws IllegalStateException, IOException {

        String fdfName = "JASMINeNode_"
                + new Timestamp(System.currentTimeMillis()).toString().replace(
                        " ", "_").replace(":", "_").replace(".", "_") + ".fdf";

        StringBuffer commandLine = new StringBuffer();

        /*
         * get java
         */
        String javaHome = System.getProperty("java.home");
        commandLine.append(javaHome);
        commandLine.append(File.separatorChar);
        commandLine.append("bin");
        commandLine.append(File.separatorChar);
        commandLine.append("java ");

        /*
         * generate classpath
         */

        // get directory containing FDF librairies
        StringBuffer libDir = new StringBuffer();
        libDir.append(getEarDeployerDirectory());
        libDir.append(File.separator);
        libDir.append("lib");
        libDir.append(File.separator);

        // get etc/ directory
        StringBuffer etcDir = new StringBuffer();
        etcDir.append(getEarDeployerDirectory());
        etcDir.append(File.separator);
        etcDir.append("etc");
        etcDir.append(File.separator);

        String earLibDir = libDir.toString();

        // construct classpath
        commandLine.append("-cp ");
        commandLine.append(earLibDir);
        commandLine.append("velocity-1.5.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("velocity-dep-1.5.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("vm-templates.jar");
        commandLine.append(":");
        commandLine.append(etcDir.toString());

        // Class to execute
        commandLine.append(" org.ow2.jasmine.fdf.util.FdfGenerator ");

        // arguments

        commandLine.append("-fdf ");
        commandLine.append(fdfName);

        if (jasminenode.getRegistryHost() != null) {
            commandLine.append(" -registryhost ");
            commandLine.append(jasminenode.getRegistryHost());
        }

        if (jasminenode.getHost() != null) {
            commandLine.append(" -host ");
            commandLine.append(jasminenode.getHost());
        }

        if (jasminenode.getUser() != null) {
            commandLine.append(" -user ");
            commandLine.append(jasminenode.getUser());
        }

        if (jasminenode.getPassword() != null) {
            commandLine.append(" -password ");
            commandLine.append(jasminenode.getPassword());
        }

        if (jasminenode.getSshKey() != null) {
            commandLine.append(" -sshkey ");
            commandLine.append(jasminenode.getSshKey());
        }

        if (jasminenode.getJreHome() != null) {
            commandLine.append(" -jre ");
            commandLine.append(jasminenode.getJreHome());
        }

        if (jasminenode.getInstallDir() != null) {
            commandLine.append(" -installdir ");
            commandLine.append(jasminenode.getInstallDir());
        }

        if (etcDir.toString() != null) {
            commandLine.append(" -resourcedir ");
            commandLine.append(etcDir.toString());
        }

        if (jasminenode.getFelixProfile() != null) {
            commandLine.append(" -felixprofile ");
            commandLine.append(jasminenode.getFelixProfile());
        }

        if (jasminenode.getRegistryPort() != null) {
            commandLine.append(" -registryport ");
            commandLine.append(jasminenode.getRegistryPort());
        }

        if (jasminenode.getDiscoveryPort() != null) {
            commandLine.append(" -discoveryport ");
            commandLine.append(jasminenode.getDiscoveryPort());
        }

        if (jasminenode.getRepositoryURL() != null) {
            commandLine.append(" -obrUrl ");
            commandLine.append(jasminenode.getRepositoryURL());
        }

        /*
         * execute the java command line
         */
        sh.command(commandLine.toString()).consume();

        return new File(System.getProperty("java.io.tmpdir") + File.separator
                + fdfName);

    }

    /**
     * @param operation
     * @throws Exception
     */
    private void execute(File fdfFile, String operation) throws Exception {

        String commandLine = getCommandLine(fdfFile, operation);
        logger.log(Level.INFO, commandLine);

        PipedReader readerOut = new PipedReader();
        PipedReader readerErr = new PipedReader();

        /*
         * execute the java command line
         */
        ProcessConsumer pc = sh.command(commandLine);

        pc.output(new PipedWriter(readerOut));
        pc.error(new PipedWriter(readerErr));

        process = pc.consumeInBackground();

        String line;
        BufferedReader brOut = new BufferedReader(readerOut);
        try {

            while ((line = brOut.readLine()) != null) {

                if (line.contains("INFO") || line.contains("INSTALL")) {
                    logger.log(Level.FINE, line);
                } else if (line.contains("ERROR")) {
                    logger.log(Level.SEVERE, line);
                } else {
                    logger.log(Level.INFO, line);
                }

                // || line.contains("can't install")
                if (line.contains("JadeNode started")
                        || line.contains("Can't start node")) {
                    logger.log(Level.INFO, "cancelling ...");
                    if (!process.cancel(true)) {
                        try {
                            finalize();
                        } catch (Throwable e) {
                            throw new Exception(e);
                        }
                    }
                    logger.log(Level.INFO, "cancelled ...");
                }

            }
        } finally {
            brOut.close();
        }

        BufferedReader brErr = new BufferedReader(readerErr);
        try {

            while ((line = brErr.readLine()) != null) {
                logger.log(Level.SEVERE, line);

                // || line.contains("can't install")
                if (line.contains("JadeNode started")
                        || line.contains("Can't start node")) {
                    logger.log(Level.INFO, "cancelling ...");
                    if (!process.cancel(true)) {
                        try {
                            finalize();
                        } catch (Throwable e) {
                            throw new Exception(e);
                        }
                    }
                    logger.log(Level.INFO, "cancelled ...");
                }

            }

        } finally {
            brErr.close();
        }
    }

    /**
     * @param operation
     * @return
     * @throws FileNotFoundException
     */
    private String getCommandLine(File fdfFile, String operation)
            throws FileNotFoundException {

        String file[] = parseFdfFile(fdfFile);

        StringBuffer commandLine = new StringBuffer();

        /*
         * get java
         */
        String javaHome = System.getProperty("java.home");
        commandLine.append(javaHome);
        commandLine.append(File.separatorChar);
        commandLine.append("bin");
        commandLine.append(File.separatorChar);
        commandLine.append("java ");

        /*
         * generate classpath
         */

        // get directory containing FDF librairies
        StringBuffer libDir = new StringBuffer();
        libDir.append(getEarDeployerDirectory());
        libDir.append(File.separator);
        libDir.append("lib");
        libDir.append(File.separator);

        String earLibDir = libDir.toString();

        // get FDF etc/ directory
        StringBuffer etcDir = new StringBuffer();
        etcDir.append(getEarDeployerDirectory());
        etcDir.append(File.separator);
        etcDir.append("etc");
        etcDir.append(File.separator);

        String earEtcDir = etcDir.toString();

        // construct classpath
        commandLine.append("-cp ");
        commandLine.append(earLibDir);
        commandLine.append("ow-fdf-2.0.1.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("asm-3.0.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("fractal.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("fractal-adl.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("dtdparser.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("ow_deployment_scheduling.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("ow_util_log_api.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("jonathan.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("fractal-rmi.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("fractal-rmi-tmpl.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("julia-asm-2.5.2.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("julia-mixins-2.5.2.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("julia-runtime-2.5.2.jar");
        commandLine.append(":");
        commandLine.append(file[0]);

        /*
         * add JVM properties
         */
        commandLine.append(" -Djava.security.policy=" + earEtcDir
                + "java.policy");
        commandLine
                .append(" -Dfractal.provider=org.objectweb.fractal.julia.Julia");
        commandLine
                .append(" -Djulia.loader=org.objectweb.fractal.julia.loader.DynamicLoader");
        commandLine.append(" -Djulia.loader.use-context-class-loader=true");
        commandLine.append(" -Djulia.config=" + earEtcDir + "julia.cfg");

        /*
         * java class to execute
         */
        commandLine.append(" org.objectweb.fdf.adl.Launcher");

        /*
         * add java program arguments
         */
        commandLine.append(" -fractal");
        commandLine
                .append(" \"org.objectweb.fdf.components.fdf.lib.runnable.Launcher(");
        commandLine.append(file[1].substring(0, file[1].length() - 4));
        commandLine.append(",");
        commandLine.append(operation);
        commandLine.append(",,,,)\"");

        commandLine.append(" r");

        return commandLine.toString();
    }

    /**
     * @return
     */
    private String getEarDeployerDirectory() {
        StringBuffer earDeployerLibDir = new StringBuffer();
        earDeployerLibDir.append(System.getProperty("java.io.tmpdir"));
        earDeployerLibDir.append(File.separator);
        earDeployerLibDir.append("EasyBeans-Deployer-");
        earDeployerLibDir.append(System.getProperty("user.name"));
        earDeployerLibDir.append(File.separator);
        earDeployerLibDir.append("EAR");
        earDeployerLibDir.append(File.separator);
        earDeployerLibDir.append("jasmine-design.ear");

        return earDeployerLibDir.toString();
    }

    /**
     * @param fdfFile
     * @return
     * @throws FileNotFoundException
     */
    private String[] parseFdfFile(File fdfFile) throws FileNotFoundException {

        String res[] = new String[2];

        if (!fdfFile.exists()) {
            throw new FileNotFoundException(fdfFile.getAbsolutePath());
        } else {
            res[0] = fdfFile.getPath().replace(fdfFile.getName(), "");
            res[1] = fdfFile.getName();
        }

        return res;

    }
}