/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.fdf.ra.outbound;

import com.developpez.adiguba.shell.ProcessConsumer;
import com.developpez.adiguba.shell.Shell;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.sql.Timestamp;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import org.ow2.jasmine.fdf.JASMINeNodeImpl;
import org.ow2.jasmine.fdf.ra.api.FdfConnection;

public class FdfConnectionImpl
implements FdfConnection {
    private static Logger logger = Logger.getLogger(FdfConnectionImpl.class.getName());
    Shell sh = new Shell();
    Future<Integer> process = null;

    public FdfConnectionImpl() {
        this.sh.setDirectory(new File(System.getProperty("java.io.tmpdir")));
    }

    public void install(File fdfFile) throws Exception {
        this.execute(fdfFile, "install");
    }

    public void start(File fdfFile) throws Exception {
        this.execute(fdfFile, "start");
    }

    public void stop(File fdfFile) throws Exception {
        this.execute(fdfFile, "stop");
    }

    public void install(JASMINeNodeImpl jasmineNode) throws Exception {
        this.execute(this.generateFdfFile(jasmineNode), "install");
    }

    public void start(JASMINeNodeImpl jasmineNode) throws Exception {
        this.execute(this.generateFdfFile(jasmineNode), "start");
    }

    public void stop(JASMINeNodeImpl jasmineNode) throws Exception {
        this.execute(this.generateFdfFile(jasmineNode), "stop");
    }

    public void close() throws ResourceException {
        if (this.process != null) {
            this.process.cancel(true);
        }
    }

    public Interaction createInteraction() throws ResourceException {
        logger.log(Level.INFO, "not implemented");
        return null;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        logger.log(Level.INFO, "not implemented");
        return null;
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        logger.log(Level.INFO, "not implemented");
        return null;
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        logger.log(Level.INFO, "not implemented");
        return null;
    }

    private File generateFdfFile(JASMINeNodeImpl jasminenode) throws IllegalStateException, IOException {
        String fdfName = "JASMINeNode_" + new Timestamp(System.currentTimeMillis()).toString().replace(" ", "_").replace(":", "_").replace(".", "_") + ".fdf";
        StringBuffer commandLine = new StringBuffer();
        String javaHome = System.getProperty("java.home");
        commandLine.append(javaHome);
        commandLine.append(File.separatorChar);
        commandLine.append("bin");
        commandLine.append(File.separatorChar);
        commandLine.append("java ");
        StringBuffer libDir = new StringBuffer();
        libDir.append(this.getEarDeployerDirectory());
        libDir.append(File.separator);
        libDir.append("lib");
        libDir.append(File.separator);
        StringBuffer etcDir = new StringBuffer();
        etcDir.append(this.getEarDeployerDirectory());
        etcDir.append(File.separator);
        etcDir.append("etc");
        etcDir.append(File.separator);
        String earLibDir = libDir.toString();
        commandLine.append("-cp ");
        commandLine.append(earLibDir);
        commandLine.append("velocity-1.5.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("velocity-dep-1.5.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("vm-templates.jar");
        commandLine.append(":");
        commandLine.append(etcDir.toString());
        commandLine.append(" org.ow2.jasmine.fdf.util.FdfGenerator ");
        commandLine.append("-fdf ");
        commandLine.append(fdfName);
        if (jasminenode.getRegistryHost() != null) {
            commandLine.append(" -registryhost ");
            commandLine.append(jasminenode.getRegistryHost());
        }
        if (jasminenode.getHost() != null) {
            commandLine.append(" -host ");
            commandLine.append(jasminenode.getHost());
        }
        if (jasminenode.getUser() != null) {
            commandLine.append(" -user ");
            commandLine.append(jasminenode.getUser());
        }
        if (jasminenode.getPassword() != null) {
            commandLine.append(" -password ");
            commandLine.append(jasminenode.getPassword());
        }
        if (jasminenode.getSshKey() != null) {
            commandLine.append(" -sshkey ");
            commandLine.append(jasminenode.getSshKey());
        }
        if (jasminenode.getJreHome() != null) {
            commandLine.append(" -jre ");
            commandLine.append(jasminenode.getJreHome());
        }
        if (jasminenode.getInstallDir() != null) {
            commandLine.append(" -installdir ");
            commandLine.append(jasminenode.getInstallDir());
        }
        if (etcDir.toString() != null) {
            commandLine.append(" -resourcedir ");
            commandLine.append(etcDir.toString());
        }
        if (jasminenode.getFelixProfile() != null) {
            commandLine.append(" -felixprofile ");
            commandLine.append(jasminenode.getFelixProfile());
        }
        if (jasminenode.getRegistryPort() != null) {
            commandLine.append(" -registryport ");
            commandLine.append(jasminenode.getRegistryPort());
        }
        if (jasminenode.getDiscoveryPort() != null) {
            commandLine.append(" -discoveryport ");
            commandLine.append(jasminenode.getDiscoveryPort());
        }
        if (jasminenode.getRepositoryURL() != null) {
            commandLine.append(" -obrUrl ");
            commandLine.append(jasminenode.getRepositoryURL());
        }
        this.sh.command(commandLine.toString()).consume();
        return new File(System.getProperty("java.io.tmpdir") + File.separator + fdfName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(File fdfFile, String operation) throws Exception {
        String line;
        String commandLine = this.getCommandLine(fdfFile, operation);
        logger.log(Level.INFO, commandLine);
        PipedReader readerOut = new PipedReader();
        PipedReader readerErr = new PipedReader();
        ProcessConsumer pc = this.sh.command(commandLine);
        pc.output((Appendable)new PipedWriter(readerOut));
        pc.error((Appendable)new PipedWriter(readerErr));
        this.process = pc.consumeInBackground();
        BufferedReader brOut = new BufferedReader(readerOut);
        try {
            while ((line = brOut.readLine()) != null) {
                if (line.contains("INFO") || line.contains("INSTALL")) {
                    logger.log(Level.FINE, line);
                } else if (line.contains("ERROR")) {
                    logger.log(Level.SEVERE, line);
                } else {
                    logger.log(Level.INFO, line);
                }
                if (!line.contains("JadeNode started") && !line.contains("Can't start node")) continue;
                logger.log(Level.INFO, "cancelling ...");
                if (!this.process.cancel(true)) {
                    try {
                        this.finalize();
                    }
                    catch (Throwable e) {
                        throw new Exception(e);
                    }
                }
                logger.log(Level.INFO, "cancelled ...");
            }
        }
        finally {
            brOut.close();
        }
        BufferedReader brErr = new BufferedReader(readerErr);
        try {
            while ((line = brErr.readLine()) != null) {
                logger.log(Level.SEVERE, line);
                if (!line.contains("JadeNode started") && !line.contains("Can't start node")) continue;
                logger.log(Level.INFO, "cancelling ...");
                if (!this.process.cancel(true)) {
                    try {
                        this.finalize();
                    }
                    catch (Throwable e) {
                        throw new Exception(e);
                    }
                }
                logger.log(Level.INFO, "cancelled ...");
            }
        }
        finally {
            brErr.close();
        }
    }

    private String getCommandLine(File fdfFile, String operation) throws FileNotFoundException {
        String[] file = this.parseFdfFile(fdfFile);
        StringBuffer commandLine = new StringBuffer();
        String javaHome = System.getProperty("java.home");
        commandLine.append(javaHome);
        commandLine.append(File.separatorChar);
        commandLine.append("bin");
        commandLine.append(File.separatorChar);
        commandLine.append("java ");
        StringBuffer libDir = new StringBuffer();
        libDir.append(this.getEarDeployerDirectory());
        libDir.append(File.separator);
        libDir.append("lib");
        libDir.append(File.separator);
        String earLibDir = libDir.toString();
        StringBuffer etcDir = new StringBuffer();
        etcDir.append(this.getEarDeployerDirectory());
        etcDir.append(File.separator);
        etcDir.append("etc");
        etcDir.append(File.separator);
        String earEtcDir = etcDir.toString();
        commandLine.append("-cp ");
        commandLine.append(earLibDir);
        commandLine.append("ow-fdf-2.0.1.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("asm-3.0.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("fractal.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("fractal-adl.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("dtdparser.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("ow_deployment_scheduling.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("ow_util_log_api.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("jonathan.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("fractal-rmi.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("fractal-rmi-tmpl.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("julia-asm-2.5.2.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("julia-mixins-2.5.2.jar");
        commandLine.append(":");
        commandLine.append(earLibDir);
        commandLine.append("julia-runtime-2.5.2.jar");
        commandLine.append(":");
        commandLine.append(file[0]);
        commandLine.append(" -Djava.security.policy=" + earEtcDir + "java.policy");
        commandLine.append(" -Dfractal.provider=org.objectweb.fractal.julia.Julia");
        commandLine.append(" -Djulia.loader=org.objectweb.fractal.julia.loader.DynamicLoader");
        commandLine.append(" -Djulia.loader.use-context-class-loader=true");
        commandLine.append(" -Djulia.config=" + earEtcDir + "julia.cfg");
        commandLine.append(" org.objectweb.fdf.adl.Launcher");
        commandLine.append(" -fractal");
        commandLine.append(" \"org.objectweb.fdf.components.fdf.lib.runnable.Launcher(");
        commandLine.append(file[1].substring(0, file[1].length() - 4));
        commandLine.append(",");
        commandLine.append(operation);
        commandLine.append(",,,,)\"");
        commandLine.append(" r");
        return commandLine.toString();
    }

    private String getEarDeployerDirectory() {
        StringBuffer earDeployerLibDir = new StringBuffer();
        earDeployerLibDir.append(System.getProperty("java.io.tmpdir"));
        earDeployerLibDir.append(File.separator);
        earDeployerLibDir.append("EasyBeans-Deployer-");
        earDeployerLibDir.append(System.getProperty("user.name"));
        earDeployerLibDir.append(File.separator);
        earDeployerLibDir.append("EAR");
        earDeployerLibDir.append(File.separator);
        earDeployerLibDir.append("jasmine-design.ear");
        return earDeployerLibDir.toString();
    }

    private String[] parseFdfFile(File fdfFile) throws FileNotFoundException {
        String[] res = new String[2];
        if (!fdfFile.exists()) {
            throw new FileNotFoundException(fdfFile.getAbsolutePath());
        }
        res[0] = fdfFile.getPath().replace(fdfFile.getName(), "");
        res[1] = fdfFile.getName();
        return res;
    }
}

