/**
 * JASMINe
 * Copyright (C) 2006-2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.jade.ejb;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

/**
 * 
 * @author Yann Davin (yann.davin@gmail.com)
 * @author Julien Legrand
 * 
 * 2006
 */
@Stateless
@Remote(JadeEJBRemote.class)
@DeclareRoles( { "jasmine" })
public class JadeEJB implements JadeEJBRemote {

    /**
     * 
     */
    // private static String jadeBeanName = "Jade:name=manager";
    /**
     * 
     */
    // private static ObjectName jadeBean = null;
    /**
     * 
     */
    private static MBeanServerConnection connection = null;

    /**
     * 
     */
    private Logger logger = Logger.getLogger(JadeEJB.class.getName());

    // ------------------------------------------------------------------------
    // Unidentified Method :-) (to clean)
    // ------------------------------------------------------------------------

    /**
     * @param url
     */
    // @RolesAllowed( { "jasmine" })
    // public final void setJMXURL(final String url) {
    // connection = getConnection(url);
    // }
    // ------------------------------------------------------------------------
    // Implementation of the JadeEJBRemote interface
    // ------------------------------------------------------------------------
    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.jasmine.jade.ejb.JadeEJBRemote#setJMXURL(java.lang.String,
     *      java.lang.String)
     */
    @RolesAllowed( { "jasmine" })
    public final void setJMXURL(final String host, final String port) {
        connection = getConnection("service:jmx:rmi:///jndi/rmi://" + host
                + ":" + port + "/fractaljmx_connector");
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.jasmine.jade.ejb.JadeEJBRemote#deploy(java.lang.String,
     *      java.util.Map)
     */
    @RolesAllowed( { "jasmine" })
    public final int deploy(final String idAdl,
            final Map<String, String> context) throws Exception {

        logger.log(Level.INFO, "deploy " + idAdl);

        ObjectName on = getObjectName("*resource_deployer@*:itf=deployer_service");

        int res = (Integer) connection.invoke(on, "deployForJmx", new Object[] {
                idAdl, context }, new String[] { String.class.getName(),
                Map.class.getName() });

        logger.log(Level.INFO, "Component deployed : " + res);

        return res;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.jasmine.jade.ejb.JadeEJBRemote#deploy(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    @RolesAllowed( { "jasmine" })
    public final int deploy(final String idAdl, final String host,
            final String jadeNodeNumber) throws Exception {

        logger.log(Level.INFO, "deploy " + idAdl + " on " + host + "_"
                + jadeNodeNumber);

        HashMap<String, String> context = new HashMap<String, String>();
        context.put("host", InetAddress.getAllByName(host)[0]
                .getCanonicalHostName());
        context.put("number", jadeNodeNumber);

        ObjectName on = getObjectName("*resource_deployer@*:itf=deployer_service");

        int res = (Integer) connection.invoke(on, "deployForJmx", new Object[] {
                idAdl, context }, new String[] { String.class.getName(),
                Map.class.getName() });

        logger.log(Level.INFO, "Component deployed : " + res);

        return res;

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.jasmine.jade.ejb.JadeEJBRemote#deploy(java.lang.String,
     *      java.lang.String, java.lang.String, java.lang.String)
     */
    @RolesAllowed( { "jasmine" })
    public final int deploy(final String idAdl, final String host,
            final String dirLocal, final String jadeNodeNumber)
            throws Exception {

        logger.log(Level.INFO, "deploy " + idAdl + " on " + host + "_"
                + jadeNodeNumber + ":" + dirLocal);

        HashMap<String, String> context = new HashMap<String, String>();
        context.put("host", InetAddress.getAllByName(host)[0]
                .getCanonicalHostName());
        context.put("number", jadeNodeNumber);
        context.put("dirLocal", dirLocal);

        ObjectName on = getObjectName("*resource_deployer@*:itf=deployer_service");

        int res = (Integer) connection.invoke(on, "deployForJmx", new Object[] {
                idAdl, context }, new String[] { String.class.getName(),
                Map.class.getName() });

        logger.log(Level.INFO, "Component deployed : " + res);

        return res;

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.jasmine.jade.ejb.JadeEJBRemote#deploy(java.lang.String,
     *      java.lang.String, java.lang.String, java.lang.String)
     */
    @RolesAllowed( { "jasmine" })
    public final int deploy(final String idAdl, final String host, 
            final String dirLocal, final String jadeNodeNumber, final String installerUrl) throws Exception {
        
        logger.log(Level.INFO, "deploy " + idAdl + " on " + host + "_"
                + jadeNodeNumber + ":" + dirLocal);

        HashMap<String, String> context = new HashMap<String, String>();
        context.put("host", InetAddress.getAllByName(host)[0]
                .getCanonicalHostName());
        context.put("number", jadeNodeNumber);
        context.put("dirLocal", dirLocal);
        context.put("installerUrl", installerUrl);

        ObjectName on = getObjectName("*resource_deployer@*:itf=deployer_service");

        int res = (Integer) connection.invoke(on, "deployForJmx", new Object[] {
                idAdl, context }, new String[] { String.class.getName(),
                Map.class.getName() });

        logger.log(Level.INFO, "Component deployed : " + res);

        return res;
    }


    /*
     * (non-Javadoc)
     *
     * @see org.objectweb.jasmine.jade.ejb.JadeEJBRemote#start(org.objectweb.fractal.api.Component)
     */
    @RolesAllowed( { "jasmine" })
    public final void start(final int componentID) throws Exception {

        logger.log(Level.INFO, "start : " + componentID);

        ObjectName on = getObjectName("*resource_deployer@*:itf=deployer_service");

        connection.invoke(on, "start", new Object[] { componentID },
                new String[] { Integer.TYPE.getName() });
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.jasmine.jade.ejb.JadeEJBRemote#stop(org.objectweb.fractal.api.Component)
     */
    @RolesAllowed( { "jasmine" })
    public final void stop(final int componentID) throws Exception {

        logger.log(Level.INFO, "stop : " + componentID);

        ObjectName on = getObjectName("*resource_deployer@*:itf=deployer_service");

        connection.invoke(on, "stop", new Object[] { componentID },
                new String[] { Integer.TYPE.getName() });

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.jasmine.jade.ejb.JadeEJBRemote#getAttribute(java.lang.String,
     *      java.lang.String)
     */
    // @RolesAllowed( { "jasmine" })
    // public final String getAttribute(final int componentID,
    // final String attribute) {
    // try {
    // return (String) connection.invoke(jadeBean, "getAttribute",
    // new Object[] { componentID, attribute }, new String[] {
    // Integer.TYPE.getName(), String.class.getName() });
    // } catch (Exception e) {
    // e.printStackTrace();
    // return null;
    // }
    // }
    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.jasmine.jade.ejb.JadeEJBRemote#setAttribute(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    @RolesAllowed( { "jasmine" })
    public final void setAttribute(final int componentID,
            final String attribute, final String value) throws Exception {

        logger.log(Level.INFO, "setAttribute on " + componentID + " : "
                + attribute + " = " + value);

        ObjectName on = getObjectName("*resource_deployer@*:itf=deployer_service");

        connection.invoke(on, "setAttribute", new Object[] { componentID,
                attribute, value }, new String[] { Integer.TYPE.getName(),
                String.class.getName(), String.class.getName() });
    }

    @SuppressWarnings("unchecked")
    public String[] listJadeNode() throws Exception {

        logger.log(Level.INFO, "listJadeNode");

        ObjectName on = getObjectName("*:itf=allocator");

        String allocatedNode[] = (String[]) connection.invoke(on,
                "getAllocatedComponentName", null, null);

        String freeNode[] = (String[]) connection.invoke(on,
                "getFreeComponentName", null, null);

        List allocatedList = new ArrayList(Arrays.asList(allocatedNode));
        allocatedList.addAll(new ArrayList(Arrays.asList(freeNode)));

        return (String[]) allocatedList.toArray(new String[0]);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.jasmine.jade.ejb.JadeEJBRemote#listAttributes(java.lang.String)
     */
    // @RolesAllowed( { "jasmine" })
    // public final String[] listAttributes(final String name) {
    // try {
    // return (String[]) connection.invoke(jadeBean, "listAttributes",
    // new Object[] { name }, new String[] { String.class
    // .getName() });
    // } catch (Exception e) {
    // e.printStackTrace();
    // return null;
    // }
    // }
    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.jasmine.jade.ejb.JadeEJBRemote#setRegistry(java.lang.String,
     *      int)
     */
//  @RolesAllowed( { "jasmine" })
//  public final void setRegistry(final String host, final int port) {
//      try {
//          connection.invoke(jadeBean, "setRegistry", new Object[] { host,
//                  port }, new String[] { String.class.getName(),
//                  Integer.TYPE.getName() });
//      } catch (Exception e) {
//          e.printStackTrace();
//      }
//  }

    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.jasmine.jade.ejb.JadeEJBRemote#bind(java.lang.String,
     *      java.lang.String, java.lang.String, java.lang.String)
     */
    // @RolesAllowed( { "jasmine" })
    // public final void bind(final String component1, final String itf1,
    // final String component2, final String itf2) throws Exception {
    // connection.invoke(jadeBean, "unbind", new Object[] { component1, itf1,
    // component2, itf2 }, new String[] { String.class.getName(),
    // String.class.getName() });
    // }
    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.jasmine.jade.ejb.JadeEJBRemote#unbind(java.lang.String,
     *      java.lang.String)
     */
    // @RolesAllowed( { "jasmine" })
    // public final void unbind(final String component1, final String itf1)
    // throws Exception {
    // connection.invoke(jadeBean, "unbind",
    // new Object[] { component1, itf1 }, new String[] {
    // String.class.getName(), String.class.getName() });
    // }
    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.jasmine.jade.ejb.JadeEJBRemote#listFc(java.lang.String)
     */
    // @RolesAllowed( { "jasmine" })
    // public final String[] listFc(final String component1) throws Exception {
    // return (String[]) connection.invoke(jadeBean, "listFc",
    // new Object[] { component1 }, new String[] { String.class
    // .getName() });
    // }
    // ------------------------------------------------------------------------
    // Private methods
    // ------------------------------------------------------------------------
    /**
     * @param url
     * @return
     */
    private static MBeanServerConnection getConnection(final String url) {

        JMXServiceURL jmxUrl = null;

        try {
            jmxUrl = new JMXServiceURL(url);
        } catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }

        try {
            return JMXConnectorFactory.connect(jmxUrl)
                    .getMBeanServerConnection();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * @param name
     * @return
     */
    @SuppressWarnings("unchecked")
    private static ObjectName getObjectName(String name)
            throws InstanceNotFoundException {

        try {

            Set names = connection.queryNames(ObjectName.getInstance(name),
                    null);

            if (!names.isEmpty()) {
                return (ObjectName) names.iterator().next();
            } else {
                throw new InstanceNotFoundException();
            }

        } catch (Exception e) {
            throw new InstanceNotFoundException(e.getMessage());
        }

    }
}
