/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.ejb;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.objectweb.jasmine.jade.ejb.JadeEJBRemote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Remote(value={JadeEJBRemote.class})
@DeclareRoles(value={"jasmine"})
public class JadeEJB
implements JadeEJBRemote {
    private static MBeanServerConnection connection = null;
    private Logger logger = Logger.getLogger(JadeEJB.class.getName());

    @Override
    @RolesAllowed(value={"jasmine"})
    public final void setJMXURL(String host, String port) {
        connection = JadeEJB.getConnection("service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/fractaljmx_connector");
    }

    @Override
    @RolesAllowed(value={"jasmine"})
    public final int deploy(String idAdl, Map<String, String> context) throws Exception {
        this.logger.log(Level.INFO, "deploy " + idAdl);
        ObjectName on = JadeEJB.getObjectName("*resource_deployer@*:itf=deployer_service");
        int res = (Integer)connection.invoke(on, "deployForJmx", new Object[]{idAdl, context}, new String[]{String.class.getName(), Map.class.getName()});
        this.logger.log(Level.INFO, "Component deployed : " + res);
        return res;
    }

    @Override
    @RolesAllowed(value={"jasmine"})
    public final int deploy(String idAdl, String host, String jadeNodeNumber) throws Exception {
        this.logger.log(Level.INFO, "deploy " + idAdl + " on " + host + "_" + jadeNodeNumber);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("host", InetAddress.getAllByName(host)[0].getCanonicalHostName());
        context.put("number", jadeNodeNumber);
        ObjectName on = JadeEJB.getObjectName("*resource_deployer@*:itf=deployer_service");
        int res = (Integer)connection.invoke(on, "deployForJmx", new Object[]{idAdl, context}, new String[]{String.class.getName(), Map.class.getName()});
        this.logger.log(Level.INFO, "Component deployed : " + res);
        return res;
    }

    @Override
    @RolesAllowed(value={"jasmine"})
    public final int deploy(String idAdl, String host, String dirLocal, String jadeNodeNumber) throws Exception {
        this.logger.log(Level.INFO, "deploy " + idAdl + " on " + host + "_" + jadeNodeNumber + ":" + dirLocal);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("host", InetAddress.getAllByName(host)[0].getCanonicalHostName());
        context.put("number", jadeNodeNumber);
        context.put("dirLocal", dirLocal);
        ObjectName on = JadeEJB.getObjectName("*resource_deployer@*:itf=deployer_service");
        int res = (Integer)connection.invoke(on, "deployForJmx", new Object[]{idAdl, context}, new String[]{String.class.getName(), Map.class.getName()});
        this.logger.log(Level.INFO, "Component deployed : " + res);
        return res;
    }

    @Override
    @RolesAllowed(value={"jasmine"})
    public final int deploy(String idAdl, String host, String dirLocal, String jadeNodeNumber, String installerUrl) throws Exception {
        this.logger.log(Level.INFO, "deploy " + idAdl + " on " + host + "_" + jadeNodeNumber + ":" + dirLocal);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("host", InetAddress.getAllByName(host)[0].getCanonicalHostName());
        context.put("number", jadeNodeNumber);
        context.put("dirLocal", dirLocal);
        context.put("installerUrl", installerUrl);
        ObjectName on = JadeEJB.getObjectName("*resource_deployer@*:itf=deployer_service");
        int res = (Integer)connection.invoke(on, "deployForJmx", new Object[]{idAdl, context}, new String[]{String.class.getName(), Map.class.getName()});
        this.logger.log(Level.INFO, "Component deployed : " + res);
        return res;
    }

    @Override
    @RolesAllowed(value={"jasmine"})
    public final void start(int componentID) throws Exception {
        this.logger.log(Level.INFO, "start : " + componentID);
        ObjectName on = JadeEJB.getObjectName("*resource_deployer@*:itf=deployer_service");
        connection.invoke(on, "start", new Object[]{componentID}, new String[]{Integer.TYPE.getName()});
    }

    @Override
    @RolesAllowed(value={"jasmine"})
    public final void stop(int componentID) throws Exception {
        this.logger.log(Level.INFO, "stop : " + componentID);
        ObjectName on = JadeEJB.getObjectName("*resource_deployer@*:itf=deployer_service");
        connection.invoke(on, "stop", new Object[]{componentID}, new String[]{Integer.TYPE.getName()});
    }

    @Override
    @RolesAllowed(value={"jasmine"})
    public final void setAttribute(int componentID, String attribute, String value) throws Exception {
        this.logger.log(Level.INFO, "setAttribute on " + componentID + " : " + attribute + " = " + value);
        ObjectName on = JadeEJB.getObjectName("*resource_deployer@*:itf=deployer_service");
        connection.invoke(on, "setAttribute", new Object[]{componentID, attribute, value}, new String[]{Integer.TYPE.getName(), String.class.getName(), String.class.getName()});
    }

    @Override
    public String[] listJadeNode() throws Exception {
        this.logger.log(Level.INFO, "listJadeNode");
        ObjectName on = JadeEJB.getObjectName("*:itf=allocator");
        String[] allocatedNode = (String[])connection.invoke(on, "getAllocatedComponentName", null, null);
        String[] freeNode = (String[])connection.invoke(on, "getFreeComponentName", null, null);
        ArrayList<String> allocatedList = new ArrayList<String>(Arrays.asList(allocatedNode));
        allocatedList.addAll(new ArrayList<String>(Arrays.asList(freeNode)));
        return allocatedList.toArray(new String[0]);
    }

    private static MBeanServerConnection getConnection(String url) {
        JMXServiceURL jmxUrl = null;
        try {
            jmxUrl = new JMXServiceURL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        try {
            return JMXConnectorFactory.connect(jmxUrl).getMBeanServerConnection();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ObjectName getObjectName(String name) throws InstanceNotFoundException {
        try {
            Set<ObjectName> names = connection.queryNames(ObjectName.getInstance(name), null);
            if (!names.isEmpty()) {
                return names.iterator().next();
            }
            throw new InstanceNotFoundException();
        }
        catch (Exception e) {
            throw new InstanceNotFoundException(e.getMessage());
        }
    }
}

