/**
 * JASMINe
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.jade.ejb;

import java.util.Map;

/**
 * 
 * @author Yann Davin (yann.davin@gmail.com)
 * 
 * 2006
 */
public interface JadeEJBRemote {

    /**
     * Configure the connection with the Jade JMX agent registered in RMI
     * registry listening on host:port.
     * 
     * @param host
     * @param port
     * @throws Exception
     */
    void setJMXURL(String host, String port) throws Exception;

    /**
     * connect to Fractal RMI registry listening on host:port.
     * 
     * @param host
     * @param port
     * @throws Exception
     */
//   void setRegistry(String host, int port) throws Exception;
    /**
     * @param idAdl
     * @param context
     * @return
     * @throws Exception
     */
    int deploy(String idAdl, Map<String, String> context) throws Exception;

    /**
     * deploy the architecture defined, by the ADL idAdl and configured with the
     * context, on JadeNode host_jadeNodeNumber.
     * 
     * @param idAdl
     * @param host
     * @param jadeNodeNumber
     * @return
     * @throws Exception
     */
    int deploy(String idAdl, String host, String jadeNodeNumber)
            throws Exception;

    /**
     * deploy the architecture, defined by the ADL idAdl and configured with the
     * context.
     * 
     * @param idAdl
     * @param host
     * @param dirLocal
     * @param jadeNodeNumber
     * @return
     * @throws Exception
     */
    int deploy(String idAdl, String host, String dirLocal, String jadeNodeNumber)
            throws Exception;

    /**
     * deploy the architecture, defined by the ADL idAdl and configured with the
     * context.
     *
     * @param idAdl
     * @param host
     * @param dirLocal
     * @param jadeNodeNumber
     * @param installerUrl
     * @return
     * @throws Exception
     */
    int deploy(String idAdl, String host, String dirLocal, String jadeNodeNumber, 
            String installerUrl) throws Exception;

    /**
     * start the architecture modelized with the Fractal component c.
     * 
     * @param c
     * @throws Exception
     */
    void start(int componentId) throws Exception;

    /**
     * stop the architecture modelized with the Fractal component c.
     * 
     * @param c
     * @throws Exception
     */
    void stop(int componentId) throws Exception;

    /**
     * @param component1
     * @param itf1
     * @param component2
     * @param itf2
     * @throws Exception
     */
    // void bind(String component1, String itf1, String component2, String itf2)
    // throws Exception;
    /**
     * @param component1
     * @param itf1
     * @throws Exception
     */
    // void unbind(String component1, String itf1) throws Exception;
    /**
     * @param component1
     * @return
     * @throws Exception
     */
    // String[] listFc(String component1) throws Exception;
    /**
     * @param componentID
     * @param attribute
     * @return
     * @throws Exception
     */
    // String getAttribute(int componentID, String attribute) throws Exception;
    /**
     * @param componentID
     * @param attribute
     * @param value
     * @throws Exception
     */
    void setAttribute(int componentID, String attribute, String value)
            throws Exception;

    /**
     * @param name
     * @return
     * @throws Exception
     */
    // String[] listAttributes(String name) throws Exception;
    
    
    /**
     * @return
     * @throws Exception
     */
    String[] listJadeNode() throws Exception;

}
