/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.metadataparser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.apache.felix.bundlerepository.metadataparser.ClassUtility;
import org.apache.felix.bundlerepository.metadataparser.ReplaceUtility;
import org.apache.felix.bundlerepository.metadataparser.kxmlsax.KXml2SAXHandler;

public class XmlCommonHandler
implements KXml2SAXHandler {
    private static final String PI_MAPPING = "mapping";
    public static final String METADATAPARSER_PIS = "METADATAPARSER_PIS";
    public static final String METADATAPARSER_TYPES = "METADATAPARSER_TYPES";
    private int columnNumber;
    private int lineNumber;
    private boolean traceFlag = false;
    private static String VALUE = "value";
    private XmlStackElement root;
    private Stack elementStack = new Stack();
    private Map pis = new HashMap();
    private boolean missingPIExceptionFlag = false;
    private Map types = new HashMap();
    private TypeEntry defaultType;
    private StringBuffer currentText;
    private Map context = new HashMap();

    public XmlCommonHandler() {
        this.context.put(METADATAPARSER_PIS, this.pis);
        this.context.put(METADATAPARSER_TYPES, this.types);
    }

    public void addPI(String piname, Class clazz) {
        this.pis.put(piname, clazz);
    }

    public void setMissingPIExceptionFlag(boolean flag) {
        this.missingPIExceptionFlag = flag;
    }

    public void addType(String qname, Object instanceFactory, Class castClass, Method defaultAddMethod) throws Exception {
        TypeEntry typeEntry;
        try {
            typeEntry = new TypeEntry(instanceFactory, castClass, defaultAddMethod);
        }
        catch (Exception e) {
            throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + qname + " : " + e.getMessage());
        }
        this.types.put(qname, typeEntry);
        this.trace("element " + qname + " : " + typeEntry.toString());
    }

    public void setDefaultType(Object instanceFactory, Class castClass, Method defaultAddMethod) throws Exception {
        TypeEntry typeEntry;
        try {
            typeEntry = new TypeEntry(instanceFactory, castClass, defaultAddMethod);
        }
        catch (Exception e) {
            throw new Exception(this.lineNumber + "," + this.columnNumber + ": default element : " + e.getMessage());
        }
        this.defaultType = typeEntry;
        this.trace("default element  : " + typeEntry.toString());
    }

    public void setContext(Map context) {
        this.context = context;
    }

    public Map getContext() {
        return this.context;
    }

    public Object getRoot() {
        return this.root.object;
    }

    public void characters(char[] ch, int offset, int length) throws Exception {
        if (this.currentText != null) {
            this.currentText.append(ch, offset, length);
        }
    }

    private String adderOf(Class clazz) {
        return "add" + ClassUtility.capitalize(ClassUtility.classOf(clazz.getName()));
    }

    private String adderOf(String key) {
        return "add" + ClassUtility.capitalize(key);
    }

    private String setterOf(Class clazz) {
        return "set" + ClassUtility.capitalize(ClassUtility.classOf(clazz.getName()));
    }

    private String setterOf(String key) {
        return "set" + ClassUtility.capitalize(key);
    }

    private void setObjectContext(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = null;
        try {
            method = object.getClass().getDeclaredMethod("setContext", Map.class);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method != null) {
            this.trace(method.getName());
            try {
                method.invoke(object, this.context);
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace(System.err);
                throw e;
            }
        }
    }

    private void invokeProcess(Object object) throws Throwable {
        Method method = null;
        try {
            method = object.getClass().getDeclaredMethod("process", null);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method != null) {
            this.trace(method.getName());
            try {
                method.invoke(object, null);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    private void setObjectParent(Object object, Object parent) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Method method = null;
        try {
            method = object.getClass().getDeclaredMethod("setParent", parent.getClass());
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method != null) {
            this.trace(method.getName());
            try {
                method.invoke(object, parent);
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace(System.err);
                throw e;
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Properties attrib) throws Exception {
        this.trace("START (" + this.lineNumber + "," + this.columnNumber + "):" + uri + ":" + qName);
        TypeEntry type = (TypeEntry)this.types.get(qName);
        if (type == null) {
            type = this.defaultType;
        }
        Object obj = null;
        if (type != null) {
            try {
                type.newInstanceMethod.setAccessible(true);
                obj = type.newInstanceMethod.invoke(type.instanceFactory, null);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.elementStack.isEmpty()) {
                XmlStackElement parent = (XmlStackElement)this.elementStack.peek();
                this.setObjectParent(obj, parent.object);
            }
            this.setObjectContext(obj);
            Set<Object> keyset = attrib.keySet();
            for (String string : keyset) {
                String value = ReplaceUtility.replace((String)attrib.get(string), this.context);
                Method method = null;
                if (!(obj instanceof String)) {
                    try {
                        method = type.instanceClass.getDeclaredMethod(this.setterOf(string), String.class);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                    if (method == null) {
                        try {
                            method = type.instanceClass.getDeclaredMethod(this.adderOf(string), String.class);
                        }
                        catch (NoSuchMethodException e) {
                            // empty catch block
                        }
                    }
                }
                if (method != null) {
                    this.trace(method.getName());
                    try {
                        method.invoke(obj, (Object[])new String[]{value});
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        e.getTargetException().printStackTrace(System.err);
                        throw e;
                    }
                }
                if (obj instanceof String) {
                    if (string.equals(VALUE)) {
                        obj = value;
                        continue;
                    }
                    throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + "String element " + qName + " cannot have other attribute than value");
                }
                if (type.defaultAddMethod != null) {
                    Class<?>[] parameterTypes = type.defaultAddMethod.getParameterTypes();
                    if (parameterTypes.length == 2 && parameterTypes[0].isAssignableFrom(String.class) && parameterTypes[1].isAssignableFrom(String.class)) {
                        type.defaultAddMethod.invoke(obj, (Object[])new String[]{string, value});
                        continue;
                    }
                    if (parameterTypes.length == 1 && parameterTypes[0].isAssignableFrom(String.class)) {
                        type.defaultAddMethod.invoke(obj, (Object[])new String[]{value});
                        continue;
                    }
                    throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + "class " + type.instanceFactory.getClass().getName() + " for element " + qName + " does not support the attribute " + string);
                }
                throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + "class " + type.instanceFactory.getClass().getName() + " for element " + qName + " does not support the attribute " + string);
            }
        } else {
            throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + "this element " + qName + " has not corresponding class");
        }
        XmlStackElement element = new XmlStackElement(qName, obj);
        if (this.root == null) {
            this.root = element;
        }
        this.elementStack.push(element);
        this.currentText = new StringBuffer();
        this.trace("START/ (" + this.lineNumber + "," + this.columnNumber + "):" + uri + ":" + qName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String uri, String localName, String qName) throws Exception {
        this.trace("END (" + this.lineNumber + "," + this.columnNumber + "):" + uri + ":" + qName);
        XmlStackElement element = (XmlStackElement)this.elementStack.pop();
        TypeEntry elementType = (TypeEntry)this.types.get(element.qname);
        if (elementType == null) {
            elementType = this.defaultType;
        }
        if (this.currentText != null && this.currentText.length() != 0) {
            String currentStr = ReplaceUtility.replace(this.currentText.toString(), this.context).trim();
            this.trace("current text:" + currentStr);
            Method method = null;
            try {
                method = elementType.castClass.getDeclaredMethod("addText", String.class);
            }
            catch (NoSuchMethodException e) {
                try {
                    method = elementType.castClass.getDeclaredMethod("setText", String.class);
                }
                catch (NoSuchMethodException e2) {
                    // empty catch block
                }
            }
            if (method != null) {
                this.trace(method.getName());
                try {
                    method.invoke(element.object, (Object[])new String[]{currentStr});
                }
                catch (InvocationTargetException e) {
                    e.getTargetException().printStackTrace(System.err);
                    throw e;
                }
            } else if (String.class.isAssignableFrom(elementType.castClass)) {
                String str = (String)element.object;
                if (str.length() != 0) {
                    throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + "String element " + qName + " cannot have both PCDATA and an attribute value");
                }
                element.object = currentStr;
            }
        }
        this.currentText = null;
        if (!this.elementStack.isEmpty()) {
            XmlStackElement parent = (XmlStackElement)this.elementStack.peek();
            TypeEntry parentType = (TypeEntry)this.types.get(parent.qname);
            if (parentType == null) {
                parentType = this.defaultType;
            }
            String capqName = ClassUtility.capitalize(qName);
            Method method = null;
            try {
                method = parentType.instanceClass.getDeclaredMethod(this.adderOf(capqName), elementType.castClass);
            }
            catch (NoSuchMethodException e) {
                this.trace("NoSuchMethodException: " + this.adderOf(capqName) + "(" + elementType.castClass.getName() + ")");
            }
            if (method == null) {
                try {
                    method = parentType.instanceClass.getDeclaredMethod(this.setterOf(capqName), elementType.castClass);
                }
                catch (NoSuchMethodException e) {
                    this.trace("NoSuchMethodException: " + this.setterOf(capqName) + "(" + elementType.castClass.getName() + ")");
                }
            }
            if (method != null) {
                this.trace(method.getName());
                try {
                    method.setAccessible(true);
                    method.invoke(parent.object, element.object);
                }
                catch (InvocationTargetException e) {
                    e.getTargetException().printStackTrace(System.err);
                    throw e;
                }
            } else {
                if (parentType.defaultAddMethod == null) throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + " element " + parent.qname + " cannot have an attribute " + qName + " of type " + elementType.castClass);
                Class<?>[] parameterTypes = parentType.defaultAddMethod.getParameterTypes();
                if (parameterTypes.length == 2 && parameterTypes[0].isAssignableFrom(String.class) && parameterTypes[1].isAssignableFrom(elementType.castClass)) {
                    parentType.defaultAddMethod.invoke(parent.object, qName, element.object);
                } else {
                    if (parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(elementType.castClass)) throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + " element " + parent.qname + " cannot have an attribute " + qName + " of type " + elementType.castClass);
                    parentType.defaultAddMethod.invoke(parent.object, element.object);
                }
            }
        }
        try {
            this.invokeProcess(element);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        this.trace("END/ (" + this.lineNumber + "," + this.columnNumber + "):" + uri + ":" + qName);
    }

    public void setTrace(boolean trace) {
        this.traceFlag = trace;
    }

    private void trace(String msg) {
        if (this.traceFlag) {
            System.err.println(msg);
        }
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public void processingInstruction(String target, String data) throws Exception {
        this.trace("PI:" + target + ";" + data);
        this.trace("ignore PI : " + data);
    }

    public void processingInstructionForMapping(String target, String data) throws Exception {
        if (target == null ? !data.startsWith(PI_MAPPING) : !target.equals(PI_MAPPING)) {
            return;
        }
        String datt = "defaultclass=\"";
        int dstart = data.indexOf(datt);
        if (dstart != -1) {
            int dend = data.indexOf("\"", dstart + datt.length());
            if (dend == -1) {
                throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + " \"defaultclass\" attribute in \"mapping\" PI is not quoted");
            }
            String classname = data.substring(dstart + datt.length(), dend);
            Class<?> clazz = null;
            try {
                clazz = this.getClass().getClassLoader().loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + " cannot found class " + classname + " for \"mapping\" PI");
            }
            Method defaultdefaultAddMethod = null;
            this.setDefaultType(clazz, null, defaultdefaultAddMethod);
            return;
        }
        String eatt = "element=\"";
        int estart = data.indexOf(eatt);
        if (estart == -1) {
            throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + " missing \"element\" attribute in \"mapping\" PI");
        }
        int eend = data.indexOf("\"", estart + eatt.length());
        if (eend == -1) {
            throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + " \"element\" attribute in \"mapping\" PI is not quoted");
        }
        String element = data.substring(estart + eatt.length(), eend);
        String catt = "class=\"";
        int cstart = data.indexOf(catt);
        if (cstart == -1) {
            throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + " missing \"class\" attribute in \"mapping\" PI");
        }
        int cend = data.indexOf("\"", cstart + catt.length());
        if (cend == -1) {
            throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + " \"class\" attribute in \"mapping\" PI is not quoted");
        }
        String classname = data.substring(cstart + catt.length(), cend);
        String castname = null;
        String castatt = "cast=\"";
        int caststart = data.indexOf(castatt);
        if (caststart != -1) {
            int castend = data.indexOf("\"", cstart + castatt.length());
            if (castend == -1) {
                throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + " \"cast\" attribute in \"mapping\" PI is not quoted");
            }
            castname = data.substring(caststart + castatt.length(), castend);
        }
        Class<?> clazz = null;
        try {
            clazz = this.getClass().getClassLoader().loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + " cannot found class " + classname + " for \"mapping\" PI");
        }
        Class castClazz = null;
        if (castname != null) {
            try {
                clazz = this.getClass().getClassLoader().loadClass(castname);
            }
            catch (ClassNotFoundException e) {
                throw new Exception(this.lineNumber + "," + this.columnNumber + ":" + " cannot found cast class " + classname + " for \"mapping\" PI");
            }
        }
        Method defaultAddMethod = null;
        this.addType(element, clazz, castClazz, defaultAddMethod);
    }

    public class TypeEntry {
        public final Object instanceFactory;
        public final Class instanceClass;
        public final Method newInstanceMethod;
        public final Class castClass;
        public final Method defaultAddMethod;

        public TypeEntry(Object instanceFactory, Class castClass, Method defaultAddMethod) throws Exception {
            this.instanceFactory = instanceFactory;
            try {
                if (instanceFactory instanceof Class) {
                    this.newInstanceMethod = instanceFactory.getClass().getDeclaredMethod("newInstance", null);
                    if (castClass == null) {
                        this.castClass = (Class)instanceFactory;
                    } else {
                        if (!castClass.isAssignableFrom((Class)instanceFactory)) {
                            throw new Exception("instanceFactory " + instanceFactory.getClass().getName() + " could not instanciate objects assignable to " + castClass.getName());
                        }
                        this.castClass = castClass;
                    }
                    this.instanceClass = (Class)instanceFactory;
                } else {
                    this.newInstanceMethod = instanceFactory.getClass().getDeclaredMethod("newInstance", null);
                    Class<?> returnType = this.newInstanceMethod.getReturnType();
                    if (castClass == null) {
                        this.castClass = returnType;
                    } else {
                        if (!castClass.isAssignableFrom(returnType)) {
                            throw new Exception("instanceFactory " + instanceFactory.getClass().getName() + " could not instanciate objects assignable to " + castClass.getName());
                        }
                        this.castClass = castClass;
                    }
                    this.instanceClass = returnType;
                }
            }
            catch (NoSuchMethodException e) {
                throw new Exception("instanceFactory " + instanceFactory.getClass().getName() + " should have a newInstance method");
            }
            this.defaultAddMethod = defaultAddMethod;
            if (this.defaultAddMethod != null) {
                this.defaultAddMethod.setAccessible(true);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            if (this.instanceFactory instanceof Class) {
                sb.append("instanceFactory=").append(((Class)this.instanceFactory).getName());
            } else {
                sb.append("instanceFactory=").append(this.instanceFactory.getClass().getName());
            }
            sb.append(",instanceClass=").append(this.instanceClass.getName());
            sb.append(",castClass=").append(this.castClass.getName());
            sb.append(",defaultAddMethod=");
            if (this.defaultAddMethod == null) {
                sb.append("");
            } else {
                sb.append(this.defaultAddMethod.getName());
            }
            sb.append("]");
            return sb.toString();
        }
    }

    private class XmlStackElement {
        public final String qname;
        public Object object;

        public XmlStackElement(String qname, Object object) {
            this.qname = qname;
            this.object = object;
        }
    }
}

