/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import org.objectweb.jasmine.jade.util.JadeException;
import org.objectweb.jasmine.jade.util.Logger;

public class StreamForwarder
extends Thread {
    private OutputStream ostream;
    private InputStream istream;
    private String prefix;
    private boolean found;
    private String wantedStr;

    public StreamForwarder(String prefix, InputStream istream, OutputStream ostream) {
        this.ostream = ostream;
        this.istream = istream;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareWaitForString(String str) throws JadeException {
        StreamForwarder streamForwarder = this;
        synchronized (streamForwarder) {
            if (this.wantedStr != null) {
                throw new JadeException("Only one grep at a time");
            }
            this.wantedStr = str;
            this.found = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForString() throws JadeException {
        StreamForwarder streamForwarder = this;
        synchronized (streamForwarder) {
            if (!this.found) {
                if (this.wantedStr == null) {
                    throw new JadeException("No search prepared");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.istream));
        PrintStream pstream = new PrintStream(this.ostream);
        pstream.println(this.prefix + "-- begin --");
        try {
            String next;
            while ((next = br.readLine()) != null) {
                pstream.println(this.prefix + next);
                StreamForwarder streamForwarder = this;
                synchronized (streamForwarder) {
                    if (this.wantedStr != null && next.indexOf(this.wantedStr) != -1) {
                        this.found = true;
                        this.wantedStr = null;
                        this.notify();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pstream.println(this.prefix + "--- end ---");
        StreamForwarder streamForwarder = this;
        synchronized (streamForwarder) {
            if (this.wantedStr == null) return;
            Logger.println("WARNING: StreamForwarder.waitForStdout never returned! Releasing thread");
            this.found = true;
            this.wantedStr = null;
            this.notify();
            return;
        }
    }
}

