/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.bundlerepository;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.felix.bundlerepository.LocalRepositoryImpl;
import org.apache.felix.bundlerepository.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverImpl
extends org.apache.felix.bundlerepository.ResolverImpl {
    public ResolverImpl(BundleContext context, RepositoryAdmin admin) {
        super(context, admin);
    }

    @Override
    public synchronized void deploy(boolean start) {
        this.deployAndSaveDependencies(start);
    }

    public synchronized List<Bundle> deployAndSaveDependencies(boolean start) {
        int i;
        int i2;
        ArrayList<Bundle> dependencies = new ArrayList<Bundle>();
        if (!this.m_resolved && !this.resolve()) {
            System.err.println("Resolver: Cannot resolve target resources.");
            return null;
        }
        if (this.m_local.getLastModified() != this.m_local.getCurrentTimeStamp()) {
            throw new IllegalStateException("Framework state has changed, must resolve again.");
        }
        HashMap<Resource, Resource> deployMap = new HashMap<Resource, Resource>();
        Resource[] resources = this.getAddedResources();
        for (i2 = 0; resources != null && i2 < resources.length; ++i2) {
            deployMap.put(resources[i2], resources[i2]);
        }
        resources = this.getRequiredResources();
        for (i2 = 0; resources != null && i2 < resources.length; ++i2) {
            deployMap.put(resources[i2], resources[i2]);
        }
        resources = this.getOptionalResources();
        for (i2 = 0; resources != null && i2 < resources.length; ++i2) {
            deployMap.put(resources[i2], resources[i2]);
        }
        Resource[] deployResources = deployMap.keySet().toArray(new Resource[deployMap.size()]);
        ArrayList<Bundle> startList = new ArrayList<Bundle>();
        for (i = 0; i < deployResources.length; ++i) {
            LocalRepositoryImpl.LocalResourceImpl localResource = this.findUpdatableLocalResource(deployResources[i]);
            if (localResource != null) {
                dependencies.add(localResource.getBundle());
                if (!this.isResourceUpdatable(localResource, deployResources[i], deployResources) || localResource.equals(deployResources[i])) continue;
                try {
                    localResource.getBundle().update(deployResources[i].getURL().openStream());
                    if (!start) continue;
                    startList.add(localResource.getBundle());
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("Resolver: Update error - " + Util.getBundleName(localResource.getBundle()));
                    ex.printStackTrace(System.err);
                    return null;
                }
            }
            try {
                URL url = deployResources[i].getURL();
                if (url == null) continue;
                Bundle bundle = this.m_context.installBundle("obr://" + deployResources[i].getSymbolicName() + "/" + System.currentTimeMillis(), url.openStream());
                dependencies.add(bundle);
                if (!start) continue;
                startList.add(bundle);
                continue;
            }
            catch (Exception ex) {
                System.err.println("Resolver: Install error - " + deployResources[i].getSymbolicName());
                ex.printStackTrace(System.err);
                return null;
            }
        }
        for (i = 0; i < startList.size(); ++i) {
            try {
                ((Bundle)startList.get(i)).start();
                continue;
            }
            catch (BundleException ex) {
                System.err.println("Resolver: Start error - " + (Object)((Object)ex));
            }
        }
        return dependencies;
    }
}

