/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;

public class EventDispatcher {
    private static final int LISTENER_BUNDLE_OFFSET = 0;
    private static final int LISTENER_CLASS_OFFSET = 1;
    private static final int LISTENER_OBJECT_OFFSET = 2;
    private static final int LISTENER_FILTER_OFFSET = 3;
    private static final int LISTENER_SECURITY_OFFSET = 4;
    private static final int LISTENER_ARRAY_INCREMENT = 5;
    private Logger m_logger = null;
    private static final Object[] m_emptyList = new Object[0];
    private Object[] m_frameworkListeners = m_emptyList;
    private Object[] m_bundleListeners = m_emptyList;
    private Object[] m_syncBundleListeners = m_emptyList;
    private Object[] m_serviceListeners = m_emptyList;
    private static Thread m_thread = null;
    private static String m_threadLock = new String("thread lock");
    private static int m_references = 0;
    private static volatile boolean m_stopping = false;
    private static final ArrayList m_requestList = new ArrayList();
    private static final ArrayList m_requestPool = new ArrayList();
    static /* synthetic */ Class class$org$osgi$framework$FrameworkListener;
    static /* synthetic */ Class class$org$osgi$framework$BundleListener;
    static /* synthetic */ Class class$org$osgi$framework$SynchronousBundleListener;
    static /* synthetic */ Class class$org$osgi$framework$ServiceListener;

    private EventDispatcher(Logger logger) {
        this.m_logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventDispatcher start(Logger logger) {
        EventDispatcher eventDispatcher = new EventDispatcher(logger);
        String string = m_threadLock;
        synchronized (string) {
            if (m_thread == null || !m_thread.isAlive()) {
                m_stopping = false;
                m_thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            EventDispatcher.run();
                        }
                        finally {
                            String string = m_threadLock;
                            synchronized (string) {
                                m_thread = null;
                                m_stopping = false;
                                m_references = 0;
                                m_threadLock.notifyAll();
                            }
                        }
                    }
                }, "FelixDispatchQueue");
                m_thread.start();
            }
            ++m_references;
        }
        return eventDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = m_threadLock;
        synchronized (object) {
            if (m_thread == null || m_stopping) {
                return;
            }
            if (--m_references > 0) {
                return;
            }
            m_stopping = true;
        }
        object = m_requestList;
        synchronized (object) {
            m_requestList.notify();
        }
        object = m_threadLock;
        synchronized (object) {
            while (m_thread != null) {
                try {
                    m_threadLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Bundle bundle, Class clazz, EventListener l, Filter filter) {
        if (l == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (!clazz.isInstance(l)) {
            throw new IllegalArgumentException("Listener not of type " + clazz.getName());
        }
        if (this.updateListener(bundle, clazz, l, filter)) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            Object[] listeners = null;
            Object acc = null;
            if (clazz == (class$org$osgi$framework$FrameworkListener == null ? (class$org$osgi$framework$FrameworkListener = EventDispatcher.class$("org.osgi.framework.FrameworkListener")) : class$org$osgi$framework$FrameworkListener)) {
                listeners = this.m_frameworkListeners;
            } else if (clazz == (class$org$osgi$framework$BundleListener == null ? (class$org$osgi$framework$BundleListener = EventDispatcher.class$("org.osgi.framework.BundleListener")) : class$org$osgi$framework$BundleListener)) {
                listeners = (class$org$osgi$framework$SynchronousBundleListener == null ? (class$org$osgi$framework$SynchronousBundleListener = EventDispatcher.class$("org.osgi.framework.SynchronousBundleListener")) : class$org$osgi$framework$SynchronousBundleListener).isInstance(l) ? this.m_syncBundleListeners : this.m_bundleListeners;
            } else if (clazz == (class$org$osgi$framework$ServiceListener == null ? (class$org$osgi$framework$ServiceListener = EventDispatcher.class$("org.osgi.framework.ServiceListener")) : class$org$osgi$framework$ServiceListener)) {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    acc = sm.getSecurityContext();
                }
                listeners = this.m_serviceListeners;
            } else {
                throw new IllegalArgumentException("Unknown listener: " + l.getClass());
            }
            if (listeners == m_emptyList) {
                listeners = new Object[]{bundle, clazz, l, filter, acc};
            } else {
                Object[] newList = new Object[listeners.length + 5];
                System.arraycopy(listeners, 0, newList, 0, listeners.length);
                newList[listeners.length + 0] = bundle;
                newList[listeners.length + 1] = clazz;
                newList[listeners.length + 2] = l;
                newList[listeners.length + 3] = filter;
                newList[listeners.length + 4] = acc;
                listeners = newList;
            }
            if (clazz == (class$org$osgi$framework$FrameworkListener == null ? (class$org$osgi$framework$FrameworkListener = EventDispatcher.class$("org.osgi.framework.FrameworkListener")) : class$org$osgi$framework$FrameworkListener)) {
                this.m_frameworkListeners = listeners;
            } else if (clazz == (class$org$osgi$framework$BundleListener == null ? (class$org$osgi$framework$BundleListener = EventDispatcher.class$("org.osgi.framework.BundleListener")) : class$org$osgi$framework$BundleListener)) {
                if ((class$org$osgi$framework$SynchronousBundleListener == null ? (class$org$osgi$framework$SynchronousBundleListener = EventDispatcher.class$("org.osgi.framework.SynchronousBundleListener")) : class$org$osgi$framework$SynchronousBundleListener).isInstance(l)) {
                    this.m_syncBundleListeners = listeners;
                } else {
                    this.m_bundleListeners = listeners;
                }
            } else if (clazz == (class$org$osgi$framework$ServiceListener == null ? (class$org$osgi$framework$ServiceListener = EventDispatcher.class$("org.osgi.framework.ServiceListener")) : class$org$osgi$framework$ServiceListener)) {
                this.m_serviceListeners = listeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Bundle bundle, Class clazz, EventListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (!clazz.isInstance(l)) {
            throw new IllegalArgumentException("Listener not of type " + clazz.getName());
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            Object[] listeners = null;
            if (clazz == (class$org$osgi$framework$FrameworkListener == null ? (class$org$osgi$framework$FrameworkListener = EventDispatcher.class$("org.osgi.framework.FrameworkListener")) : class$org$osgi$framework$FrameworkListener)) {
                listeners = this.m_frameworkListeners;
            } else if (clazz == (class$org$osgi$framework$BundleListener == null ? (class$org$osgi$framework$BundleListener = EventDispatcher.class$("org.osgi.framework.BundleListener")) : class$org$osgi$framework$BundleListener)) {
                listeners = (class$org$osgi$framework$SynchronousBundleListener == null ? (class$org$osgi$framework$SynchronousBundleListener = EventDispatcher.class$("org.osgi.framework.SynchronousBundleListener")) : class$org$osgi$framework$SynchronousBundleListener).isInstance(l) ? this.m_syncBundleListeners : this.m_bundleListeners;
            } else if (clazz == (class$org$osgi$framework$ServiceListener == null ? (class$org$osgi$framework$ServiceListener = EventDispatcher.class$("org.osgi.framework.ServiceListener")) : class$org$osgi$framework$ServiceListener)) {
                listeners = this.m_serviceListeners;
            } else {
                throw new IllegalArgumentException("Unknown listener: " + l.getClass());
            }
            int idx = -1;
            for (int i = 0; i < listeners.length; i += 5) {
                if (!listeners[i + 0].equals(bundle) || listeners[i + 1] != clazz || listeners[i + 2] != l) continue;
                idx = i;
                break;
            }
            if (idx >= 0) {
                if (listeners.length - 5 == 0) {
                    listeners = m_emptyList;
                } else {
                    Object[] newList = new Object[listeners.length - 5];
                    System.arraycopy(listeners, 0, newList, 0, idx);
                    if (idx < newList.length) {
                        System.arraycopy(listeners, idx + 5, newList, idx, newList.length - idx);
                    }
                    listeners = newList;
                }
            }
            if (clazz == (class$org$osgi$framework$FrameworkListener == null ? (class$org$osgi$framework$FrameworkListener = EventDispatcher.class$("org.osgi.framework.FrameworkListener")) : class$org$osgi$framework$FrameworkListener)) {
                this.m_frameworkListeners = listeners;
            } else if (clazz == (class$org$osgi$framework$BundleListener == null ? (class$org$osgi$framework$BundleListener = EventDispatcher.class$("org.osgi.framework.BundleListener")) : class$org$osgi$framework$BundleListener)) {
                if ((class$org$osgi$framework$SynchronousBundleListener == null ? (class$org$osgi$framework$SynchronousBundleListener = EventDispatcher.class$("org.osgi.framework.SynchronousBundleListener")) : class$org$osgi$framework$SynchronousBundleListener).isInstance(l)) {
                    this.m_syncBundleListeners = listeners;
                } else {
                    this.m_bundleListeners = listeners;
                }
            } else if (clazz == (class$org$osgi$framework$ServiceListener == null ? (class$org$osgi$framework$ServiceListener = EventDispatcher.class$("org.osgi.framework.ServiceListener")) : class$org$osgi$framework$ServiceListener)) {
                this.m_serviceListeners = listeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeners(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            EventListener l;
            Class clazz;
            Bundle registeredBundle;
            int i;
            Object[] listeners = this.m_frameworkListeners;
            for (i = listeners.length - 5; i >= 0; i -= 5) {
                registeredBundle = (Bundle)listeners[i + 0];
                if (!bundle.equals(registeredBundle)) continue;
                clazz = (Class)listeners[i + 1];
                l = (EventListener)listeners[i + 2];
                this.removeListener(bundle, clazz, l);
            }
            listeners = this.m_bundleListeners;
            for (i = listeners.length - 5; i >= 0; i -= 5) {
                registeredBundle = (Bundle)listeners[i + 0];
                if (!bundle.equals(registeredBundle)) continue;
                clazz = (Class)listeners[i + 1];
                l = (EventListener)listeners[i + 2];
                this.removeListener(bundle, clazz, l);
            }
            listeners = this.m_syncBundleListeners;
            for (i = listeners.length - 5; i >= 0; i -= 5) {
                registeredBundle = (Bundle)listeners[i + 0];
                if (!bundle.equals(registeredBundle)) continue;
                clazz = (Class)listeners[i + 1];
                l = (EventListener)listeners[i + 2];
                this.removeListener(bundle, clazz, l);
            }
            listeners = this.m_serviceListeners;
            for (i = listeners.length - 5; i >= 0; i -= 5) {
                registeredBundle = (Bundle)listeners[i + 0];
                if (!bundle.equals(registeredBundle)) continue;
                clazz = (Class)listeners[i + 1];
                l = (EventListener)listeners[i + 2];
                this.removeListener(bundle, clazz, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateListener(Bundle bundle, Class clazz, EventListener l, Filter filter) {
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            Object[] listeners = null;
            if (clazz == (class$org$osgi$framework$FrameworkListener == null ? (class$org$osgi$framework$FrameworkListener = EventDispatcher.class$("org.osgi.framework.FrameworkListener")) : class$org$osgi$framework$FrameworkListener)) {
                listeners = this.m_frameworkListeners;
            } else if (clazz == (class$org$osgi$framework$BundleListener == null ? (class$org$osgi$framework$BundleListener = EventDispatcher.class$("org.osgi.framework.BundleListener")) : class$org$osgi$framework$BundleListener)) {
                listeners = (class$org$osgi$framework$SynchronousBundleListener == null ? (class$org$osgi$framework$SynchronousBundleListener = EventDispatcher.class$("org.osgi.framework.SynchronousBundleListener")) : class$org$osgi$framework$SynchronousBundleListener).isInstance(l) ? this.m_syncBundleListeners : this.m_bundleListeners;
            } else if (clazz == (class$org$osgi$framework$ServiceListener == null ? (class$org$osgi$framework$ServiceListener = EventDispatcher.class$("org.osgi.framework.ServiceListener")) : class$org$osgi$framework$ServiceListener)) {
                listeners = this.m_serviceListeners;
            }
            for (int i = 0; i < listeners.length; i += 5) {
                if (!listeners[i + 0].equals(bundle) || listeners[i + 1] != clazz || listeners[i + 2] != l) continue;
                if (clazz != (class$org$osgi$framework$FrameworkListener == null ? (class$org$osgi$framework$FrameworkListener = EventDispatcher.class$("org.osgi.framework.FrameworkListener")) : class$org$osgi$framework$FrameworkListener) && clazz != (class$org$osgi$framework$BundleListener == null ? (class$org$osgi$framework$BundleListener = EventDispatcher.class$("org.osgi.framework.BundleListener")) : class$org$osgi$framework$BundleListener) && clazz == (class$org$osgi$framework$ServiceListener == null ? (class$org$osgi$framework$ServiceListener = EventDispatcher.class$("org.osgi.framework.ServiceListener")) : class$org$osgi$framework$ServiceListener)) {
                    listeners[i + 3] = filter;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFrameworkEvent(FrameworkEvent event) {
        Object[] listeners = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            listeners = this.m_frameworkListeners;
        }
        this.fireEventAsynchronously(this.m_logger, 0, listeners, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireBundleEvent(BundleEvent event) {
        Object[] listeners = null;
        Object[] syncListeners = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            listeners = this.m_bundleListeners;
            syncListeners = this.m_syncBundleListeners;
        }
        EventDispatcher.fireEventImmediately(this.m_logger, 1, syncListeners, event);
        if (event.getType() != 128 && event.getType() != 256) {
            this.fireEventAsynchronously(this.m_logger, 1, listeners, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireServiceEvent(ServiceEvent event) {
        Object[] listeners = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            listeners = this.m_serviceListeners;
        }
        EventDispatcher.fireEventImmediately(this.m_logger, 2, listeners, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEventAsynchronously(Logger logger, int type, Object[] listeners, EventObject event) {
        if (m_stopping || m_thread == null) {
            return;
        }
        Request req = null;
        ArrayList arrayList = m_requestPool;
        synchronized (arrayList) {
            req = m_requestPool.size() > 0 ? (Request)m_requestPool.remove(0) : new Request();
        }
        req.m_logger = logger;
        req.m_type = type;
        req.m_listeners = listeners;
        req.m_event = event;
        arrayList = m_requestList;
        synchronized (arrayList) {
            m_requestList.add(req);
            m_requestList.notify();
        }
    }

    private static void fireEventImmediately(Logger logger, int type, Object[] listeners, EventObject event) {
        if (listeners.length > 0) {
            for (int i = listeners.length - 5; i >= 0; i -= 5) {
                Bundle bundle = (Bundle)listeners[i + 0];
                EventListener l = (EventListener)listeners[i + 2];
                Filter filter = (Filter)listeners[i + 3];
                Object acc = listeners[i + 4];
                try {
                    if (type == 0) {
                        EventDispatcher.invokeFrameworkListenerCallback(bundle, l, event);
                        continue;
                    }
                    if (type == 1) {
                        EventDispatcher.invokeBundleListenerCallback(bundle, l, event);
                        continue;
                    }
                    if (type != 2) continue;
                    EventDispatcher.invokeServiceListenerCallback(bundle, l, filter, acc, event);
                    continue;
                }
                catch (Throwable th) {
                    logger.log(1, "EventDispatcher: Error during dispatch.", th);
                }
            }
        }
    }

    private static void invokeFrameworkListenerCallback(Bundle bundle, final EventListener l, final EventObject event) {
        if (bundle.getState() == 8 || bundle.getState() == 32) {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ((FrameworkListener)l).frameworkEvent((FrameworkEvent)event);
                        return null;
                    }
                });
            } else {
                ((FrameworkListener)l).frameworkEvent((FrameworkEvent)event);
            }
        }
    }

    private static void invokeBundleListenerCallback(Bundle bundle, final EventListener l, final EventObject event) {
        if ((class$org$osgi$framework$SynchronousBundleListener == null ? (class$org$osgi$framework$SynchronousBundleListener = EventDispatcher.class$("org.osgi.framework.SynchronousBundleListener")) : class$org$osgi$framework$SynchronousBundleListener).isAssignableFrom(l.getClass()) && (bundle.getState() == 8 || bundle.getState() == 16 || bundle.getState() == 32) || bundle.getState() == 8 || bundle.getState() == 32) {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ((BundleListener)l).bundleChanged((BundleEvent)event);
                        return null;
                    }
                });
            } else {
                ((BundleListener)l).bundleChanged((BundleEvent)event);
            }
        }
    }

    private static void invokeServiceListenerCallback(Bundle bundle, final EventListener l, Filter filter, Object acc, final EventObject event) {
        if (bundle.getState() != 8 && bundle.getState() != 16 && bundle.getState() != 32) {
            return;
        }
        ServiceReference ref = ((ServiceEvent)event).getServiceReference();
        String[] objectClass = (String[])ref.getProperty("objectClass");
        if (objectClass != null) {
            boolean hasPermission = false;
            SecurityManager sm = System.getSecurityManager();
            if (acc != null && sm != null) {
                for (int i = 0; !hasPermission && i < objectClass.length; ++i) {
                    try {
                        ServicePermission perm = new ServicePermission(objectClass[i], "get");
                        sm.checkPermission(perm, acc);
                        hasPermission = true;
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            } else {
                hasPermission = true;
            }
            if (hasPermission && (filter == null || filter.match(((ServiceEvent)event).getServiceReference())) && (l instanceof AllServiceListener || Util.isServiceAssignable(bundle, ((ServiceEvent)event).getServiceReference()))) {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            ((ServiceListener)l).serviceChanged((ServiceEvent)event);
                            return null;
                        }
                    });
                } else {
                    ((ServiceListener)l).serviceChanged((ServiceEvent)event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run() {
        Request req = null;
        while (true) {
            ArrayList arrayList = m_requestList;
            synchronized (arrayList) {
                while (m_requestList.size() == 0 && !m_stopping) {
                    try {
                        m_requestList.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (m_requestList.size() == 0 && m_stopping) {
                    return;
                }
                req = (Request)m_requestList.remove(0);
            }
            EventDispatcher.fireEventImmediately(req.m_logger, req.m_type, req.m_listeners, req.m_event);
            arrayList = m_requestPool;
            synchronized (arrayList) {
                req.m_logger = null;
                req.m_type = -1;
                req.m_listeners = null;
                req.m_event = null;
                m_requestPool.add(req);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Request {
        public static final int FRAMEWORK_EVENT = 0;
        public static final int BUNDLE_EVENT = 1;
        public static final int SERVICE_EVENT = 2;
        public Logger m_logger = null;
        public int m_type = -1;
        public Object[] m_listeners = null;
        public EventObject m_event = null;

        private Request() {
        }
    }
}

