/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.fscript.model.jade;

import java.util.HashMap;
import java.util.List;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.fscript.ScriptExecutionError;
import org.objectweb.fractal.fscript.ast.SourceLocation;
import org.objectweb.fractal.fscript.diagnostics.Diagnostic;
import org.objectweb.fractal.fscript.interpreter.Context;
import org.objectweb.fractal.fscript.model.fractal.InterfaceNode;
import org.objectweb.fractal.fscript.model.jade.JadeModel;
import org.objectweb.fractal.fscript.procedures.NativeProcedure;
import org.objectweb.fractal.fscript.types.PrimitiveType;
import org.objectweb.fractal.fscript.types.Signature;
import org.objectweb.fractal.fscript.types.Type;
import org.objectweb.jasmine.jade.service.deployer.DeployerService;
import org.objectweb.jasmine.jade.service.deployer.DeploymentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployAction
implements NativeProcedure,
BindingController {
    private JadeModel model;

    public String getName() {
        return "deploy";
    }

    public Signature getSignature() {
        Signature sign = new Signature((Type)this.model.getNodeKind("component"), new Type[]{this.model.getNodeKind("interface"), PrimitiveType.STRING});
        sign.setOptionalParameters(true);
        return sign;
    }

    public boolean isPureFunction() {
        return false;
    }

    public Object apply(List<Object> args, Context ctx) throws ScriptExecutionError {
        InterfaceNode itf = (InterfaceNode)args.get(0);
        DeployerService dserv = (DeployerService)itf.getInterface();
        String name = (String)args.get(1);
        HashMap<String, String> deployCtx = new HashMap<String, String>();
        if (args.size() > 2) {
            if (args.size() % 2 != 0) {
                Diagnostic err = Diagnostic.error((SourceLocation)SourceLocation.UNKNOWN, (String)"Invalid number of context arguments (must be pair).");
                throw new ScriptExecutionError(err);
            }
            int i = 2;
            while (i < args.size()) {
                String propName = (String)args.get(i++);
                String propValue = (String)args.get(i++);
                deployCtx.put(propName, propValue);
            }
        }
        JadeModel nf = this.model;
        try {
            Component comp = dserv.deploy(name, deployCtx);
            return nf.createComponentNode(comp);
        }
        catch (DeploymentException e) {
            Diagnostic err = Diagnostic.error((SourceLocation)SourceLocation.UNKNOWN, (String)"Error while deploying component.");
            throw new ScriptExecutionError(err);
        }
    }

    public String[] listFc() {
        return new String[]{"fractal-model"};
    }

    public void bindFc(String itfName, Object srvItf) throws NoSuchInterfaceException {
        if (!"jade-model".equals(itfName)) {
            throw new NoSuchInterfaceException(itfName);
        }
        this.model = (JadeModel)srvItf;
    }

    public Object lookupFc(String itfName) throws NoSuchInterfaceException {
        if ("jade-model".equals(itfName)) {
            return this.model;
        }
        throw new NoSuchInterfaceException(itfName);
    }

    public void unbindFc(String itfName) throws NoSuchInterfaceException {
        if (!"jade-model".equals(itfName)) {
            throw new NoSuchInterfaceException(itfName);
        }
        this.model = null;
    }
}

