/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.util;

import org.objectweb.jasmine.jade.util.JadeException;
import org.objectweb.jasmine.jade.util.StreamForwarder;

public class ShellCommand {
    private static Runtime runtime = Runtime.getRuntime();
    public String command;
    public Process process;
    public StreamForwarder outFwder;
    public StreamForwarder errFwder;

    public static ShellCommand asyncExec(String cmd, String[] envp) throws JadeException {
        try {
            Process process = runtime.exec(cmd, envp);
            return new ShellCommand(cmd, process);
        }
        catch (Exception e) {
            throw new JadeException("ShellCommand: cannot execute cmd " + cmd, e);
        }
    }

    public static void syncExec(String cmd, String[] envp) throws JadeException {
        try {
            ShellCommand shcmd = ShellCommand.asyncExec(cmd, envp);
            shcmd.forwardAll();
            shcmd.process.waitFor();
        }
        catch (Exception e) {
            throw new JadeException("ShellCommand: cannot execute cmd " + cmd, e);
        }
    }

    private ShellCommand(String command, Process process) {
        this.command = command;
        this.process = process;
    }

    public void forwardStdoutAndWaitForString(String prefix, String wantedStr) throws JadeException {
        if (this.outFwder != null) {
            return;
        }
        this.outFwder = new StreamForwarder(prefix, this.process.getInputStream(), System.out);
        if (wantedStr != null) {
            this.outFwder.prepareWaitForString(wantedStr);
        }
        this.outFwder.start();
        if (wantedStr != null) {
            this.outFwder.waitForString();
        }
    }

    public void forwardStdout(String prefix) throws JadeException {
        this.forwardStdoutAndWaitForString(prefix, null);
    }

    public void forwardStdoutAndWaitForString(String wantedStr) throws JadeException {
        this.forwardStdoutAndWaitForString("[" + this.command + "] out> ", wantedStr);
    }

    public void forwardStdout() throws JadeException {
        this.forwardStdoutAndWaitForString(null);
    }

    public void forwardStderr(String prefix) {
        if (this.errFwder != null) {
            return;
        }
        this.errFwder = new StreamForwarder(prefix, this.process.getErrorStream(), System.err);
        this.errFwder.start();
    }

    public void forwardStderr() throws JadeException {
        this.forwardStderr("[" + this.command + "] err> ");
    }

    public void forwardAll(String prefix) throws JadeException {
        this.forwardStdout(prefix);
        this.forwardStderr(prefix);
    }

    public void forwardAll() throws JadeException {
        this.forwardStdout();
        this.forwardStderr();
    }
}

