/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.impl.CaseInsensitiveDictionary;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;

class ConfigurationImpl {
    private static final String CONFIGURATION_NEW = "_felix_.cm.newConfiguration";
    private ConfigurationManager configurationManager;
    private PersistenceManager persistenceManager;
    private String pid;
    private String factoryPID;
    private String bundleLocation;
    private ServiceReference serviceReference;
    private CaseInsensitiveDictionary properties;
    private boolean delivered;

    ConfigurationImpl(ConfigurationManager configurationManager, PersistenceManager persistenceManager, Dictionary properties) {
        this.configurationManager = configurationManager;
        this.persistenceManager = persistenceManager;
        this.pid = (String)properties.remove("service.pid");
        this.factoryPID = (String)properties.remove("service.factoryPid");
        this.bundleLocation = (String)properties.remove("service.bundleLocation");
        this.configureFromPersistence(properties);
    }

    ConfigurationImpl(ConfigurationManager configurationManager, PersistenceManager persistenceManager, String pid, String factoryPid, String bundleLocation) throws IOException {
        this.configurationManager = configurationManager;
        this.persistenceManager = persistenceManager;
        this.pid = pid;
        this.factoryPID = factoryPid;
        this.bundleLocation = bundleLocation;
        this.properties = null;
        Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
        this.setAutoProperties(props, true);
        ((Dictionary)props).put(CONFIGURATION_NEW, Boolean.TRUE);
        persistenceManager.store(pid, props);
    }

    void setDelivered(boolean delivered) {
        this.delivered = delivered;
    }

    boolean isDelivered() {
        return this.delivered;
    }

    public void delete() throws IOException {
        if (!this.isDeleted()) {
            this.persistenceManager.delete(this.pid);
            this.persistenceManager = null;
            this.setDelivered(false);
            this.configurationManager.deleted(this);
        }
    }

    public String getPid() {
        return this.pid;
    }

    public String getFactoryPid() {
        return this.factoryPID;
    }

    public String getBundleLocation() {
        return this.bundleLocation;
    }

    public Dictionary getProperties() {
        if (this.properties == null) {
            return null;
        }
        CaseInsensitiveDictionary props = new CaseInsensitiveDictionary(this.properties);
        this.setAutoProperties(props, false);
        return props;
    }

    public void setBundleLocation(String bundleLocation) {
        if (!this.isDeleted()) {
            this.bundleLocation = bundleLocation;
            try {
                this.store();
            }
            catch (IOException ioe) {
                this.configurationManager.log(1, "Persisting new bundle location failed", ioe);
            }
        }
    }

    public void update() throws IOException {
        if (!this.isDeleted()) {
            Dictionary properties = this.persistenceManager.load(this.pid);
            String servicePid = (String)properties.get("service.pid");
            if (servicePid != null && !this.pid.equals(servicePid)) {
                throw new IOException("PID of configuration file does match requested PID; expected " + this.pid + ", got " + servicePid);
            }
            this.configureFromPersistence(properties);
            this.setDelivered(false);
            this.configurationManager.updated(this);
        }
    }

    public void update(Dictionary properties) throws IOException {
        if (!this.isDeleted()) {
            CaseInsensitiveDictionary newProperties = new CaseInsensitiveDictionary(properties);
            this.setAutoProperties(newProperties, true);
            this.persistenceManager.store(this.pid, newProperties);
            this.configure(newProperties);
            this.setDelivered(false);
            this.configurationManager.updated(this);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Configuration) {
            return this.pid.equals(((Configuration)obj).getPid());
        }
        return false;
    }

    public int hashCode() {
        return this.pid.hashCode();
    }

    public String toString() {
        return "Configuration PID=" + this.pid + ", factoryPID=" + this.factoryPID + ", bundleLocation=" + this.bundleLocation;
    }

    void setServiceReference(ServiceReference serviceReference) {
        this.serviceReference = serviceReference;
    }

    ServiceReference getServiceReference() {
        return this.serviceReference;
    }

    void store() throws IOException {
        Hashtable<String, String> props = this.getProperties();
        if (props == null) {
            props = new Hashtable<String, String>();
            this.setAutoProperties(props, true);
        } else if (this.getBundleLocation() != null) {
            ((Dictionary)props).put("service.bundleLocation", this.getBundleLocation());
        }
        this.persistenceManager.store(this.pid, props);
    }

    boolean isNew() {
        return this.properties == null;
    }

    boolean isDeleted() {
        if (this.persistenceManager != null) {
            if (this.properties == null || this.persistenceManager.exists(this.pid)) {
                return false;
            }
            this.persistenceManager = null;
        }
        return true;
    }

    private void configureFromPersistence(Dictionary properties) {
        if (properties.get(CONFIGURATION_NEW) == null) {
            this.configure(properties);
        } else {
            this.properties = null;
        }
    }

    private void configure(Dictionary properties) {
        this.clearAutoProperties(properties);
        this.properties = properties instanceof CaseInsensitiveDictionary ? (CaseInsensitiveDictionary)properties : new CaseInsensitiveDictionary(properties);
    }

    void setAutoProperties(Dictionary properties, boolean withBundleLocation) {
        this.replaceProperty(properties, "service.pid", this.pid);
        this.replaceProperty(properties, "service.factoryPid", this.factoryPID);
        if (withBundleLocation) {
            this.replaceProperty(properties, "service.bundleLocation", this.getBundleLocation());
        } else {
            properties.remove("service.bundleLocation");
        }
    }

    void clearAutoProperties(Dictionary properties) {
        properties.remove("service.pid");
        properties.remove("service.factoryPid");
        properties.remove("service.bundleLocation");
    }

    private void replaceProperty(Dictionary properties, String key, String value) {
        if (value == null) {
            properties.remove(key);
        } else {
            properties.put(key, value);
        }
    }
}

