/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.felix.framework.FelixBundle;

class GetEntryPathsEnumeration
implements Enumeration {
    private FelixBundle m_bundle = null;
    private Enumeration m_enumeration = null;
    private String m_path = null;
    private Object m_next = null;

    public GetEntryPathsEnumeration(FelixBundle bundle, String path) {
        this.m_bundle = bundle;
        this.m_path = path;
        this.m_enumeration = this.m_bundle.getInfo().getCurrentModule().getContentLoader().getContent().getEntries();
        if (this.m_path == null) {
            throw new IllegalArgumentException("The path for findEntries() cannot be null.");
        }
        if (this.m_path.length() > 0 && this.m_path.charAt(0) == '/') {
            this.m_path = this.m_path.substring(1);
        }
        if (this.m_path.length() > 0 && this.m_path.charAt(this.m_path.length() - 1) != '/') {
            this.m_path = this.m_path + "/";
        }
        this.m_next = this.findNext();
    }

    public boolean hasMoreElements() {
        return this.m_next != null;
    }

    public Object nextElement() {
        if (this.m_next == null) {
            throw new NoSuchElementException("No more entry paths.");
        }
        Object last = this.m_next;
        this.m_next = this.findNext();
        return last;
    }

    private Object findNext() {
        while (this.m_enumeration.hasMoreElements()) {
            int idx;
            String entryName = (String)this.m_enumeration.nextElement();
            if (entryName.equals(this.m_path) || !entryName.startsWith(this.m_path) || (idx = entryName.indexOf(47, this.m_path.length())) >= 0 && idx != entryName.length() - 1) continue;
            return entryName;
        }
        return null;
    }
}

