/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.bundlerepository.MapToDictionary;
import org.apache.felix.bundlerepository.RepositoryImpl;
import org.apache.felix.bundlerepository.ResourceComparator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.obr.Repository;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;
import org.ow2.jasmine.jade.bundlerepository.ResolverImpl;

public class RepositoryAdminImpl
implements RepositoryAdmin {
    static BundleContext m_context = null;
    private List m_urlList = new ArrayList();
    private Map m_repoMap = new HashMap();
    private boolean m_initialized = false;
    private Comparator m_nameComparator = new ResourceComparator();
    private static final String DEFAULT_REPOSITORY_URL = "http://oscar-osgi.sf.net/obr2/repository.xml";
    public static final String REPOSITORY_URL_PROP = "obr.repository.url";
    public static final String EXTERN_REPOSITORY_TAG = "extern-repositories";

    public RepositoryAdminImpl(BundleContext context) {
        StringTokenizer st;
        m_context = context;
        String urlStr = m_context.getProperty(REPOSITORY_URL_PROP);
        if (urlStr != null && (st = new StringTokenizer(urlStr)).countTokens() > 0) {
            while (st.hasMoreTokens()) {
                try {
                    this.m_urlList.add(new URL(st.nextToken()));
                }
                catch (MalformedURLException ex) {
                    System.err.println("RepositoryAdminImpl: " + ex);
                }
            }
        }
        if (this.m_urlList.size() == 0) {
            try {
                this.m_urlList.add(new URL(DEFAULT_REPOSITORY_URL));
            }
            catch (MalformedURLException ex) {
                System.err.println("RepositoryAdminImpl: " + ex);
            }
        }
    }

    public synchronized Repository addRepository(URL url) throws Exception {
        if (!this.m_urlList.contains(url)) {
            this.m_urlList.add(url);
        }
        RepositoryImpl repo = new RepositoryImpl(url);
        this.m_repoMap.put(url, repo);
        return repo;
    }

    public synchronized boolean removeRepository(URL url) {
        this.m_repoMap.remove(url);
        return this.m_urlList.remove(url);
    }

    public synchronized Repository[] listRepositories() {
        if (!this.m_initialized) {
            this.initialize();
        }
        return this.m_repoMap.values().toArray(new Repository[this.m_repoMap.size()]);
    }

    public synchronized Resource getResource(String respositoryId) {
        return null;
    }

    public synchronized Resolver resolver() {
        if (!this.m_initialized) {
            this.initialize();
        }
        return new ResolverImpl(m_context, this);
    }

    public synchronized Resource[] discoverResources(String filterExpr) {
        if (!this.m_initialized) {
            this.initialize();
        }
        Filter filter = null;
        try {
            filter = m_context.createFilter(filterExpr);
        }
        catch (InvalidSyntaxException ex) {
            System.err.println((Object)ex);
        }
        Resource[] resources = null;
        MapToDictionary dict = new MapToDictionary(null);
        Repository[] repos = this.listRepositories();
        ArrayList<Resource> matchList = new ArrayList<Resource>();
        for (int repoIdx = 0; repos != null && repoIdx < repos.length; ++repoIdx) {
            resources = repos[repoIdx].getResources();
            for (int resIdx = 0; resources != null && resIdx < resources.length; ++resIdx) {
                dict.setSourceMap(resources[resIdx].getProperties());
                if (!filter.match((Dictionary)dict)) continue;
                matchList.add(resources[resIdx]);
            }
        }
        resources = matchList.toArray(new Resource[matchList.size()]);
        Arrays.sort(resources, this.m_nameComparator);
        return resources;
    }

    private void initialize() {
        this.m_initialized = true;
        this.m_repoMap.clear();
        for (int i = 0; i < this.m_urlList.size(); ++i) {
            URL url = (URL)this.m_urlList.get(i);
            try {
                RepositoryImpl repo = new RepositoryImpl(url);
                if (repo == null) continue;
                this.m_repoMap.put(url, repo);
                continue;
            }
            catch (Exception ex) {
                System.err.println("RepositoryAdminImpl: Exception creating repository - " + ex);
                System.err.println("RepositoryAdminImpl: Ignoring repository " + url);
            }
        }
    }
}

