/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.fscript.model.jade;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fscript.model.fractal.AttributeNode;
import org.objectweb.fractal.fscript.model.fractal.FractalModel;
import org.objectweb.fractal.fscript.model.jade.JadeModel;
import org.objectweb.fractal.util.AttributesHelper;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;

public class GenericAttributeNode
extends AttributeNode {
    private final GenericAttributeController gac;

    public GenericAttributeNode(JadeModel model, AttributesHelper attrHelper, String attrName) {
        super((FractalModel)model, attrHelper, attrName);
        this.gac = this.getGAC(attrHelper.getComponent());
    }

    private GenericAttributeController getGAC(Component c) {
        try {
            return (GenericAttributeController)c.getFcInterface("generic-attribute-controller");
        }
        catch (NoSuchInterfaceException e) {
            return null;
        }
    }

    public String getType() {
        if (this.gac != null) {
            return String.class.getName();
        }
        return super.getType();
    }

    public Object getValue() {
        if (this.gac != null) {
            try {
                return this.gac.getAttribute(this.getName());
            }
            catch (NoSuchAttributeException e) {
                throw new IllegalArgumentException();
            }
        }
        return super.getValue();
    }

    public void setValue(Object value) {
        if (this.gac != null) {
            try {
                this.gac.setAttribute(this.getName(), (String)value);
            }
            catch (NoSuchAttributeException e) {
                throw new IllegalArgumentException();
            }
        } else {
            super.setValue(value);
        }
    }

    public boolean isReadable() {
        return this.gac != null ? true : super.isReadable();
    }

    public boolean isWritable() {
        return this.gac != null ? true : super.isWritable();
    }
}

