/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.fscript.model.jade;

import java.util.List;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.fscript.ScriptExecutionError;
import org.objectweb.fractal.fscript.ast.SourceLocation;
import org.objectweb.fractal.fscript.diagnostics.Diagnostic;
import org.objectweb.fractal.fscript.interpreter.Context;
import org.objectweb.fractal.fscript.model.fractal.ComponentNode;
import org.objectweb.fractal.fscript.model.fractal.InterfaceNode;
import org.objectweb.fractal.fscript.model.jade.JadeModel;
import org.objectweb.fractal.fscript.procedures.NativeProcedure;
import org.objectweb.fractal.fscript.types.Signature;
import org.objectweb.fractal.fscript.types.Type;
import org.objectweb.fractal.fscript.types.VoidType;
import org.objectweb.jasmine.jade.service.deployer.DeployerService;
import org.objectweb.jasmine.jade.service.deployer.DeploymentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndeployAction
implements NativeProcedure,
BindingController {
    private JadeModel model;

    public String getName() {
        return "undeploy";
    }

    public Signature getSignature() {
        return new Signature(VoidType.VOID_TYPE, new Type[]{this.model.getNodeKind("component")});
    }

    public boolean isPureFunction() {
        return false;
    }

    public Object apply(List<Object> args, Context ctx) throws ScriptExecutionError {
        InterfaceNode itf = (InterfaceNode)args.get(0);
        DeployerService dserv = (DeployerService)itf.getInterface();
        ComponentNode node = (ComponentNode)args.get(1);
        Component c = node.getComponent();
        try {
            dserv.undeploy(c);
        }
        catch (DeploymentException e) {
            Diagnostic err = Diagnostic.error((SourceLocation)SourceLocation.UNKNOWN, (String)"Error while undeploying component.");
            throw new ScriptExecutionError(err);
        }
        return null;
    }

    public String[] listFc() {
        return new String[]{"fractal-model"};
    }

    public void bindFc(String itfName, Object srvItf) throws NoSuchInterfaceException {
        if (!"jade-model".equals(itfName)) {
            throw new NoSuchInterfaceException(itfName);
        }
        this.model = (JadeModel)srvItf;
    }

    public Object lookupFc(String itfName) throws NoSuchInterfaceException {
        if ("jade-model".equals(itfName)) {
            return this.model;
        }
        throw new NoSuchInterfaceException(itfName);
    }

    public void unbindFc(String itfName) throws NoSuchInterfaceException {
        if (!"jade-model".equals(itfName)) {
            throw new NoSuchInterfaceException(itfName);
        }
        this.model = null;
    }
}

