/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.osgi.jadenode;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.rmi.RemoteException;
import org.objectweb.fractal.rmi.registry.NamingService;
import org.objectweb.fractal.rmi.registry.Registry;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.jasmine.jade.osgi.JadeProperties;
import org.objectweb.jasmine.jade.util.JadeException;
import org.objectweb.jasmine.jade.util.Logger;
import org.objectweb.jasmine.jade.util.NoSuchComponentException;
import org.objectweb.jonathan.apis.binding.NamingContext;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.GenericInstallingFactoryContextController;
import org.ow2.jasmine.jade.fractal.api.control.OSGiContextController;
import org.ow2.jasmine.jade.fractal.util.FractalUtil;
import org.ow2.jasmine.jade.reflex.api.ReflexFactoryFactory;

public class JadeNodeActivator
implements BundleActivator {
    private BundleContext bc;
    private Component jadenode = null;
    private Component bootstrap = null;
    private Component jadeboot = null;
    private String name = null;
    private NamingService ns = null;
    private JadeProperties properties = null;
    private Component registry = null;

    public void start(BundleContext bc) throws Exception {
        System.setSecurityManager(new SecurityManager());
        this.properties = JadeProperties.getInstance(bc);
        this.bc = bc;
        System.out.println("JadeNode starting ...");
        this.connectFractalRmiRegistry();
        this.verifyPreCondition();
        this.initializeFractalBootstrap();
        this.jadenode = this.createComponent();
        this.registerNode();
        this.addJadeNode2JadePlatform();
        this.addFractalBootstrap();
        this.configureBootstrap();
        this.configureHeartBeat();
        this.configureInstaller();
        this.startJadeNode();
        System.out.println("JadeNode started");
    }

    public void stop(BundleContext bc) throws Exception {
        if (this.jadenode != null) {
            Fractal.getLifeCycleController((Component)this.jadenode).stopFc();
        }
    }

    private void connectFractalRmiRegistry() {
        ClassLoader cl = JadeNodeActivator.class.getClassLoader();
        try {
            String registryHost = this.properties.getJadeRegistryHost();
            String registryPort = this.properties.getJadeRegistryPort();
            System.out.println("Fractal Registry: " + registryHost + ":" + registryPort);
            HashMap<String, ClassLoader> hints = new HashMap<String, ClassLoader>();
            hints.put("registry-classloader", cl);
            hints.put("component-classloader", cl);
            if (registryPort == null) {
                this.registry = Registry.getRegistryComponent((String)registryHost, (int)1234, hints);
                NamingContext binder = (NamingContext)this.registry.getFcInterface("context");
                this.ns = Registry.getRegistry((String)registryHost, (int)1234, (NamingContext)binder);
            } else {
                this.registry = Registry.getRegistryComponent((String)registryHost, (int)Integer.parseInt(registryPort), hints);
                NamingContext binder = (NamingContext)this.registry.getFcInterface("context");
                this.ns = Registry.getRegistry((String)registryHost, (int)Integer.parseInt(registryPort), (NamingContext)binder);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fatalError(new JadeException("[JadeNodeActivator] can't connect to Fractal RMI registry"));
        }
    }

    private void verifyPreCondition() {
        try {
            this.jadeboot = this.ns.lookup("jadeboot");
        }
        catch (RemoteException ignored) {
            this.fatalError(new JadeException("Can't start a node. No JadeBoot (fractal rmi registry) found"));
        }
    }

    private void initializeFractalBootstrap() throws Exception {
        this.bootstrap = Fractal.getBootstrapComponent();
        Component jadePlatform = this.ns.lookup(this.properties.getJadePlatformName());
        Fractal.getContentController((Component)jadePlatform).addFcSubComponent(this.bootstrap);
        Object registryInterface = this.jadeboot.getFcInterface("registry");
        BindingController bc = Fractal.getBindingController((Component)this.bootstrap);
        bc.bindFc("registry", registryInterface);
    }

    private Component createComponent() {
        Component res = null;
        try {
            Factory f = null;
            this.bootstrap = Fractal.getBootstrapComponent();
            f = this.properties.isJadeReflex() ? ReflexFactoryFactory.getFactory((String)"org.ow2.jasmine.jade.fractal.adl.JadeFactory", (String)"org.objectweb.fractal.adl.FractalBackend", new HashMap()) : FactoryFactory.getFactory((String)"org.ow2.jasmine.jade.fractal.adl.JadeFactory", (String)"org.ow2.jasmine.jade.fractal.adl.BootBackend", new HashMap());
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("heartbeat_pulse_period_in_second", this.properties.getJadeHeartbeatPulse());
            res = (Component)f.newComponent("org.objectweb.jasmine.jade.boot.jadenode.JadeNode", context);
        }
        catch (Exception e) {
            this.fatalError(e);
        }
        return res;
    }

    private int generateNodename(int nodeNumber) {
        try {
            this.name = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            this.fatalError(e);
        }
        boolean nodeNumberOk = false;
        Component c = null;
        while (!nodeNumberOk) {
            try {
                c = this.ns.lookup(this.name + "_" + nodeNumber);
            }
            catch (RemoteException ignored) {
                // empty catch block
            }
            if (c != null) {
                ++nodeNumber;
                continue;
            }
            nodeNumberOk = true;
            this.name = this.name + "_" + nodeNumber;
        }
        return nodeNumber;
    }

    private void registerNode() {
        boolean isBound = false;
        int nodeNumber = 0;
        while (!isBound) {
            nodeNumber = this.generateNodename(nodeNumber);
            isBound = this.ns.bind(this.name, this.jadenode);
        }
        this.properties.setJadeNodeName(this.name);
        try {
            Fractal.getNameController((Component)this.jadenode).setFcName(this.name);
        }
        catch (NoSuchInterfaceException e) {
            this.fatalError((Exception)((Object)e));
        }
        System.out.println("[NodeLauncher] Node \"" + this.name + "\" registered");
    }

    private void addJadeNode2JadePlatform() throws Exception {
        Component jadePlatform = this.ns.lookup(this.properties.getJadePlatformName());
        Fractal.getContentController((Component)jadePlatform).addFcSubComponent(this.jadenode);
    }

    private void addFractalBootstrap() {
        try {
            Fractal.getNameController((Component)this.bootstrap).setFcName(this.name + "_factory");
            Component controllers = org.objectweb.jasmine.jade.util.FractalUtil.getFirstFoundSubComponentByName(this.jadenode, "controllers");
            Fractal.getContentController((Component)controllers).addFcSubComponent(this.bootstrap);
            Component fractalRmiRegistry = org.objectweb.jasmine.jade.util.FractalUtil.getFirstFoundSubComponentByName(this.ns.lookup("jadeboot"), "fractal_rmi_registry");
            Fractal.getContentController((Component)controllers).addFcSubComponent(fractalRmiRegistry);
            BindingController bc = Fractal.getBindingController((Component)this.bootstrap);
            bc.unbindFc("registry");
            bc.bindFc("registry", fractalRmiRegistry.getFcInterface("registry"));
            Fractal.getBindingController((Component)controllers).bindFc("generic-installing-factory", this.bootstrap.getFcInterface("generic-installing-factory"));
            Component installer = org.objectweb.jasmine.jade.util.FractalUtil.getFirstFoundSubComponentByName(controllers, "installer");
            Component gc = org.objectweb.jasmine.jade.util.FractalUtil.getFirstFoundSubComponentByName(controllers, "gc");
            Fractal.getBindingController((Component)this.bootstrap).bindFc("installer", installer.getFcInterface("installer"));
            Fractal.getBindingController((Component)this.bootstrap).bindFc("gc", gc.getFcInterface("gc"));
            Component jadePlatform = this.ns.lookup(this.properties.getJadePlatformName());
            Fractal.getContentController((Component)jadePlatform).removeFcSubComponent(this.bootstrap);
            Fractal.getContentController((Component)jadePlatform).removeFcSubComponent(this.jadenode);
            Fractal.getContentController((Component)controllers).addFcSubComponent(this.registry);
        }
        catch (NoSuchComponentException e) {
            this.fatalError(e);
        }
        catch (IllegalBindingException e) {
            this.fatalError((Exception)((Object)e));
        }
        catch (IllegalContentException e) {
            this.fatalError((Exception)((Object)e));
        }
        catch (IllegalLifeCycleException e) {
            this.fatalError((Exception)((Object)e));
        }
        catch (NoSuchInterfaceException e) {
            this.fatalError((Exception)((Object)e));
        }
    }

    private void configureBootstrap() throws NoSuchInterfaceException, NoSuchComponentException {
        Component managed_resources = org.objectweb.jasmine.jade.util.FractalUtil.getFirstFoundSubComponentByName(this.jadenode, "managed_resources");
        GenericInstallingFactoryContextController gifcc = FractalUtil.getGenericInstallingFactoryContextController((Component)this.bootstrap);
        gifcc.setNewComponentContainer(managed_resources);
    }

    private void configureHeartBeat() {
        Component heartbeat = null;
        try {
            heartbeat = org.objectweb.jasmine.jade.util.FractalUtil.getSubComponentByPath(this.jadenode, "controllers/heartbeat");
        }
        catch (NoSuchComponentException e) {
            this.fatalError(e);
        }
        try {
            GenericAttributeController gac = FractalUtil.getGenericAttributeController((Component)heartbeat);
            gac.setAttribute("discoveryHost", this.properties.getJadeDiscoveryHost());
            gac.setAttribute("discoveryPort", this.properties.getJadeDiscoveryPort());
            gac.setAttribute("nodeName", this.name);
        }
        catch (Exception e) {
            this.fatalError(e);
        }
    }

    private void configureInstaller() throws NoSuchInterfaceException, NoSuchComponentException {
        ((OSGiContextController)org.objectweb.jasmine.jade.util.FractalUtil.getFirstFoundSubComponentByName(this.jadenode, "installer").getFcInterface("osgi-context-controller")).setBundleContext(this.bc);
    }

    private void startJadeNode() {
        try {
            LifeCycleController lc = Fractal.getLifeCycleController((Component)this.jadenode);
            if (lc != null) {
                try {
                    lc.startFc();
                }
                catch (IllegalLifeCycleException e) {
                    this.fatalError((Exception)((Object)e));
                }
            }
        }
        catch (NoSuchInterfaceException e) {
            this.fatalError((Exception)((Object)e));
        }
    }

    private void fatalError(Exception e) {
        Logger.println("[NodeLauncher] Can't start node : " + e.getLocalizedMessage());
        e.printStackTrace();
        System.exit(0);
    }
}

