/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.deployer.adl.classloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.jasmine.jade.service.deployer.adl.classloader.UrlManager;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;

public class ClassLoaderManager
implements UrlManager,
Factory,
BindingController,
GenericAttributeController {
    private static String[] attList = new String[]{"urls"};
    private Factory basicFactory;
    private static String[] bindingsList = new String[]{"basic-factory"};
    private URLClassLoader urlCL;
    private Set<URL> urls = new HashSet<URL>();

    public void addURL(String url) throws MalformedURLException {
        this.addURL(new URL(url));
    }

    public void addURL(URL url) {
        this.urls.add(url);
        this.updateUrlClassLoader();
    }

    public void removeURL(String url) throws MalformedURLException {
        this.removeURL(new URL(url));
    }

    public void removeURL(URL url) {
        this.urls.remove(url);
        this.updateUrlClassLoader();
    }

    public String listUrls() {
        return this.urlsSet2String();
    }

    public Object newComponent(String name, Map context) throws ADLException {
        context.put("classloader", this.urlCL);
        return this.basicFactory.newComponent(name, context);
    }

    public Object newComponentType(String name, Map context) throws ADLException {
        context.put("classloader", this.urlCL);
        return this.basicFactory.newComponentType(name, context);
    }

    public String getAttribute(String name) throws NoSuchAttributeException {
        if (name.equals("urls")) {
            return this.urlsSet2String();
        }
        throw new NoSuchAttributeException(name);
    }

    public String[] listFcAtt() {
        return attList;
    }

    public void setAttribute(String name, String value) throws NoSuchAttributeException {
        if (!name.equals("urls")) {
            throw new NoSuchAttributeException(name);
        }
        this.updateUrlSet(value);
        this.updateUrlClassLoader();
    }

    public void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (!clientItfName.equals("basic-factory")) {
            throw new NoSuchInterfaceException(clientItfName);
        }
        this.basicFactory = (Factory)serverItf;
    }

    public String[] listFc() {
        return bindingsList;
    }

    public Object lookupFc(String clientItfName) throws NoSuchInterfaceException {
        if (clientItfName.equals("basic-factory")) {
            return this.basicFactory;
        }
        throw new NoSuchInterfaceException(clientItfName);
    }

    public void unbindFc(String clientItfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (!clientItfName.equals("basic-factory")) {
            throw new NoSuchInterfaceException(clientItfName);
        }
        this.basicFactory = null;
    }

    private void updateUrlClassLoader() {
        this.urlCL = new URLClassLoader(this.urls.toArray(new URL[0]), this.getClass().getClassLoader());
    }

    private void updateUrlSet(String urls) {
        if (urls != null) {
            StringTokenizer tokenizer = new StringTokenizer(urls, ";");
            while (tokenizer.hasMoreTokens()) {
                try {
                    URL url = new URL(tokenizer.nextToken());
                    this.urls.add(url);
                }
                catch (MalformedURLException ignored) {}
            }
        }
    }

    private String urlsSet2String() {
        StringBuffer res = new StringBuffer();
        for (URL url : this.urls) {
            res.append(url.toString());
            res.append(File.pathSeparator);
        }
        return res.toString();
    }
}

