/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.deployer.manager;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.deployment.local.api.UndeploymentController;
import org.objectweb.fractal.deployment.local.api.UndeploymentException;
import org.objectweb.fractal.rmi.registry.NamingService;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.jasmine.jade.resource.Resource;
import org.objectweb.jasmine.jade.service.Service;
import org.objectweb.jasmine.jade.service.deployer.DeployerService;
import org.objectweb.jasmine.jade.service.deployer.DeploymentException;
import org.objectweb.jasmine.jade.util.FractalUtil;
import org.objectweb.jasmine.jade.util.JadeException;
import org.objectweb.jasmine.jade.util.Logger;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;

public class DeployerManagerImpl
implements DeployerService,
LifeCycleController,
BindingController {
    private boolean started = false;
    static final String[] attList = new String[0];
    private final String[] bindingList = new String[]{"registry", "deployer"};
    private Component myself;
    private NamingService registry = null;
    private Factory deployer;
    private Map<Component, Deployment> deployedApps = new HashMap<Component, Deployment>();
    private int deploymentId = 0;
    private Map<Integer, Component> deployedComponents = new HashMap<Integer, Component>();

    public String[] listFc() {
        return this.bindingList;
    }

    public Object lookupFc(String itfName) throws NoSuchInterfaceException {
        if (itfName.equals("component")) {
            return this.myself;
        }
        if (itfName.equals("deployer")) {
            return this.deployer;
        }
        if (itfName.equals("registry")) {
            return this.registry;
        }
        throw new NoSuchInterfaceException(itfName);
    }

    public void bindFc(String itfName, Object itfValue) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (itfName.equals("component")) {
            this.myself = (Component)itfValue;
        } else if (itfName.equals("deployer")) {
            this.deployer = (Factory)itfValue;
        } else if (itfName.equals("registry")) {
            this.registry = (NamingService)itfValue;
        } else {
            throw new NoSuchInterfaceException(itfName);
        }
    }

    public void unbindFc(String itfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (itfName.equals("component")) {
            this.myself = null;
        } else if (itfName.equals("deployer")) {
            this.deployer = null;
        } else if (itfName.equals("registry")) {
            this.registry = null;
        } else {
            throw new NoSuchInterfaceException(itfName);
        }
    }

    public String getFcState() {
        if (this.started) {
            return "STARTED";
        }
        return "STOPPED";
    }

    public void startFc() throws IllegalLifeCycleException {
        if (this.started) {
            throw new IllegalLifeCycleException("Component already started");
        }
        try {
            Component[] supers = Fractal.getSuperController((Component)this.myself).getFcSuperComponents();
            if (supers.length > 1) {
                Logger.println(true, "Can't register Deployer. More than one Super Component found");
            } else {
                this.registry.bind("deployer", supers[0]);
            }
        }
        catch (NoSuchInterfaceException e) {
            Logger.println(true, "Can't register Deployer. No Super Component found");
        }
        this.started = true;
        Logger.println(true, "[Deployer] started");
    }

    public void stopFc() throws IllegalLifeCycleException {
        if (!this.started) {
            throw new IllegalLifeCycleException("Component already stopped");
        }
        this.started = false;
        Logger.println(true, "[Deployer] stopped");
    }

    public Component deploy(String adlId, Map context) throws DeploymentException {
        Object deployedApplication = null;
        if (adlId != null) {
            Logger.println(true, "*********************************  DEPLOYER  ******************************");
            Logger.println(true, "[DeployerManager] ");
            Logger.println(true, "Deploying \"" + adlId + "\" ...");
            try {
                context.put("classloader", this.getClass().getClassLoader());
                deployedApplication = (Component)this.deployer.newComponent(adlId, context);
                Logger.println(true, "****************************************");
                Logger.println(true, "[DeployerManager] ");
                Logger.println(true, "component \"" + adlId + "\" registered");
                Logger.println(true, "****************************************");
                this.deployedApps.put((Component)deployedApplication, new Deployment(adlId, this.deploymentId++, new Date(), null));
                Logger.println(true, "[DeployerManager] ");
                Logger.println(true, "\"" + adlId + "\" successfully deployed");
                Logger.println(true, "***************************************************************************");
            }
            catch (Exception e) {
                this.printDeploymentCancelled(e);
                throw new DeploymentException("Unable to deploy application \"" + adlId + "\" : " + e.getMessage());
            }
        }
        this.deployedComponents.put(deployedApplication.hashCode(), (Component)deployedApplication);
        return deployedApplication;
    }

    public void start(Component deployedComponent) throws DeploymentException {
        Deployment deployment = this.deployedApps.get(deployedComponent);
        if (deployment == null) {
            throw new DeploymentException("[DeployerManager] Unable to start application defined by the component \"" + deployedComponent + "\" : application not found");
        }
        try {
            Fractal.getLifeCycleController((Component)deployedComponent).startFc();
            Object sItf = null;
            Object rItf = null;
            try {
                sItf = deployedComponent.getFcInterface("service");
            }
            catch (NoSuchInterfaceException ignored) {
                // empty catch block
            }
            try {
                rItf = deployedComponent.getFcInterface("rsrc");
            }
            catch (NoSuchInterfaceException ignored2) {
                // empty catch block
            }
            if (sItf != null && sItf instanceof Service) {
                ((Service)sItf).start();
            }
            if (rItf != null && rItf instanceof Resource) {
                ((Resource)rItf).start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentException("[DeployerManager] Unable to start application defined by the ID \"" + deployedComponent + "\" : " + e.getLocalizedMessage());
        }
    }

    public void stop(Component deployedComponent) throws DeploymentException {
        block8: {
            Deployment deployment = this.deployedApps.get(deployedComponent);
            if (deployment == null) {
                throw new DeploymentException("[DeployerManager] Unable to stop application defined by the component \"" + deployedComponent + "\" : application not found");
            }
            try {
                if (deployedComponent != null) {
                    try {
                        Interface[] lfItf = FractalUtil.getServerInterfaceBySignature(deployedComponent, "org.objectweb.jasmine.jade.service.Service");
                        if (lfItf != null) {
                            if (lfItf.length > 1) {
                                throw new JadeException("[DeployerManager] Unable to stop application \"" + deployedComponent + "\" : multiple Service interface found");
                            }
                            ((Service)lfItf[0]).stop();
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        throw new DeploymentException("[DeployerManager] Unable to stop application defined by the component \"" + deployedComponent + "\" : " + e.getLocalizedMessage());
                    }
                }
                throw new DeploymentException("[DeployerManager] Unable to stop application defined by the component \"" + deployedComponent + "\" : application not found");
            }
            catch (Exception e) {
                throw new DeploymentException("[DeployerManager] Unable to stop application defined by the component \"" + deployedComponent + "\" : " + e.getLocalizedMessage());
            }
        }
    }

    public void undeploy(Component deployedComponent) throws DeploymentException {
        Logger.println(true, "*********************************  DEPLOYER  ******************************");
        Logger.print(true, "[DeployerManager] ");
        Logger.println(true, "Undeploying \"" + deployedComponent + "\" ...");
        if (deployedComponent != null) {
            try {
                this.registry.unbind(Fractal.getNameController((Component)deployedComponent).getFcName());
            }
            catch (NoSuchInterfaceException ignored) {
                // empty catch block
            }
            UndeploymentController uc = null;
            try {
                uc = (UndeploymentController)deployedComponent.getFcInterface("undeployment-controller");
            }
            catch (NoSuchInterfaceException e) {
                Logger.print(true, "[DeployerManager] ");
                Logger.println(true, "This component can't be undeployed");
                return;
            }
            try {
                uc.undeploy();
            }
            catch (UndeploymentException e) {
                throw new DeploymentException("[DeployerManager] " + e.getMessage());
            }
        }
        throw new DeploymentException("[DeployerManager] Unable to stop application defined by the component \"" + deployedComponent + "\" : application not found");
        this.deployedApps.remove(deployedComponent);
        Logger.println(true, "***************************************************************************");
    }

    public Component[] getDeployedComponents() {
        return this.deployedApps.keySet().toArray(new Component[0]);
    }

    public int deployForJmx(String adlId, Map context) throws DeploymentException {
        Component component = this.deploy(adlId, context);
        this.deployedComponents.put(component.hashCode(), component);
        return component.hashCode();
    }

    public void start(int deployedComponent) throws DeploymentException {
        this.start(this.deployedComponents.get(deployedComponent));
    }

    public void stop(int deployedComponent) throws DeploymentException {
        this.stop(this.deployedComponents.get(deployedComponent));
    }

    public void undeploy(int deployedComponent) throws DeploymentException {
        this.undeploy(this.deployedComponents.get(deployedComponent));
    }

    public void setAttribute(int deployedComponent, String name, String value) throws DeploymentException {
        Component c = this.deployedComponents.get(deployedComponent);
        try {
            GenericAttributeController resource = (GenericAttributeController)c.getFcInterface("attributes");
            resource.setAttribute(name, value);
        }
        catch (NoSuchInterfaceException e) {
            throw new DeploymentException(e);
        }
        catch (NoSuchAttributeException e) {
            throw new DeploymentException(e);
        }
    }

    private void printDeploymentCancelled(Exception exception) {
        Logger.println(true, "****************************************");
        Logger.println(true, "ERROR DURING DEPLOYMENT : ");
        Logger.print(true, "[DeployerManager] ");
        Logger.println(true, exception.getMessage());
        exception.printStackTrace();
        Logger.println(true, "***************************************************************************");
    }

    class Deployment {
        private String adlId;
        private int deploymentID;
        private Date date;
        private String comment;

        public Deployment() {
        }

        public Deployment(String adlId, int deploymentID, Date date, String comment) {
            this.adlId = adlId;
            this.deploymentID = deploymentID;
            this.date = date;
            this.comment = comment;
        }

        public String getAdlId() {
            return this.adlId;
        }

        public void setAdlId(String adlId) {
            this.adlId = adlId;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public int getComponent() {
            return this.deploymentID;
        }

        public void setComponent(int deploymentID) {
            this.deploymentID = deploymentID;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }
    }
}

