/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.objectweb.jasmine.jade.util.JadeException;

public class ExecutableCmd {
    private static Runtime rt = Runtime.getRuntime();

    public static void syncExec(String cmd, String[] envp) throws JadeException {
        try {
            Process p = rt.exec(cmd, envp);
            p.waitFor();
        }
        catch (Exception e) {
            throw new JadeException("(ExecutableCmd: cannot execute cmd " + cmd, e);
        }
    }

    public static Process asyncExec(String cmd, String[] envp) throws JadeException {
        try {
            Process p = rt.exec(cmd, envp);
            return p;
        }
        catch (Exception e) {
            throw new JadeException("ExecutableCmd: cannot execute cmd " + cmd, e);
        }
    }

    public static Object getResult(Process p) throws JadeException {
        StringBuffer result = new StringBuffer();
        try {
            InputStream stdout = p.getInputStream();
            InputStream stderr = p.getErrorStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(stdout));
            while (br.ready()) {
                result.append("out> " + br.readLine() + "\n");
            }
            br = new BufferedReader(new InputStreamReader(stderr));
            if (br.ready()) {
                result.append("----------------------------------------------\n");
            }
            while (br.ready()) {
                result.append("err> " + br.readLine() + "\n");
            }
        }
        catch (Exception e) {
            throw new JadeException("(ExecutableCmd: cannot get result ", e);
        }
        result.append("----------------------------------------------\n");
        return result.toString();
    }
}

