/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.util.BindingControllerHelper;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.jasmine.jade.util.NoSuchComponentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractalUtil {
    public static Set<Component> getNeighborsComponents(Component cmp) {
        HashSet<Component> neighbors = new HashSet<Component>();
        Set neighborItfs = BindingControllerHelper.getFcClientItfsBoundTo((Component)cmp);
        neighborItfs.addAll(BindingControllerHelper.getFcServerItfsBoundTo((Component)cmp));
        for (Interface i : neighborItfs) {
            Component c = i.getFcItfOwner();
            if (neighbors.contains(c)) continue;
            neighbors.add(c);
        }
        try {
            for (Component c : Fractal.getContentController((Component)cmp).getFcSubComponents()) {
                if (neighbors.contains(c)) continue;
                neighbors.add(c);
            }
        }
        catch (NoSuchInterfaceException ignored) {
            // empty catch block
        }
        try {
            for (Component c : Fractal.getSuperController((Component)cmp).getFcSuperComponents()) {
                if (neighbors.contains(c)) continue;
                neighbors.add(c);
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return neighbors;
    }

    public static Component getSubComponentByPath(Component sup, String sub) throws NoSuchComponentException {
        Component res = sup;
        while (sub != null) {
            String subsub;
            int i = sub.indexOf("/");
            if (i != -1) {
                subsub = sub.substring(0, i);
                sub = sub.substring(i + 1);
            } else {
                subsub = sub;
                sub = null;
            }
            res = FractalUtil.getDirectSubComponentByName(res, subsub);
        }
        return res;
    }

    public static Component getDirectSubComponentByName(Component comp, String name) throws NoSuchComponentException {
        ContentController cc = null;
        try {
            cc = Fractal.getContentController((Component)comp);
        }
        catch (NoSuchInterfaceException e) {
            throw new NoSuchComponentException(e.getMessage());
        }
        for (Component sc : cc.getFcSubComponents()) {
            try {
                NameController nc = Fractal.getNameController((Component)sc);
                if (!name.equals(nc.getFcName())) continue;
                return sc;
            }
            catch (NoSuchInterfaceException ignored) {
                // empty catch block
            }
        }
        String compName = "";
        try {
            compName = Fractal.getNameController((Component)comp).getFcName();
        }
        catch (NoSuchInterfaceException ignored) {
            // empty catch block
        }
        throw new NoSuchComponentException("The component named \"" + name + "\" was not found in the component \"" + compName + "\"");
    }

    public static Component getSuperComponentByPath(Component sub, String sup) throws NoSuchComponentException {
        Component res = sub;
        while (sup != null) {
            String supsup;
            int i = sup.indexOf("/");
            if (i != -1) {
                supsup = sup.substring(0, i);
                sup = sup.substring(i + 1);
            } else {
                supsup = sup;
                sup = null;
            }
            res = FractalUtil.getDirectSuperComponentByName(res, supsup);
        }
        return res;
    }

    public static Component getDirectSuperComponentByName(Component comp, String name) throws NoSuchComponentException {
        SuperController sc = null;
        try {
            sc = Fractal.getSuperController((Component)comp);
        }
        catch (NoSuchInterfaceException e) {
            throw new NoSuchComponentException(e.getMessage());
        }
        for (Component c : sc.getFcSuperComponents()) {
            try {
                NameController nc = Fractal.getNameController((Component)c);
                if (!name.equals(nc.getFcName())) continue;
                return c;
            }
            catch (NoSuchInterfaceException ignored) {
                // empty catch block
            }
        }
        String compName = "";
        try {
            compName = Fractal.getNameController((Component)comp).getFcName();
        }
        catch (NoSuchInterfaceException ignored) {
            // empty catch block
        }
        throw new NoSuchComponentException("The component named \"" + compName + "\" hasn't super component named \"" + name + "\"");
    }

    public static Component getFirstFoundSuperComponentByName(Component comp, String name) throws NoSuchComponentException {
        try {
            String nameComp = Fractal.getNameController((Component)comp).getFcName();
            if (name.equals(nameComp)) {
                return comp;
            }
        }
        catch (NoSuchInterfaceException ignored) {
            // empty catch block
        }
        SuperController sc = null;
        try {
            sc = Fractal.getSuperController((Component)comp);
        }
        catch (NoSuchInterfaceException e) {
            throw new NoSuchComponentException(e.getMessage());
        }
        Component[] cmps = sc.getFcSuperComponents();
        if (cmps.length != 0) {
            for (Component c : cmps) {
                try {
                    Component res = FractalUtil.getFirstFoundSuperComponentByName(c, name);
                    return res;
                }
                catch (NoSuchComponentException e) {
                }
            }
        }
        String compName = "";
        try {
            compName = Fractal.getNameController((Component)comp).getFcName();
        }
        catch (NoSuchInterfaceException ignored) {
            // empty catch block
        }
        throw new NoSuchComponentException("The component named \"" + compName + "\" hasn't super component named \"" + name + "\"");
    }

    public static Component getFirstFoundSubComponentByName(Component comp, String name) throws NoSuchComponentException {
        try {
            String nameComp = Fractal.getNameController((Component)comp).getFcName();
            if (name.equals(nameComp)) {
                return comp;
            }
        }
        catch (NoSuchInterfaceException ignored) {
            // empty catch block
        }
        ContentController sc = null;
        try {
            sc = Fractal.getContentController((Component)comp);
        }
        catch (NoSuchInterfaceException e) {
            throw new NoSuchComponentException(e.getMessage());
        }
        Component[] cmps = sc.getFcSubComponents();
        if (cmps.length != 0) {
            for (Component c : cmps) {
                try {
                    Component res = FractalUtil.getFirstFoundSubComponentByName(c, name);
                    return res;
                }
                catch (NoSuchComponentException e) {
                }
            }
        }
        String compName = "";
        try {
            compName = Fractal.getNameController((Component)comp).getFcName();
        }
        catch (NoSuchInterfaceException ignored) {
            // empty catch block
        }
        throw new NoSuchComponentException("The component named \"" + compName + "\" hasn't sub component named \"" + name + "\"");
    }

    public static Component getFirstFoundSuperComponentByServerInterfaceSignature(Component comp, String signature) throws NoSuchComponentException {
        if (FractalUtil.exposeServerInterfaceBySignature(comp, signature)) {
            return comp;
        }
        SuperController sc = null;
        try {
            sc = Fractal.getSuperController((Component)comp);
        }
        catch (NoSuchInterfaceException e) {
            throw new NoSuchComponentException(e.getMessage());
        }
        Component[] cmps = sc.getFcSuperComponents();
        if (cmps.length != 0) {
            for (Component c : cmps) {
                try {
                    Component res = FractalUtil.getFirstFoundSuperComponentByServerInterfaceSignature(c, signature);
                    return res;
                }
                catch (NoSuchComponentException e) {
                }
            }
        }
        String compName = "";
        try {
            compName = Fractal.getNameController((Component)comp).getFcName();
        }
        catch (NoSuchInterfaceException ignored) {
            // empty catch block
        }
        throw new NoSuchComponentException("The component named \"" + compName + "\" hasn't super component exposing a server interface with signature \"" + signature + "\"");
    }

    public static Set<Interface> getServerInterfaces(Component cmp) {
        Interface itf_M;
        HashSet<Interface> itfs = new HashSet<Interface>();
        for (Object o : cmp.getFcInterfaces()) {
            itf_M = (Interface)o;
            if (((InterfaceType)itf_M.getFcItfType()).isFcClientItf()) continue;
            itfs.add(itf_M);
        }
        try {
            for (Object o : Fractal.getContentController((Component)cmp).getFcInternalInterfaces()) {
                itf_M = (Interface)o;
                if (((InterfaceType)itf_M.getFcItfType()).isFcClientItf()) continue;
                itfs.add(itf_M);
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return itfs;
    }

    public static Set<Interface> getClientInterfaces(Component cmp) {
        Interface itf_M;
        HashSet<Interface> itfs = new HashSet<Interface>();
        for (Object o : cmp.getFcInterfaces()) {
            itf_M = (Interface)o;
            if (!((InterfaceType)itf_M.getFcItfType()).isFcClientItf()) continue;
            itfs.add(itf_M);
        }
        try {
            for (Object o : Fractal.getContentController((Component)cmp).getFcInternalInterfaces()) {
                itf_M = (Interface)o;
                if (!((InterfaceType)itf_M.getFcItfType()).isFcClientItf()) continue;
                itfs.add(itf_M);
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return itfs;
    }

    public static Interface[] getClientInterfaceBySignature(Component cmp, String signature) {
        ArrayList<Object> res = new ArrayList<Object>();
        Object[] itf = cmp.getFcInterfaces();
        if (itf != null) {
            InterfaceType itfType = null;
            for (int i = 0; i < itf.length; ++i) {
                itfType = (InterfaceType)((Interface)itf[i]).getFcItfType();
                if (!itfType.isFcClientItf() || !itfType.getFcItfSignature().equals(signature)) continue;
                res.add(itf[i]);
            }
        }
        if (!res.isEmpty()) {
            return res.toArray(new Interface[0]);
        }
        return null;
    }

    public static Interface[] getServerInterfaceBySignature(Component cmp, String signature) {
        ArrayList<Object> res = new ArrayList<Object>();
        Object[] itf = cmp.getFcInterfaces();
        if (itf != null) {
            InterfaceType itfType = null;
            for (int i = 0; i < itf.length; ++i) {
                itfType = (InterfaceType)((Interface)itf[i]).getFcItfType();
                if (itfType.isFcClientItf() || !itfType.getFcItfSignature().equals(signature)) continue;
                res.add(itf[i]);
            }
        }
        if (!res.isEmpty()) {
            return res.toArray(new Interface[0]);
        }
        return null;
    }

    public static boolean exposeServerInterfaceBySignature(Component cmp, String signature) {
        Object[] itf = cmp.getFcInterfaces();
        if (itf.length != 0) {
            InterfaceType itfType = null;
            for (int i = 0; i < itf.length; ++i) {
                itfType = (InterfaceType)((Interface)itf[i]).getFcItfType();
                if (itfType.isFcClientItf() || !itfType.getFcItfSignature().equals(signature)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFcItfInstanceOf(Interface itf, String signature) {
        return signature.equals(((InterfaceType)itf.getFcItfType()).getFcItfSignature());
    }

    public boolean isFcComponentTypeContaingInterface(Component component, String signature) {
        Object[] itfs;
        for (Object itf : itfs = component.getFcInterfaces()) {
            if (!this.isFcItfInstanceOf((Interface)itf, signature)) continue;
            return true;
        }
        return false;
    }
}

