/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.control.joram.analyser;

import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jms.TopicConnectionFactory;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fscript.FScript;
import org.objectweb.fractal.fscript.FScriptEngine;
import org.objectweb.fractal.fscript.FScriptException;
import org.objectweb.fractal.fscript.ScriptLoader;
import org.objectweb.fractal.fscript.model.Node;
import org.objectweb.fractal.fscript.model.fractal.ComponentNode;
import org.objectweb.fractal.fscript.model.fractal.NodeFactory;
import org.objectweb.fractal.rmi.registry.NamingService;
import org.objectweb.fractal.rmi.registry.Registry;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.jasmine.jade.osgi.JadeProperties;
import org.objectweb.jasmine.jade.service.allocator.Allocator;
import org.objectweb.jasmine.jade.util.Logger;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.ow2.jasmine.jade.control.joram.api.JoramManagerJMX;
import org.ow2.jasmine.jade.control.joram.sensor.JMXProbe;
import org.ow2.jasmine.jade.control.joram.util.JoramManagerProxy;
import org.ow2.jasmine.jade.control.joram.util.MonitoredClusterQueues;
import org.ow2.jasmine.jade.control.joram.util.Stats;
import org.ow2.jasmine.jade.control.joram.util.UnknownClusterQueueException;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;
import org.ow2.jasmine.jade.fractal.util.FractalUtil;
import org.ow2.jasmine.jade.resources.joram.JoramOptimizationManager;

public class JoramOptimizationManagerImpl
implements JoramOptimizationManager,
JoramManagerJMX,
LifeCycleController,
BindingController,
GenericAttributeController {
    private static int DEFAULT_MAX_PROD_WEIGHT = 500;
    private static int DEFAULT_MAX_CONS_WEIGHT = 500;
    private static final int PORT_NUMBER_START = 16020;
    private final String SERVER_PREFIX = "JoramServer_";
    private final String CLUSTER_QUEUE_PREFIX = "ClusterQueue_";
    private Object lock = new Object();
    private boolean started = false;
    static final String[] attList = new String[]{"policyFlexibilityPercentage", "activatedJMXProbe", "messageCountThreshold"};
    private float policyFlexibilityPercentage = 0.5f;
    private int messageCountThreshold = 450;
    private Component myself;
    private FScriptEngine engine;
    private NodeFactory nf;
    private ScriptLoader sl;
    private Allocator allocator = null;
    private boolean activatedJMXProbe = false;
    private JMXProbe probe = null;
    private int jMXPort = 0;
    private HashMap<String, Stats> monitoredServers = new HashMap();
    private MonitoredClusterQueues monitoredCQs = new MonitoredClusterQueues();

    public JoramOptimizationManagerImpl() {
        System.setProperty("fscript.engine", "org.objectweb.fractal.fscript.FScriptJade");
        try {
            Factory fact = FactoryFactory.getFactory((String)"org.objectweb.fractal.adl.FractalBackend");
            String engineDef = System.getProperty("fscript.engine", "org.objectweb.fractal.fscript.FScript");
            Component fscript = (Component)fact.newComponent(engineDef, Collections.emptyMap());
            Fractal.getLifeCycleController((Component)fscript).startFc();
            FScript.loadStandardLibrary((Component)fscript);
            this.engine = FScript.getFScriptEngine((Component)fscript);
            this.nf = FScript.getNodeFactory((Component)fscript);
            this.sl = FScript.getScriptLoader((Component)fscript);
            JadeProperties jadeProps = JadeProperties.getInstance();
            NamingService ns = Registry.getRegistry((String)jadeProps.getJadeRegistryHost(), (int)Integer.parseInt(jadeProps.getJadeRegistryPort()));
            this.engine.setGlobalVariable("*rmiregistry*", (Object)ns);
            this.sl.load((Reader)new FileReader("./fscript/joramFelix.fscript"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] listFcAtt() {
        return attList;
    }

    public String getAttribute(String name) throws NoSuchAttributeException {
        if (name.equals("policyFlexibilityPercentage")) {
            return new Float(this.policyFlexibilityPercentage).toString();
        }
        if (name.equals("activatedJMXProbe")) {
            return new Boolean(this.activatedJMXProbe).toString();
        }
        if (name.equals("messageCountThreshold")) {
            return new Integer(this.messageCountThreshold).toString();
        }
        throw new NoSuchAttributeException(name);
    }

    public void setAttribute(String name, String value) throws NoSuchAttributeException {
        if (name.equals("policyFlexibilityPercentage")) {
            try {
                this.policyFlexibilityPercentage = new Float(value).floatValue();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                System.out.println("Warning! The policyFlexibilityPercentage value was not modified.");
            }
        } else if (!name.equals("activatedJMXProbe")) {
            if (name.equals("messageCountThreshold")) {
                try {
                    this.messageCountThreshold = new Integer(value);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    System.out.println("Warning! The messageCountThreshold value was not modified.");
                }
            } else {
                throw new NoSuchAttributeException(name);
            }
        }
    }

    public String[] listFc() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("component");
        keys.add("allocator");
        return keys.toArray(new String[keys.size()]);
    }

    public Object lookupFc(String itfName) throws NoSuchInterfaceException {
        if (itfName.equals("component")) {
            return this.myself;
        }
        if (itfName.equals("allocator")) {
            return this.allocator;
        }
        throw new NoSuchInterfaceException(itfName);
    }

    public void bindFc(String itfName, Object itfValue) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (itfName.equals("component")) {
            this.myself = (Component)itfValue;
        } else if (itfName.equals("allocator")) {
            this.allocator = (Allocator)itfValue;
        } else {
            throw new NoSuchInterfaceException(itfName);
        }
    }

    public void unbindFc(String itfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (itfName.equals("component")) {
            this.myself = null;
        } else if (itfName.equals("allocator")) {
            this.allocator = null;
        } else {
            throw new NoSuchInterfaceException(itfName);
        }
    }

    public String getFcState() {
        if (this.started) {
            return "STARTED";
        }
        return "STOPPED";
    }

    public void startFc() throws IllegalLifeCycleException {
        if (this.started) {
            throw new IllegalLifeCycleException("Component [JoramOptimizationManager] already started");
        }
        this.started = true;
        try {
            JoramManagerProxy.init((JoramOptimizationManager)this.myself.getFcInterface("JoramOptimizationManager"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Logger.println((boolean)true, (String)"[JoramOptimizationManager] started");
        if (this.getAllClusterQueuesComps() == null) {
            return;
        }
        for (Component cq : this.getAllClusterQueuesComps()) {
            try {
                this.updateCQStats(cq);
            }
            catch (UnknownClusterQueueException e) {
                e.printStackTrace();
            }
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        if (!this.started) {
            throw new IllegalLifeCycleException("Component [JoramOptimizationManager] already stopped");
        }
        this.started = false;
        JoramManagerProxy.destroy();
        Logger.println((boolean)true, (String)"[JoramOptimizationManager] stopped");
    }

    public String getLocation(String cQName, int prodWeight, int consWeight) throws Exception {
        Component cq = this.getServerOrClusterQueueCompFromName(cQName);
        this.updateCQStats(cq);
        return this.findOptimalLocation(cQName, prodWeight, consWeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String cQName, String serverName, int prodWeight, int consWeight) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            try {
                System.out.println("remove - prodWeight = " + prodWeight + " consWeight = " + consWeight);
                Stats queueStats = this.monitoredCQs.getQueueStats(cQName, serverName);
                queueStats.setProdWeight(queueStats.getProdWeight() - prodWeight);
                queueStats.setConsWeight(queueStats.getConsWeight() - consWeight);
                Stats serverStats = this.monitoredServers.get(serverName);
                serverStats.setProdWeight(serverStats.getProdWeight() - prodWeight);
                serverStats.setConsWeight(serverStats.getConsWeight() - consWeight);
            }
            catch (Exception e) {
                throw new UnknownClusterQueueException();
            }
            System.out.println("" + this.monitoredCQs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String cQName, String server1, String server2, int prodWeight, int consWeight) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.remove(cQName, server1, prodWeight, consWeight);
            Stats queueStats = this.monitoredCQs.getQueueStats(cQName, server2);
            queueStats.setProdWeight(queueStats.getProdWeight() + prodWeight);
            queueStats.setConsWeight(queueStats.getConsWeight() + consWeight);
            Stats serverStats = this.monitoredServers.get(server2);
            serverStats.setProdWeight(serverStats.getProdWeight() + prodWeight);
            serverStats.setConsWeight(serverStats.getConsWeight() + consWeight);
            System.out.println("" + this.monitoredCQs);
        }
    }

    public synchronized void enableJMXProbe(int port, int pollingInterval, boolean policyJMX) {
        if (this.probe != null && this.activatedJMXProbe != policyJMX) {
            this.activatedJMXProbe = policyJMX;
        } else if (this.probe == null) {
            this.jMXPort = port;
            this.activatedJMXProbe = policyJMX;
            this.probe = new JMXProbe(pollingInterval);
            String[] listCQ = this.monitoredCQs.listCQ();
            for (int i = 0; i < listCQ.length; ++i) {
                Component compCQ = null;
                try {
                    compCQ = this.getServerOrClusterQueueCompFromName(listCQ[i]);
                }
                catch (UnknownClusterQueueException e1) {
                    e1.printStackTrace();
                }
                try {
                    ContentController cc = Fractal.getContentController((Component)compCQ);
                    Component[] subComp = cc.getFcSubComponents();
                    for (int j = 0; j < subComp.length; ++j) {
                        try {
                            Component server = this.getParentServerCompFromComp(subComp[j]);
                            String qName = Fractal.getNameController((Component)subComp[j]).getFcName();
                            String sid = FractalUtil.getGenericAttributeController((Component)server).getAttribute("sid");
                            String serverHostName = FractalUtil.getGenericAttributeController((Component)server).getAttribute("host");
                            this.probe.addServer(sid, serverHostName, this.jMXPort, qName, this.monitoredCQs.getQueueStats(listCQ[i], sid));
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.probe.start();
        }
    }

    public synchronized void disableJMXProbe() {
        this.probe.stopJMXProbe();
        this.activatedJMXProbe = false;
        this.probe = null;
    }

    public synchronized void setJMXPollingInterval(int interval) {
        if (this.probe != null) {
            this.probe.setPollingInterval(interval);
        }
    }

    private String printServers() {
        String result = "\tMonitored Servers";
        for (String serverName : this.monitoredServers.keySet()) {
            result = result + "\nServer " + serverName + "\n" + this.monitoredServers.get(serverName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WeightedServer[] serversSort(String cQName, int prodWeight, int consWeight) {
        int i;
        Iterator<String> serverList = this.monitoredCQs.listServers(cQName);
        ArrayList<BalanceProdConsServer> workList = new ArrayList<BalanceProdConsServer>();
        WeightedServer[] result = null;
        Object object = this.lock;
        synchronized (object) {
            while (serverList.hasNext()) {
                String serverId = serverList.next();
                Stats queueStats = this.monitoredCQs.getQueueStats(cQName, serverId);
                int balanceAfter = prodWeight + queueStats.getProdWeight() - consWeight - queueStats.getConsWeight();
                workList.add(new BalanceProdConsServer(serverId, balanceAfter, prodWeight - consWeight));
            }
            Collections.sort(workList);
            result = new WeightedServer[workList.size()];
            for (i = 0; i < workList.size(); ++i) {
                String serverName = ((BalanceProdConsServer)workList.get(i)).getServerName();
                result[i] = new WeightedServer(serverName, this.monitoredCQs.getQueueStats(cQName, serverName).getMaxProdWeight(), ((BalanceProdConsServer)workList.get(i)).getBalanceAfter());
            }
        }
        if (this.activatedJMXProbe) {
            ArrayList<WeightedServer> serverList2 = new ArrayList<WeightedServer>();
            if (prodWeight > 0) {
                for (i = 0; i < result.length; ++i) {
                    if (result[i].getMsgCount() >= this.messageCountThreshold) continue;
                    serverList2.add(result[i]);
                }
                if (serverList2.size() > 0) {
                    result = serverList2.toArray(new WeightedServer[0]);
                }
            } else {
                for (i = 0; i < result.length; ++i) {
                    serverList2.add(result[i]);
                }
                Collections.sort(serverList2);
                result = serverList2.toArray(new WeightedServer[0]);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findOptimalLocation(String cQName, int prodWeight, int consWeight) {
        WeightedServer[] serverList = this.serversSort(cQName, prodWeight, consWeight);
        String result = null;
        Object object = this.lock;
        synchronized (object) {
            Stats serverStats;
            float policyFactor = 1.0f + this.policyFlexibilityPercentage;
            int i = 0;
            if (serverList[0].getBalanceAfter() <= 0 && prodWeight > 0 || serverList[0].getBalanceAfter() >= 0 && consWeight > 0) {
                result = serverList[0].getServerName();
            }
            while (i < serverList.length && result == null) {
                serverStats = this.monitoredServers.get(serverList[i].getServerName());
                if ((prodWeight > 0 && serverStats.getProdWeight() + prodWeight <= serverStats.getMaxProdWeight() || consWeight > 0 && serverStats.getConsWeight() + consWeight <= serverStats.getMaxConsWeight()) && (serverStats.getProdWeight() > 0 || serverStats.getConsWeight() > 0)) {
                    result = serverList[i].getServerName();
                }
                ++i;
            }
            for (i = 0; i < serverList.length && result == null; ++i) {
                serverStats = this.monitoredServers.get(serverList[i].getServerName());
                if ((prodWeight <= 0 || serverStats.getProdWeight() + prodWeight > serverStats.getMaxProdWeight()) && (consWeight <= 0 || serverStats.getConsWeight() + consWeight > serverStats.getMaxConsWeight())) continue;
                result = serverList[i].getServerName();
            }
            if (result == null) {
                result = this.allocateNewServer(cQName);
            }
            for (i = 0; i < serverList.length && result == null; ++i) {
                serverStats = this.monitoredServers.get(serverList[i].getServerName());
                if (!(prodWeight > 0 && (float)(serverStats.getProdWeight() + prodWeight) <= (float)serverStats.getMaxProdWeight() * policyFactor) && (consWeight <= 0 || !((float)(serverStats.getConsWeight() + consWeight) <= (float)serverStats.getMaxConsWeight() * policyFactor))) continue;
                result = serverList[i].getServerName();
            }
            if (result == null) {
                result = serverList[0].getServerName();
            }
            Stats updatedCQ = this.monitoredCQs.getQueueStats(cQName, result);
            updatedCQ.setProdWeight(updatedCQ.getProdWeight() + prodWeight);
            updatedCQ.setConsWeight(updatedCQ.getConsWeight() + consWeight);
            Stats updatedServer = this.monitoredServers.get(result);
            updatedServer.setProdWeight(updatedServer.getProdWeight() + prodWeight);
            updatedServer.setConsWeight(updatedServer.getConsWeight() + consWeight);
        }
        System.out.println("" + this.monitoredCQs);
        System.out.println("Returned location: " + result);
        return result;
    }

    private Component[] getAllClusterQueuesComps() {
        try {
            this.engine.setGlobalVariable("self", (Object)this.nf.createComponentNode(this.myself));
            Set nodes = (Set)this.engine.execute("$self/sibling::*[starts-with(name(.), 'ClusterQueue_')]");
            Component[] res = new Component[nodes.size()];
            int i = 0;
            for (Node node : nodes) {
                ComponentNode cnode = (ComponentNode)node;
                res[i] = cnode.getComponent();
                ++i;
            }
            return res;
        }
        catch (FScriptException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    private Component getParentServerCompFromComp(Component subcomp) throws UnknownClusterQueueException {
        try {
            this.engine.setGlobalVariable("self", (Object)this.nf.createComponentNode(subcomp));
            Set nodes = (Set)this.engine.execute("$self/parent::*[starts-with(name(.), 'JoramServer_')]");
            if (nodes.isEmpty()) {
                throw new UnknownClusterQueueException();
            }
            ComponentNode cnode = (ComponentNode)nodes.iterator().next();
            return cnode.getComponent();
        }
        catch (FScriptException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    private Component getServerOrClusterQueueCompFromName(String name) throws UnknownClusterQueueException {
        try {
            this.engine.setGlobalVariable("name", (Object)name);
            this.engine.setGlobalVariable("self", (Object)this.nf.createComponentNode(this.myself));
            Set nodes = (Set)this.engine.execute("$self/sibling::$name");
            if (nodes.isEmpty()) {
                throw new UnknownClusterQueueException();
            }
            ComponentNode cnode = (ComponentNode)nodes.iterator().next();
            return cnode.getComponent();
        }
        catch (FScriptException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCQStats(Component clusterQueue) throws UnknownClusterQueueException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.engine.setGlobalVariable("self", (Object)this.nf.createComponentNode(this.myself));
                Set nodes = (Set)this.engine.execute("$self/sibling::*[starts-with(name(.), 'JoramServer_')]");
                for (Node node : nodes) {
                    ComponentNode cnode = (ComponentNode)node;
                    Component server = cnode.getComponent();
                    String sid = FractalUtil.getGenericAttributeController((Component)server).getAttribute("sid");
                    if (this.monitoredServers.containsKey(sid)) continue;
                    this.monitoredServers.put(sid, new Stats(0, 0, DEFAULT_MAX_PROD_WEIGHT, DEFAULT_MAX_CONS_WEIGHT));
                    this.printServers();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String cqName = "";
        try {
            cqName = Fractal.getNameController((Component)clusterQueue).getFcName();
        }
        catch (NoSuchInterfaceException e1) {
            e1.printStackTrace();
        }
        try {
            Component[] queueList = Fractal.getContentController((Component)clusterQueue).getFcSubComponents();
            Object object2 = this.lock;
            synchronized (object2) {
                if (!this.monitoredCQs.containsCQ(cqName)) {
                    this.monitoredCQs.addClusterQueue(cqName);
                }
                for (int i = 0; i < queueList.length; ++i) {
                    try {
                        ComponentNode cnode;
                        Component server;
                        String sid;
                        this.engine.setGlobalVariable("queue", (Object)this.nf.createComponentNode(queueList[i]));
                        Set nodes = (Set)this.engine.execute("$queue/parent::*[starts-with(name(.), 'JoramServer_')]");
                        if (nodes.isEmpty() || this.monitoredCQs.containsServer(cqName, sid = FractalUtil.getGenericAttributeController((Component)(server = (cnode = (ComponentNode)nodes.iterator().next()).getComponent())).getAttribute("sid"))) continue;
                        this.monitoredCQs.addServer(cqName, sid);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String allocateNewServer(String cQName) {
        Object serverAdminName;
        String[] freeHostNames = this.allocator.getFreeComponentName();
        if (freeHostNames.length <= 0) {
            return null;
        }
        Component server = null;
        try {
            this.engine.setGlobalVariable("self", (Object)this.nf.createComponentNode(this.myself));
            Set nodes = (Set)this.engine.execute("$self/sibling::*[starts-with(name(.), 'JoramServer_')]");
            if (!nodes.isEmpty()) {
                ComponentNode cnode = (ComponentNode)nodes.iterator().next();
                server = cnode.getComponent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (server == null) {
            return null;
        }
        String domainName = "";
        Integer serverId = -1;
        String persistence = "";
        try {
            String serverHost = FractalUtil.getGenericAttributeController(server).getAttribute("host");
            if (serverHost.contains("_")) {
                serverHost = serverHost.split("_")[0];
            }
            domainName = FractalUtil.getGenericAttributeController(server).getAttribute("domain");
            int serverPort = 16020 + Integer.parseInt(FractalUtil.getGenericAttributeController((Component)server).getAttribute("sid"));
            serverAdminName = FractalUtil.getGenericAttributeController((Component)server).getAttribute("userAdmin");
            String serverAdminPass = FractalUtil.getGenericAttributeController((Component)server).getAttribute("passAdmin");
            persistence = FractalUtil.getGenericAttributeController((Component)server).getAttribute("persistence");
            TopicConnectionFactory con = TopicTcpConnectionFactory.create((String)serverHost, (int)serverPort);
            AdminModule.connect((TopicConnectionFactory)con, (String)serverAdminName, (String)serverAdminPass);
            List serversIDs = AdminModule.getServersIds();
            for (Integer Id : serversIDs) {
                if (serverId >= Id) continue;
                serverId = Id;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Integer e = serverId;
        serverId = serverId + 1;
        serverAdminName = serverId;
        String hostName = freeHostNames[0];
        hostName = hostName.substring(0, hostName.lastIndexOf(95));
        try {
            this.engine.invoke("addServer", new Object[]{hostName, domainName, serverId.toString(), persistence});
            this.engine.invoke("addConnectionFactory", (Object[])new String[]{serverId.toString(), "cf" + serverId.toString(), "true"});
            this.engine.invoke("addUser", (Object[])new String[]{serverId.toString(), "user", "user"});
            this.engine.invoke("addQueue", (Object[])new String[]{serverId.toString(), "queue" + serverId.toString(), "", "all", "all", "yes"});
            this.engine.invoke("addQueueToCluster", (Object[])new String[]{cQName, serverId.toString(), "queue" + serverId.toString()});
            this.engine.invoke("addConnectionFactoryToCluster", (Object[])new String[]{"ccf" + cQName, serverId.toString(), "cf" + serverId.toString()});
        }
        catch (NumberFormatException e1) {
            e1.printStackTrace();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (!this.monitoredServers.containsKey(serverId.toString())) {
            this.monitoredServers.put(serverId.toString(), new Stats(0, 0, DEFAULT_MAX_PROD_WEIGHT, DEFAULT_MAX_CONS_WEIGHT));
        }
        if (!this.monitoredCQs.containsServer(cQName, serverId.toString())) {
            this.monitoredCQs.addServer(cQName, serverId.toString());
        }
        try {
            if (this.probe != null) {
                this.probe.addServer(serverId.toString(), hostName, this.jMXPort, "queue" + serverId.toString(), this.monitoredCQs.getQueueStats(cQName, serverId.toString()));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return serverId.toString();
    }

    private class BalanceProdConsServer
    implements Comparable {
        private String serverName = null;
        private int balanceAfter = 0;
        private int prodConsFlag = 0;

        public BalanceProdConsServer(String serverName, int balanceAfter, int prodConsFlag) {
            this.serverName = serverName;
            this.balanceAfter = balanceAfter;
            this.prodConsFlag = prodConsFlag;
        }

        public int compareTo(Object obj) throws ClassCastException {
            if (!(obj instanceof BalanceProdConsServer)) {
                throw new ClassCastException();
            }
            BalanceProdConsServer comparedObject = (BalanceProdConsServer)obj;
            if (this.balanceAfter == 0) {
                return -1;
            }
            if (comparedObject.balanceAfter == 0) {
                return 1;
            }
            if (this.balanceAfter < 0) {
                if (comparedObject.balanceAfter < 0) {
                    return comparedObject.balanceAfter - this.balanceAfter;
                }
                return -this.prodConsFlag;
            }
            if (comparedObject.balanceAfter > 0) {
                return this.balanceAfter - comparedObject.balanceAfter;
            }
            return this.prodConsFlag;
        }

        public int getBalanceAfter() {
            return this.balanceAfter;
        }

        public void setBalanceAfter(int balanceAfter) {
            this.balanceAfter = balanceAfter;
        }

        public int getProdConsFlag() {
            return this.prodConsFlag;
        }

        public void setProdConsFlag(int prodConsFlag) {
            this.prodConsFlag = prodConsFlag;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }
    }

    private class WeightedServer
    implements Comparable {
        private String serverName;
        private int msgCount;
        private int balanceAfter;

        public WeightedServer(String serverName, int msgCount, int balanceAfter) {
            this.serverName = serverName;
            this.msgCount = msgCount;
            this.balanceAfter = balanceAfter;
        }

        public int compareTo(Object obj) throws ClassCastException {
            if (!(obj instanceof WeightedServer)) {
                throw new ClassCastException();
            }
            WeightedServer comparedObject = (WeightedServer)obj;
            if (this.getMsgCount() >= JoramOptimizationManagerImpl.this.messageCountThreshold) {
                if (comparedObject.getMsgCount() < JoramOptimizationManagerImpl.this.messageCountThreshold) {
                    return -1;
                }
                return comparedObject.getMsgCount() - this.getMsgCount();
            }
            if (comparedObject.getMsgCount() < JoramOptimizationManagerImpl.this.messageCountThreshold) {
                return 0;
            }
            return 1;
        }

        public String getServerName() {
            return this.serverName;
        }

        public String toString() {
            return "server name: " + this.serverName + ", msgCount: " + this.msgCount;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public int getMsgCount() {
            return this.msgCount;
        }

        public void setMsgCount(int msgCount) {
            this.msgCount = msgCount;
        }

        public int getBalanceAfter() {
            return this.balanceAfter;
        }
    }
}

