/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.control.joram.sensor;

import java.io.FileWriter;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.jasmine.jade.control.joram.util.Stats;

public class JMXProbe
extends Thread {
    private int pollingInterval = 2;
    private boolean shouldStop = false;
    private HashMap<String, ServerJMX> serversJMX = new HashMap();

    public JMXProbe() {
    }

    public JMXProbe(int interval) {
        this.setPollingInterval(interval);
    }

    public void setPollingInterval(int interval) {
        this.pollingInterval = interval;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public void stopJMXProbe() {
        this.shouldStop = true;
    }

    public void addServer(String serverName, String hostName, int port, String qName, Stats updateTarget) throws Exception {
        if (!this.serversJMX.containsKey(serverName)) {
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + hostName + ":" + port + "/jmxrmi");
            JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
            MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
            ObjectName name = new ObjectName("Joram:type=Destination,name=" + qName);
            this.serversJMX.put(serverName, new ServerJMX(serverName, mbsc, name, updateTarget, null));
        }
    }

    public void removeServer(String serverName) {
        try {
            this.serversJMX.get(serverName).updateTarget.setMaxProdWeight(0);
            this.serversJMX.remove(serverName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            long startTime = 0L;
            long currentTime = 0L;
            long deltaTime = 0L;
            int nbMsg = 0;
            System.out.println("[Starting JMX probe]");
            String attributeCounter = "MessageCounter";
            startTime = System.currentTimeMillis();
            while (!this.shouldStop) {
                ServerJMX[] servers = this.serversJMX.values().toArray(new ServerJMX[0]);
                currentTime = System.currentTimeMillis();
                deltaTime = currentTime - startTime;
                System.out.println("Probe update: " + deltaTime);
                for (int i = 0; i < servers.length; ++i) {
                    try {
                        nbMsg = (Integer)servers[i].mbsc.getAttribute(servers[i].name, attributeCounter);
                        servers[i].updateTarget.setMaxProdWeight(nbMsg);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            servers[i].updateTarget.setMaxProdWeight(0);
                            this.serversJMX.remove(servers[i].serverName);
                            continue;
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                Thread.sleep(this.pollingInterval * 1000);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                System.out.println("[Stopping JMX probe]");
                ServerJMX[] servers = this.serversJMX.values().toArray(new ServerJMX[0]);
                for (int i = 0; i < servers.length; ++i) {
                    servers[i].updateTarget.setMaxProdWeight(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class ServerJMX {
        private String serverName;
        private MBeanServerConnection mbsc;
        private ObjectName name;
        private Stats updateTarget;
        private FileWriter file;

        ServerJMX(String serverName, MBeanServerConnection mbsc, ObjectName name, Stats updateTarget, FileWriter file) {
            this.serverName = serverName;
            this.mbsc = mbsc;
            this.name = name;
            this.updateTarget = updateTarget;
            this.file = file;
        }
    }
}

