/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.control.joram.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.ow2.jasmine.jade.control.joram.util.Stats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoredClusterQueues {
    private HashMap<String, CQStats> monitoredClusterQueues = new HashMap();

    public void addClusterQueue(String cQName) {
        this.monitoredClusterQueues.put(cQName, new CQStats());
    }

    public void addServer(String cQName, String serverName) {
        this.monitoredClusterQueues.get(cQName).addServer(serverName);
    }

    public String[] listCQ() {
        return this.monitoredClusterQueues.keySet().toArray(new String[0]);
    }

    public boolean containsCQ(String cQName) {
        return this.monitoredClusterQueues.containsKey(cQName);
    }

    public boolean containsServer(String cQName, String serverName) {
        if (!this.containsCQ(cQName)) {
            return false;
        }
        return this.monitoredClusterQueues.get((Object)cQName).cqstats.containsKey(serverName);
    }

    public Stats getQueueStats(String cQName, String serverName) {
        return this.monitoredClusterQueues.get(cQName).getQueueStats(serverName);
    }

    public Iterator<String> listServers(String cQName) {
        return this.monitoredClusterQueues.get(cQName).listServers().iterator();
    }

    public String toString() {
        String result = "\tMonitored Cluster Queues";
        for (String clusterQueueName : this.monitoredClusterQueues.keySet()) {
            result = result + "\nCluster Queue " + clusterQueueName + "\n" + this.monitoredClusterQueues.get(clusterQueueName);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CQStats {
        HashMap<String, Stats> cqstats = new HashMap();

        CQStats() {
        }

        public void addServer(String serverName) {
            this.cqstats.put(serverName, new Stats(0, 0, 0, 0));
        }

        public Stats getQueueStats(String serverName) {
            return this.cqstats.get(serverName);
        }

        public Set<String> listServers() {
            return this.cqstats.keySet();
        }

        public String toString() {
            String result = "\tCQStats";
            for (String queueName : this.cqstats.keySet()) {
                result = result + "\nQueue " + queueName + "\n" + this.cqstats.get(queueName);
            }
            return result;
        }
    }
}

