package org.objectweb.fractal.rmi;


public interface ClassGenerator {

	/**
	 * Loads a class of a given name
	 * 
	 * @param className
	 *            name of the class to be loaded
	 * @return the Class object
	 */
	public Class loadClass(String className) throws ClassNotFoundException;

	/**
	 * Generates a skeleton or a stub Class for a class of a given name. If the
	 * name ends with _Stub a stub is generated, if the name ends with _Skel a
	 * skeleton is generated.
	 * 
	 * @param className
	 *            name of the class for which a stub or a skeleton is to be generated
	 * @param cl a class loader to be used to generate the stub/skeleton
	 * @return the Class object
	 */
	public Class generateClass(String className, ClassLoader cl);

	/**
	 * Generates a skeleton or a stub Class for a class of a given name. If the
	 * name ends with _Stub a stub is generated, if the name ends with _Skel a
	 * skeleton is generated.
	 * 
	 * @param className
	 *            name of the class for which a stub or a skeleton is to be generated
	 * @return the Class object
	 */
	public Class generateClass(String className);
}
