/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.fractal.api.control.ClassLoaderController;
import org.objectweb.fractal.rmi.ClassGenerator;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ClassGeneratorImpl
implements Opcodes,
ClassGenerator,
ClassLoaderController {
    private static boolean writeStubs = false;
    private static boolean writeSkels = false;
    protected Logger logger;
    private ClassLoaderController clc;
    protected ClassLoader cl = Thread.currentThread().getContextClassLoader();
    private EmbeddedLoader el = new EmbeddedLoader(this.cl);

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.cl.loadClass(className);
    }

    public Class generateClass(String className, ClassLoader cl) {
        this.setFcClassLoader(cl);
        return this.generateClass(className);
    }

    public Class generateClass(String className) {
        try {
            return this.el.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void generateStubClass(ClassVisitor cv, Class itf) {
        int access = 1;
        String name = ClassGeneratorImpl.getStubClassName(itf.getName()).replace('.', '/');
        String superClass = "org/objectweb/fractal/rmi/stub/Stub";
        String[] itfs = new String[]{Type.getInternalName((Class)itf)};
        cv.visit(196653, access, name, null, superClass, itfs);
        this.generateConstructor(cv, superClass);
        Method[] meths = itf.getMethods();
        ClassGeneratorImpl.sort(meths);
        for (int i = 0; i < meths.length; ++i) {
            Method meth = meths[i];
            this.generateStubMethod(cv, name, meth, i);
        }
    }

    protected void generateSkeletonClass(ClassVisitor cv, Class itf) {
        int access = 1;
        String name = ClassGeneratorImpl.getSkelClassName(itf.getName()).replace('.', '/');
        String superClass = "org/objectweb/fractal/rmi/stub/Skeleton";
        cv.visit(196653, access, name, null, superClass, null);
        this.generateConstructor(cv, superClass);
        this.generateSkeletonMethod(cv, name, itf);
        cv.visitEnd();
    }

    protected void generateConstructor(ClassVisitor cv, String superClass) {
        MethodVisitor mv = cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superClass, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    protected void generateStubMethod(ClassVisitor cv, String name, Method m, int index) {
        int i;
        String mName = m.getName();
        String mDesc = Type.getMethodDescriptor((Method)m);
        Class<?>[] params = m.getParameterTypes();
        int locals = 1;
        for (int i2 = 0; i2 < params.length; ++i2) {
            locals += ClassGeneratorImpl.getSize(params[i2]);
        }
        Class<?> result = m.getReturnType();
        Class<?>[] exceptions = m.getExceptionTypes();
        String[] excepts = new String[exceptions.length];
        for (int i3 = 0; i3 < exceptions.length; ++i3) {
            excepts[i3] = Type.getInternalName(exceptions[i3]);
        }
        MethodVisitor mv = cv.visitMethod(1, mName, mDesc, null, excepts);
        Label beginL = new Label();
        Label endL = new Label();
        mv.visitLabel(beginL);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, name, "request", "()Lorg/objectweb/jonathan/apis/presentation/Marshaller;");
        mv.visitVarInsn(58, locals);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, locals);
        mv.visitMethodInsn(182, name, "prepareInvocation", "(Lorg/objectweb/jonathan/apis/presentation/Marshaller;)Lorg/objectweb/jonathan/apis/protocols/ReplyInterface;");
        mv.visitVarInsn(58, locals + 1);
        mv.visitVarInsn(25, locals);
        mv.visitIntInsn(17, index);
        mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/presentation/Marshaller", "writeInt", "(I)V");
        int offset = 1;
        for (i = 0; i < params.length; ++i) {
            mv.visitVarInsn(25, locals);
            if (params[i].isPrimitive()) {
                mv.visitVarInsn(21 + ClassGeneratorImpl.getOpcodeOffset(params[i]), offset);
                mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/presentation/Marshaller", "write" + ClassGeneratorImpl.getMarshallerMethod(params[i]), "(" + Type.getDescriptor(params[i]) + ")V");
            } else {
                if (this.isClassParameter(m, i)) {
                    mv.visitVarInsn(25, 0);
                    mv.visitVarInsn(21 + ClassGeneratorImpl.getOpcodeOffset(params[i]), offset);
                    mv.visitMethodInsn(182, "org/objectweb/fractal/rmi/stub/Stub", "replaceClassName", "(Ljava/lang/Object;)Ljava/lang/Object;");
                } else {
                    mv.visitVarInsn(21 + ClassGeneratorImpl.getOpcodeOffset(params[i]), offset);
                }
                mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/presentation/Marshaller", "writeValue", "(Ljava/lang/Object;)V");
            }
            offset += ClassGeneratorImpl.getSize(params[i]);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, locals);
        mv.visitMethodInsn(182, name, "invoke", "(Lorg/objectweb/jonathan/apis/presentation/Marshaller;)V");
        mv.visitVarInsn(25, locals + 1);
        mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/protocols/ReplyInterface", "listen", "()Lorg/objectweb/jonathan/apis/presentation/UnMarshaller;");
        mv.visitVarInsn(58, locals + 2);
        if (result != Void.TYPE) {
            if (result.isPrimitive()) {
                mv.visitVarInsn(25, locals + 2);
                mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/presentation/UnMarshaller", "read" + ClassGeneratorImpl.getMarshallerMethod(result), "()" + Type.getDescriptor(result));
            } else {
                if (this.isClassParameter(m, -1)) {
                    mv.visitVarInsn(25, 0);
                    mv.visitVarInsn(25, locals + 2);
                    mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/presentation/UnMarshaller", "readValue", "()Ljava/lang/Object;");
                    mv.visitMethodInsn(182, "org/objectweb/fractal/rmi/stub/Stub", "replaceClassValue", "(Ljava/lang/Object;)Ljava/lang/Object;");
                } else {
                    mv.visitVarInsn(25, locals + 2);
                    mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/presentation/UnMarshaller", "readValue", "()Ljava/lang/Object;");
                }
                mv.visitTypeInsn(192, Type.getInternalName(result));
            }
            mv.visitVarInsn(54 + ClassGeneratorImpl.getOpcodeOffset(result), locals + 3);
        }
        mv.visitVarInsn(25, locals + 2);
        mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/presentation/UnMarshaller", "close", "()V");
        if (result != Void.TYPE) {
            mv.visitVarInsn(21 + ClassGeneratorImpl.getOpcodeOffset(result), locals + 3);
            mv.visitInsn(172 + ClassGeneratorImpl.getOpcodeOffset(result));
        } else {
            mv.visitInsn(177);
        }
        mv.visitLabel(endL);
        mv.visitVarInsn(58, locals);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, locals);
        mv.visitMethodInsn(182, name, "handleException", "(Ljava/lang/Exception;)Ljava/lang/Exception;");
        mv.visitVarInsn(58, locals);
        for (i = 0; i < exceptions.length; ++i) {
            String type = Type.getInternalName(exceptions[i]);
            mv.visitVarInsn(25, locals);
            mv.visitTypeInsn(193, type);
            Label next = new Label();
            mv.visitJumpInsn(153, next);
            mv.visitVarInsn(25, locals);
            mv.visitTypeInsn(192, type);
            mv.visitInsn(191);
            mv.visitLabel(next);
        }
        mv.visitVarInsn(25, locals);
        mv.visitTypeInsn(193, "java/lang/RuntimeException");
        Label next = new Label();
        mv.visitJumpInsn(153, next);
        mv.visitVarInsn(25, locals);
        mv.visitTypeInsn(192, "java/lang/RuntimeException");
        mv.visitInsn(191);
        mv.visitLabel(next);
        mv.visitTypeInsn(187, "org/objectweb/fractal/rmi/RemoteException");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)"server side exception");
        mv.visitVarInsn(25, locals);
        mv.visitMethodInsn(183, "org/objectweb/fractal/rmi/RemoteException", "<init>", "(Ljava/lang/String;Ljava/lang/Exception;)V");
        mv.visitInsn(191);
        mv.visitTryCatchBlock(beginL, endL, endL, "java/lang/Exception");
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void generateSkeletonMethod(ClassVisitor cv, String name, Class itf) {
        int i;
        MethodVisitor mv = cv.visitMethod(1, "send", "(Lorg/objectweb/jonathan/apis/presentation/UnMarshaller;Lorg/objectweb/jonathan/apis/protocols/ReplySession;)V", null, new String[]{"org/objectweb/jonathan/apis/kernel/JonathanException"});
        Label beginL = new Label();
        Label endL = new Label();
        Label defaultL = new Label();
        mv.visitLabel(beginL);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/presentation/UnMarshaller", "readInt", "()I");
        mv.visitVarInsn(54, 3);
        Method[] meths = itf.getMethods();
        ClassGeneratorImpl.sort(meths);
        Label[] cases = new Label[meths.length];
        for (i = 0; i < cases.length; ++i) {
            cases[i] = new Label();
        }
        if (meths.length > 0) {
            mv.visitVarInsn(21, 3);
            mv.visitTableSwitchInsn(0, meths.length - 1, defaultL, cases);
        }
        for (i = 0; i < meths.length; ++i) {
            Method m = meths[i];
            String mName = m.getName();
            String mDesc = Type.getMethodDescriptor((Method)m);
            Class<?>[] params = m.getParameterTypes();
            Class<?> result = m.getReturnType();
            mv.visitLabel(cases[i]);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, name, "target", "Ljava/lang/Object;");
            mv.visitTypeInsn(192, Type.getInternalName((Class)itf));
            for (int j = 0; j < params.length; ++j) {
                if (params[j].isPrimitive()) {
                    mv.visitVarInsn(25, 1);
                    mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/presentation/UnMarshaller", "read" + ClassGeneratorImpl.getMarshallerMethod(params[j]), "()" + Type.getDescriptor(params[j]));
                    continue;
                }
                if (this.isClassParameter(m, j)) {
                    mv.visitVarInsn(25, 0);
                    mv.visitVarInsn(25, 1);
                    mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/presentation/UnMarshaller", "readValue", "()Ljava/lang/Object;");
                    mv.visitMethodInsn(182, "org/objectweb/fractal/rmi/stub/Skeleton", "replaceClassValue", "(Ljava/lang/Object;)Ljava/lang/Object;");
                } else {
                    mv.visitVarInsn(25, 1);
                    mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/presentation/UnMarshaller", "readValue", "()Ljava/lang/Object;");
                }
                mv.visitTypeInsn(192, Type.getInternalName(params[j]));
            }
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/presentation/UnMarshaller", "close", "()V");
            mv.visitMethodInsn(185, Type.getInternalName((Class)itf), mName, mDesc);
            if (result != Void.TYPE) {
                mv.visitVarInsn(54 + ClassGeneratorImpl.getOpcodeOffset(result), 5);
            }
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/protocols/ReplySession", "prepareReply", "()Lorg/objectweb/jonathan/apis/presentation/Marshaller;");
            mv.visitVarInsn(58, 4);
            if (result != Void.TYPE) {
                mv.visitVarInsn(25, 4);
                if (result.isPrimitive()) {
                    mv.visitVarInsn(21 + ClassGeneratorImpl.getOpcodeOffset(result), 5);
                    mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/presentation/Marshaller", "write" + ClassGeneratorImpl.getMarshallerMethod(result), "(" + Type.getDescriptor(result) + ")V");
                } else {
                    if (this.isClassParameter(m, -1)) {
                        mv.visitVarInsn(25, 0);
                        mv.visitVarInsn(21 + ClassGeneratorImpl.getOpcodeOffset(result), 5);
                        mv.visitMethodInsn(182, "org/objectweb/fractal/rmi/stub/Skeleton", "replaceClassName", "(Ljava/lang/Object;)Ljava/lang/Object;");
                    } else {
                        mv.visitVarInsn(21 + ClassGeneratorImpl.getOpcodeOffset(result), 5);
                    }
                    mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/presentation/Marshaller", "writeValue", "(Ljava/lang/Object;)V");
                }
            }
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 4);
            mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/protocols/ReplySession", "send", "(Lorg/objectweb/jonathan/apis/presentation/Marshaller;)V");
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(185, "org/objectweb/jonathan/apis/protocols/ReplySession", "close", "()V");
            mv.visitInsn(177);
        }
        mv.visitLabel(defaultL);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(21, 3);
        mv.visitMethodInsn(182, name, "handleInterfaceMethods", "(Lorg/objectweb/jonathan/apis/presentation/UnMarshaller;Lorg/objectweb/jonathan/apis/protocols/ReplySession;I)V");
        mv.visitInsn(177);
        mv.visitLabel(endL);
        mv.visitVarInsn(58, 3);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, name, "handleException", "(Ljava/lang/Exception;Lorg/objectweb/jonathan/apis/protocols/ReplySession;)V");
        mv.visitInsn(177);
        mv.visitTryCatchBlock(beginL, endL, endL, "java/lang/Exception");
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected boolean isClassParameter(Method m, int p) {
        String name = m.getName();
        if (name.equals("getFcContentDesc")) {
            return p == -1;
        }
        if (name.equals("newFcInstance")) {
            return p == 2;
        }
        if (name.equals("getFcItfSignature")) {
            return p == -1;
        }
        if (name.equals("createFcItfType")) {
            return p == 1;
        }
        return false;
    }

    protected static void sort(Method[] methods) {
        int i;
        String[] descs = new String[methods.length];
        for (i = 0; i < descs.length; ++i) {
            descs[i] = methods[i].getName() + Type.getMethodDescriptor((Method)methods[i]);
        }
        for (i = 0; i < descs.length; ++i) {
            for (int j = i + 1; j < descs.length; ++j) {
                if (descs[j].compareTo(descs[i]) >= 0) continue;
                String s = descs[i];
                descs[i] = descs[j];
                descs[j] = s;
                Method m = methods[i];
                methods[i] = methods[j];
                methods[j] = m;
            }
        }
    }

    private static String getMarshallerMethod(Class type) {
        if (type == Byte.TYPE) {
            return "Byte";
        }
        if (type == Integer.TYPE) {
            return "Int";
        }
        if (type == Boolean.TYPE) {
            return "Boolean";
        }
        if (type == Double.TYPE) {
            return "Double";
        }
        if (type == Float.TYPE) {
            return "Float";
        }
        if (type == Long.TYPE) {
            return "Long";
        }
        if (type == Character.TYPE) {
            return "Char16";
        }
        return "Short";
    }

    private static int getOpcodeOffset(Class type) {
        if (type == Double.TYPE) {
            return 3;
        }
        if (type == Float.TYPE) {
            return 2;
        }
        if (type == Long.TYPE) {
            return 1;
        }
        if (type.isPrimitive()) {
            return 0;
        }
        return 4;
    }

    private static int getSize(Class type) {
        return type == Double.TYPE || type == Long.TYPE ? 2 : 1;
    }

    private static boolean isStubClassName(String className) {
        return className.endsWith("_JavaStub") || className.endsWith("_Stub");
    }

    private static String resolveStubClassName(String stubClassName) {
        if (stubClassName.endsWith("_JavaStub")) {
            return stubClassName.substring(5, stubClassName.length() - 9);
        }
        return stubClassName.substring(0, stubClassName.length() - 5);
    }

    private static boolean isSkelClassName(String className) {
        return className.endsWith("_JavaSkel") || className.endsWith("_Skel");
    }

    private static String resolveSkelClassName(String skelClassName) {
        if (skelClassName.endsWith("_JavaSkel")) {
            return skelClassName.substring(5, skelClassName.length() - 9);
        }
        return skelClassName.substring(0, skelClassName.length() - 5);
    }

    private static String getSkelClassName(String className) {
        if (className.startsWith("java.")) {
            return "skel." + className + "_JavaSkel";
        }
        return className + "_Skel";
    }

    private static String getStubClassName(String className) {
        if (className.startsWith("java.")) {
            return "stub." + className + "_JavaStub";
        }
        return className + "_Stub";
    }

    public ClassLoader getFcClassLoader() {
        return this.cl;
    }

    public void setFcClassLoader(ClassLoader cl) {
        this.cl = cl;
        this.el = new EmbeddedLoader(cl);
    }

    class EmbeddedLoader
    extends ClassLoader {
        public EmbeddedLoader(ClassLoader parent) {
            super(parent);
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            if (ClassGeneratorImpl.isStubClassName(name)) {
                Class<?> itf = this.loadClass(ClassGeneratorImpl.resolveStubClassName(name));
                ClassWriter cw = new ClassWriter(true);
                ClassGeneratorImpl.this.generateStubClass((ClassVisitor)cw, itf);
                byte[] b = cw.toByteArray();
                if (ClassGeneratorImpl.this.logger != null && ClassGeneratorImpl.this.logger.isLoggable(BasicLevel.INFO)) {
                    ClassGeneratorImpl.this.logger.log(BasicLevel.INFO, (Object)("Stub class generated: " + name));
                }
                if (writeStubs) {
                    try {
                        String dirName = "./" + name.substring(0, name.lastIndexOf(46)).replace('.', '/');
                        new File(dirName).mkdirs();
                        FileOutputStream os = new FileOutputStream("./" + name.replace('.', '/') + ".class");
                        ((OutputStream)os).write(b);
                        ((OutputStream)os).close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return this.defineClass(name, b, 0, b.length);
            }
            if (ClassGeneratorImpl.isSkelClassName(name)) {
                Class<?> itf = this.loadClass(ClassGeneratorImpl.resolveSkelClassName(name));
                ClassWriter cw = new ClassWriter(true);
                ClassGeneratorImpl.this.generateSkeletonClass((ClassVisitor)cw, itf);
                byte[] b = cw.toByteArray();
                if (ClassGeneratorImpl.this.logger != null && ClassGeneratorImpl.this.logger.isLoggable(BasicLevel.INFO)) {
                    ClassGeneratorImpl.this.logger.log(BasicLevel.INFO, (Object)("Skeleton class generated: " + name));
                }
                if (writeSkels) {
                    try {
                        String dirName = "./" + name.substring(0, name.lastIndexOf(46)).replace('.', '/');
                        new File(dirName).mkdirs();
                        FileOutputStream os = new FileOutputStream("./" + name.replace('.', '/') + ".class");
                        ((OutputStream)os).write(b);
                        ((OutputStream)os).close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return this.defineClass(name, b, 0, b.length);
            }
            throw new ClassNotFoundException(name);
        }
    }
}

