/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi;

import java.util.HashMap;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.rmi.stub.SkeletonFactory;
import org.objectweb.jonathan.apis.binding.Identifier;
import org.objectweb.jonathan.apis.binding.NamingContext;
import org.objectweb.jonathan.apis.kernel.Context;
import org.objectweb.jonathan.apis.kernel.JonathanException;
import org.objectweb.jonathan.apis.presentation.Marshaller;
import org.objectweb.jonathan.apis.presentation.UnMarshaller;
import org.objectweb.jonathan.apis.protocols.RequestSession;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public class RmiAdapter
implements NamingContext,
Runnable,
BindingController {
    protected SkeletonFactory skeletonFactory;
    protected LoggerFactory loggerFactory;
    protected Logger logger;
    private HashMap map = new HashMap();
    private int counter;
    private Thread waiter;

    public String[] listFc() {
        return new String[]{"skeleton-factory", "logger-factory"};
    }

    public Object lookupFc(String clientItfName) {
        if (clientItfName.equals("skeleton-factory")) {
            return this.skeletonFactory;
        }
        if (clientItfName.equals("logger-factory")) {
            return this.loggerFactory;
        }
        return null;
    }

    public void bindFc(String clientItfName, Object serverItf) {
        if (clientItfName.equals("skeleton-factory")) {
            this.skeletonFactory = (SkeletonFactory)serverItf;
        } else if (clientItfName.equals("logger-factory")) {
            this.loggerFactory = (LoggerFactory)serverItf;
            this.logger = this.loggerFactory.getLogger(this.getClass().getName());
        }
    }

    public void unbindFc(String clientItfName) {
        if (clientItfName.equals("skeleton-factory")) {
            this.skeletonFactory = null;
        } else if (clientItfName.equals("logger-factory")) {
            this.loggerFactory = null;
            this.logger = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identifier export(Object obj, Context hints) throws JonathanException {
        RmiAdapter rmiAdapter = this;
        synchronized (rmiAdapter) {
            Id id = (Id)this.map.get(obj);
            if (id == null) {
                if (this.waiter == null) {
                    this.waiter = new Thread(this);
                    this.waiter.start();
                }
                Integer key = null;
                if (hints != null) {
                    key = (Integer)hints.getValue("key", '\u0000');
                    if (key != null && key >= 0) {
                        throw new JonathanException("Cannot export objects with positive user specified keys");
                    }
                    if (key != null && this.map.get(key) != null) {
                        throw new JonathanException("Key " + key + " aleady used");
                    }
                }
                if (key == null) {
                    key = new Integer(this.counter++);
                }
                id = new Id(key);
                RequestSession skel = this.skeletonFactory.newSkeleton(obj);
                this.map.put(key, skel);
                this.map.put(obj, id);
                if (this.logger != null && this.logger.isLoggable(BasicLevel.INFO)) {
                    this.logger.log(BasicLevel.INFO, (Object)("Object " + obj + " exported with key " + key));
                }
            }
            return id;
        }
    }

    public Identifier decode(byte[] data, int offset, int length) throws JonathanException {
        int key = ((data[offset] & 0xFF) << 24) + ((data[offset + 1] & 0xFF) << 16) + ((data[offset + 2] & 0xFF) << 8) + (data[offset + 3] & 0xFF);
        return new Id(new Integer(key));
    }

    public Identifier decode(UnMarshaller u) throws JonathanException {
        return new Id(new Integer(u.readInt()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object o;
        Object object = o = new Object();
        synchronized (object) {
            try {
                o.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class Id
    implements Identifier {
        Integer key;

        public Id(Integer key) {
            this.key = key;
        }

        public NamingContext getContext() {
            return RmiAdapter.this;
        }

        public Object bind(Identifier[] ref, Context hints) {
            return RmiAdapter.this.map.get(this.key);
        }

        public void unexport() {
            RmiAdapter.this.map.remove(this.key);
        }

        public boolean isValid() {
            return RmiAdapter.this.map.containsKey(this.key);
        }

        public Object resolve() {
            Object o = RmiAdapter.this.map.get(this.key);
            if (RmiAdapter.this.logger != null && RmiAdapter.this.logger.isLoggable(BasicLevel.INFO)) {
                RmiAdapter.this.logger.log(BasicLevel.INFO, (Object)("Key " + this.key + " resolved to " + o));
            }
            return o;
        }

        public byte[] encode() {
            int key = this.key;
            return new byte[]{(byte)(key >>> 24 & 0xFF), (byte)(key >>> 16 & 0xFF), (byte)(key >>> 8 & 0xFF), (byte)(key & 0xFF)};
        }

        public void encode(Marshaller m) throws JonathanException {
            m.writeInt(this.key);
        }

        public boolean equals(Object o) {
            if (o instanceof Id) {
                return this.key.intValue() == ((Id)o).key.intValue();
            }
            return false;
        }

        public int hashCode() {
            return this.key;
        }

        public String toString() {
            return "Id[" + this.key + "]";
        }
    }
}

