/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi;

import java.util.Properties;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.jonathan.apis.binding.BindException;
import org.objectweb.jonathan.apis.binding.ExportException;
import org.objectweb.jonathan.apis.binding.Identifier;
import org.objectweb.jonathan.apis.binding.NamingContext;
import org.objectweb.jonathan.apis.kernel.Context;
import org.objectweb.jonathan.apis.kernel.JonathanException;
import org.objectweb.jonathan.apis.presentation.Marshaller;
import org.objectweb.jonathan.apis.presentation.MarshallerFactory;
import org.objectweb.jonathan.apis.presentation.UnMarshaller;
import org.objectweb.jonathan.apis.protocols.Protocol;
import org.objectweb.jonathan.apis.protocols.ProtocolGraph;
import org.objectweb.jonathan.apis.protocols.ReplyInterface;
import org.objectweb.jonathan.apis.protocols.ReplySession;
import org.objectweb.jonathan.apis.protocols.RequestSession;
import org.objectweb.jonathan.apis.protocols.ServerException;
import org.objectweb.jonathan.apis.protocols.SessionIdentifier;
import org.objectweb.jonathan.apis.protocols.Session_High;
import org.objectweb.jonathan.apis.protocols.Session_Low;
import org.objectweb.jonathan.apis.resources.Chunk;
import org.objectweb.jonathan.apis.resources.Scheduler;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public class RmiProtocol
implements Protocol,
BindingController {
    protected NamingContext adapter;
    protected MarshallerFactory marshallerFactory;
    protected Scheduler scheduler;
    protected LoggerFactory loggerFactory;
    protected Logger logger;
    private ClientSession_Low clientSessionLow = new ClientSession_Low();
    private ServerSession_Low serverSessionLow = new ServerSession_Low();
    private ReplyHolder[] table = new ReplyHolder[17];
    private ReplyHolder reusable;
    private int size;
    private int id;

    public String[] listFc() {
        return new String[]{"adapter", "marshaller-factory", "scheduler", "logger-factory"};
    }

    public Object lookupFc(String clientItfName) {
        if (clientItfName.equals("adapter")) {
            return this.adapter;
        }
        if (clientItfName.equals("marshaller-factory")) {
            return this.marshallerFactory;
        }
        if (clientItfName.equals("scheduler")) {
            return this.scheduler;
        }
        if (clientItfName.equals("logger-factory")) {
            return this.loggerFactory;
        }
        return null;
    }

    public void bindFc(String clientItfName, Object serverItf) {
        if (clientItfName.equals("adapter")) {
            this.adapter = (NamingContext)serverItf;
        } else if (clientItfName.equals("marshaller-factory")) {
            this.marshallerFactory = (MarshallerFactory)serverItf;
        } else if (clientItfName.equals("scheduler")) {
            this.scheduler = (Scheduler)serverItf;
        } else if (clientItfName.equals("logger-factory")) {
            this.loggerFactory = (LoggerFactory)serverItf;
            this.logger = this.loggerFactory.getLogger(this.getClass().getName());
        }
    }

    public void unbindFc(String clientItfName) {
        if (clientItfName.equals("adapter")) {
            this.adapter = null;
        } else if (clientItfName.equals("marshaller-factory")) {
            this.marshallerFactory = null;
        } else if (clientItfName.equals("scheduler")) {
            this.scheduler = null;
        } else if (clientItfName.equals("logger-factory")) {
            this.loggerFactory = null;
            this.logger = null;
        }
    }

    public boolean isAnInvocationProtocol() {
        return true;
    }

    public ProtocolGraph createProtocolGraph(ProtocolGraph[] subgraphs, Context hints) throws JonathanException {
        if (subgraphs.length != 1) {
            throw new JonathanException("Lower layers badly specified in RMIP");
        }
        return new Graph(subgraphs[0]);
    }

    public SessionIdentifier createSessionIdentifier(Properties info, SessionIdentifier[] next) throws JonathanException {
        if (next.length != 1) {
            throw new JonathanException("Lower layers badly specified in RMIP");
        }
        byte[] key = (byte[])info.get("object_key");
        return new CltSessionId(key, next[0]);
    }

    void sendMessage(Marshaller marshaller, Session_High lower) throws JonathanException {
        Chunk first;
        Chunk c = first = marshaller.getState();
        int size = 0;
        while (c != null) {
            size += c.top - c.offset;
            c = c.next;
        }
        if (lower.direct()) {
            lower.send(marshaller);
        } else {
            Marshaller m = this.marshallerFactory.newMarshaller();
            lower.prepare(m);
            m.write(marshaller.getState());
            marshaller.reset();
            lower.send(m);
        }
    }

    Marshaller prepareReplyMessage(int rqId, boolean isException) throws JonathanException {
        Marshaller marshaller = this.marshallerFactory.newMarshaller();
        marshaller.writeInt(rqId);
        marshaller.writeBoolean(isException);
        return marshaller;
    }

    synchronized void forwardException(JonathanException e, Session_High lower) {
        for (ReplyHolder holder : this.table) {
            while (holder != null) {
                if (holder.lower == lower) {
                    holder.sendReply(e);
                }
                holder = holder.next;
            }
        }
    }

    synchronized ReplyHolder getHolder(int id) {
        int index = (id & Integer.MAX_VALUE) % this.table.length;
        ReplyHolder holder = this.table[index];
        while (holder != null && holder.id != id) {
            holder = holder.next;
        }
        return holder;
    }

    synchronized ReplyHolder registerHolder(Session_High lower) {
        ReplyHolder holder;
        if (this.reusable == null) {
            holder = new ReplyHolder(lower);
            ++this.id;
            holder.id = this.id;
        } else {
            holder = this.reusable;
            holder.lower = lower;
            this.reusable = this.reusable.next;
        }
        int len = this.table.length;
        int index = (holder.id & Integer.MAX_VALUE) % len;
        holder.next = this.table[index];
        this.table[index] = holder;
        ++this.size;
        if (this.size > len / 2) {
            this.rehash(len);
        }
        return holder;
    }

    synchronized void removeHolder(int id) {
        ReplyHolder first;
        int index = (id & Integer.MAX_VALUE) % this.table.length;
        ReplyHolder holder = first = this.table[index];
        ReplyHolder prev = null;
        while (holder.id != id) {
            prev = holder;
            holder = holder.next;
        }
        if (holder != null) {
            --this.size;
            if (prev != null) {
                prev.next = holder.next;
            } else {
                this.table[index] = holder.next;
            }
            holder.next = this.reusable;
            holder.lower = null;
            this.reusable = holder;
        }
    }

    void rehash(int len) {
        int newLen = 2 * len + 1;
        ReplyHolder[] newTable = new ReplyHolder[newLen];
        for (int i = 0; i < len; ++i) {
            ReplyHolder holder = this.table[i];
            while (holder != null) {
                ReplyHolder next_holder = holder.next;
                int index = (holder.id & Integer.MAX_VALUE) % newLen;
                holder.next = newTable[index];
                newTable[index] = holder;
                holder = next_holder;
            }
        }
        this.table = newTable;
    }

    class ReplyHolder
    implements ReplyInterface {
        Object reply;
        int id;
        ReplyHolder next;
        Session_High lower;

        public ReplyHolder(Session_High lower) {
            this.lower = lower;
        }

        public synchronized UnMarshaller listen() throws JonathanException {
            try {
                while (this.reply == null) {
                    RmiProtocol.this.scheduler.wait(this);
                }
                UnMarshaller message = (UnMarshaller)this.reply;
                boolean isException = message.readBoolean();
                if (isException) {
                    throw new ServerException(message);
                }
                UnMarshaller unMarshaller = message;
                return unMarshaller;
            }
            catch (InterruptedException e) {
                throw new JonathanException(e);
            }
            catch (ClassCastException e) {
                throw (JonathanException)this.reply;
            }
            finally {
                this.reply = null;
                RmiProtocol.this.removeHolder(this.id);
            }
        }

        public synchronized boolean available() {
            return this.reply != null;
        }

        final synchronized void sendReply(Object reply) {
            this.reply = reply;
            RmiProtocol.this.scheduler.notify(this);
        }
    }

    class ServerSession_High
    extends RMIPSession_High
    implements ReplySession {
        int rqId;

        public ServerSession_High(Session_High lower, int rqId) {
            super(lower);
            this.rqId = rqId;
        }

        public Marshaller prepareReply() throws JonathanException {
            return RmiProtocol.this.prepareReplyMessage(this.rqId, false);
        }

        public Marshaller prepareExceptionReply() throws JonathanException {
            return RmiProtocol.this.prepareReplyMessage(this.rqId, true);
        }

        public Marshaller prepareSystemExceptionReply() throws JonathanException {
            return RmiProtocol.this.prepareReplyMessage(this.rqId, true);
        }

        public Marshaller prepareLocationForwardReply() throws JonathanException {
            return RmiProtocol.this.prepareReplyMessage(this.rqId, true);
        }
    }

    class ClientSession_High
    extends RMIPSession_High
    implements Session_High {
        byte[] key;

        public ClientSession_High(byte[] key, Session_High lower) {
            super(lower);
            this.key = key;
        }

        public ReplyInterface prepareInvocation(Marshaller marshaller) throws JonathanException {
            ReplyHolder reply = RmiProtocol.this.registerHolder(this.lower);
            marshaller.writeInt(reply.id);
            int len = this.key.length;
            marshaller.writeInt(len);
            marshaller.writeByteArray(this.key, 0, len);
            return reply;
        }

        public void prepare(Marshaller marshaller) throws JonathanException {
            marshaller.writeInt(0);
            int len = this.key.length;
            marshaller.writeInt(len);
            marshaller.writeByteArray(this.key, 0, len);
        }
    }

    class RMIPSession_High {
        Session_High lower;

        public RMIPSession_High(Session_High lower) {
            this.lower = lower;
        }

        public boolean direct() {
            return false;
        }

        public void send(Marshaller marshaller) throws JonathanException {
            RmiProtocol.this.sendMessage(marshaller, this.lower);
        }

        public void close() {
            this.lower.close();
        }
    }

    class ServerSession_Low
    implements Session_Low {
        ServerSession_Low() {
        }

        public void send(UnMarshaller unmarshaller, Session_High sender) throws JonathanException {
            boolean unmarshallerOpened = true;
            int rqId = unmarshaller.readInt();
            RequestSession requestSession = null;
            try {
                int len = unmarshaller.readInt();
                byte[] key = new byte[len];
                unmarshaller.readByteArray(key, 0, len);
                Identifier id = RmiProtocol.this.adapter.decode(key, 0, len);
                requestSession = (RequestSession)id.bind(null, null);
                if (requestSession != null) {
                    ServerSession_High replySession = new ServerSession_High(sender, rqId);
                    requestSession.send(unmarshaller, replySession);
                    return;
                }
                unmarshallerOpened = false;
                unmarshaller.close();
            }
            catch (Exception e) {
                if (RmiProtocol.this.logger != null && RmiProtocol.this.logger.isLoggable(BasicLevel.INFO)) {
                    RmiProtocol.this.logger.log(BasicLevel.DEBUG, (Object)"Exception caught in RMIP", (Throwable)e);
                }
                if (unmarshallerOpened) {
                    unmarshaller.close();
                }
                this.sendException(e, rqId, sender);
            }
        }

        public void send(JonathanException e, Session_High sender) {
            if (RmiProtocol.this.logger != null && RmiProtocol.this.logger.isLoggable(BasicLevel.INFO)) {
                RmiProtocol.this.logger.log(BasicLevel.DEBUG, (Object)("Exception caught in RMIP related to " + sender), (Throwable)e);
            }
            sender.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendException(Exception e, int rqId, Session_High session) {
            try {
                Marshaller marshaller = RmiProtocol.this.prepareReplyMessage(rqId, true);
                marshaller.writeValue(e);
                RmiProtocol.this.sendMessage(marshaller, session);
            }
            catch (Exception ignored) {
            }
            finally {
                session.close();
            }
        }
    }

    class ClientSession_Low
    implements Session_Low {
        ClientSession_Low() {
        }

        public void send(UnMarshaller unmarshaller, Session_High sender) throws JonathanException {
            try {
                int rqId = unmarshaller.readInt();
                ReplyHolder reply = RmiProtocol.this.getHolder(rqId);
                if (reply == null) {
                    unmarshaller.close();
                    if (RmiProtocol.this.logger != null && RmiProtocol.this.logger.isLoggable(BasicLevel.INFO)) {
                        RmiProtocol.this.logger.log(BasicLevel.DEBUG, (Object)("RMIP Request #" + rqId + " not found"));
                    }
                } else {
                    reply.sendReply(unmarshaller);
                }
            }
            catch (JonathanException e) {
                unmarshaller.close();
                this.send(e, sender);
            }
        }

        public void send(JonathanException e, Session_High sender) {
            RmiProtocol.this.forwardException(e, sender);
        }
    }

    class CltSessionId
    extends SrvSessionId {
        byte[] key;

        public CltSessionId(byte[] key, SessionIdentifier next) {
            super(next);
            this.key = key;
        }

        public Session_High bind(Session_Low ignored) throws JonathanException {
            if (this.next == null) {
                throw new BindException("Badly specified participants");
            }
            return new ClientSession_High(this.key, this.next.bind(RmiProtocol.this.clientSessionLow));
        }

        public void unexport() {
        }

        public Context getInfo() throws JonathanException {
            throw new JonathanException("Meaningless");
        }

        public boolean isLocal() {
            return this.next.isLocal();
        }
    }

    class SrvSessionId
    implements SessionIdentifier {
        SessionIdentifier next;

        public SrvSessionId(SessionIdentifier next) {
            this.next = next;
        }

        public Session_High bind(Session_Low ignored) throws JonathanException {
            throw new BindException("Bad session identifier type");
        }

        public void unexport() {
            this.next.unexport();
        }

        public Protocol getProtocol() {
            return RmiProtocol.this;
        }

        public SessionIdentifier[] next() {
            return new SessionIdentifier[]{this.next};
        }

        public int getProtocolId() {
            return 0;
        }

        public Context getInfo() throws JonathanException {
            throw new JonathanException("Not implemented");
        }

        public boolean isLocal() {
            return false;
        }
    }

    class Graph
    implements ProtocolGraph {
        ProtocolGraph next;

        public Graph(ProtocolGraph next) {
            this.next = next;
        }

        public SessionIdentifier export(Session_Low ignored) throws JonathanException {
            if (this.next == null) {
                throw new ExportException("Badly specified participants");
            }
            return new SrvSessionId(this.next.export(RmiProtocol.this.serverSessionLow));
        }
    }
}

