/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.rmi.server.RMIClassLoader;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ClassLoaderController;
import org.objectweb.fractal.rmi.ClassGenerator;
import org.objectweb.fractal.rmi.io.Ref;
import org.objectweb.jonathan.apis.binding.Identifier;
import org.objectweb.jonathan.apis.binding.NamingContext;
import org.objectweb.jonathan.apis.kernel.Context;
import org.objectweb.jonathan.apis.kernel.ContextFactory;

public class MyRmiObjectInputStream
extends ObjectInputStream {
    protected NamingContext domain;
    protected ContextFactory contextFactory;
    protected String codeBase;
    private ClassLoaderController clc = null;

    public MyRmiObjectInputStream(InputStream is, NamingContext domain, ContextFactory contextFactory, ClassGenerator loader) throws IOException {
        super(is);
        this.enableResolveObject(true);
        this.domain = domain;
        this.contextFactory = contextFactory;
        this.codeBase = this.readUTF();
        Component loaderComponent = ((Interface)loader).getFcItfOwner();
        try {
            this.clc = (ClassLoaderController)loaderComponent.getFcInterface("class-loader-controller");
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
        }
    }

    protected Object resolveObject(Object obj) throws IOException {
        if (obj instanceof Ref) {
            try {
                Ref ref = (Ref)obj;
                Identifier id = this.domain.decode(ref.id, 0, ref.id.length);
                Context hints = this.contextFactory.newContext();
                hints.addElement("interface_type", String.class, ref.type, '\u0000');
                Object newObj = id.bind(new Identifier[]{id}, hints);
                hints.release();
                return newObj;
            }
            catch (Exception e) {
                throw new IOException("cannot bind to object: " + e);
            }
        }
        return obj;
    }

    protected Class resolveClass(ObjectStreamClass desc) throws ClassNotFoundException, IOException {
        try {
            Class<?> result = null;
            try {
                result = RMIClassLoader.loadClass(this.codeBase, desc.getName(), this.clc.getFcClassLoader());
            }
            catch (Exception e) {
                try {
                    result = RMIClassLoader.loadClass(this.codeBase, desc.getName(), Thread.currentThread().getContextClassLoader());
                }
                catch (Exception ex) {
                    result = this.getClass().getClassLoader().loadClass(desc.getName());
                }
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            System.err.println("WARNING: " + e.toString());
            throw e;
        }
    }
}

