/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi.io;

import java.io.IOException;
import java.io.OutputStream;
import org.objectweb.fractal.rmi.io.RmiObjectOutputStream;
import org.objectweb.jonathan.apis.binding.NamingContext;
import org.objectweb.jonathan.apis.kernel.Context;
import org.objectweb.jonathan.apis.kernel.ContextFactory;
import org.objectweb.jonathan.apis.kernel.InternalException;
import org.objectweb.jonathan.apis.kernel.JonathanException;
import org.objectweb.jonathan.apis.presentation.Marshaller;
import org.objectweb.jonathan.apis.resources.Chunk;
import org.objectweb.jonathan.apis.resources.ChunkFactory;

public class RmiMarshaller
extends OutputStream
implements Marshaller {
    protected NamingContext domain;
    protected ChunkFactory chunkFactory;
    protected ContextFactory contextFactory;
    protected RmiObjectOutputStream os;
    private Chunk first;
    private Chunk current;
    private int offset;
    private int top;
    private Context context;

    public RmiMarshaller(NamingContext domain, ChunkFactory chunkFactory, ContextFactory contextFactory) {
        this.domain = domain;
        this.chunkFactory = chunkFactory;
        this.contextFactory = contextFactory;
        this.current = this.first = chunkFactory.newChunk();
        this.top = this.current.data.length;
    }

    public boolean isLittleEndian() {
        return false;
    }

    public Context getContext() {
        if (this.context == null) {
            try {
                this.context = this.contextFactory.newContext();
            }
            catch (NullPointerException e) {
                e.printStackTrace(System.err);
                throw new InternalException("Context factory required.");
            }
        }
        return this.context;
    }

    public Chunk getState() {
        if (this.current.next == null) {
            this.current.top = this.offset;
        }
        return this.first;
    }

    public int getOffset() {
        Chunk c = this.first;
        int size = 0;
        while (c != this.current) {
            size += c.top - c.offset;
            c = c.next;
        }
        return size + this.offset - this.current.offset;
    }

    public void setOffset(int off) {
        if (this.current.next == null && this.offset > this.current.top) {
            this.current.top = this.offset;
        }
        Chunk c = this.first;
        int sz = c.top - c.offset;
        while (off > sz) {
            off -= sz;
            c = c.next;
            sz = c.top - c.offset;
        }
        this.offset = c.offset + off;
        this.current = c;
        this.top = this.current.next == null ? this.current.data.length : this.current.top;
    }

    public boolean sameContents(Marshaller other) {
        Chunk yours;
        if (other == null) {
            return false;
        }
        Chunk mine = this.getState();
        if (mine == (yours = other.getState())) {
            return true;
        }
        byte[] my_data = null;
        byte[] your_data = null;
        int my_top = 0;
        int my_offset = 0;
        int your_top = 0;
        int your_offset = 0;
        if (mine != null) {
            my_data = mine.data;
            my_top = mine.top;
            my_offset = mine.offset;
        }
        if (yours != null) {
            your_data = yours.data;
            your_top = yours.top;
            your_offset = yours.offset;
        }
        while (mine != null && yours != null) {
            if (your_top - your_offset > my_top - my_offset) {
                while (my_offset < my_top && my_data[my_offset] == your_data[your_offset++]) {
                    ++my_offset;
                }
                if (my_offset < my_top) {
                    return false;
                }
                mine = mine.next;
                if (mine == null) continue;
                my_data = mine.data;
                my_top = mine.top;
                my_offset = mine.offset;
                continue;
            }
            while (your_offset < your_top && my_data[my_offset++] == your_data[your_offset]) {
                ++your_offset;
            }
            if (your_offset < your_top) {
                return false;
            }
            yours = yours.next;
            if (yours == null) continue;
            your_data = yours.data;
            your_top = yours.top;
            your_offset = yours.offset;
        }
        if (yours == null) {
            if (mine != null && mine.top == my_offset) {
                mine = mine.next;
            }
            while (mine != null && mine.top == mine.offset) {
                mine = mine.next;
            }
            return mine == null;
        }
        if (yours.top == your_offset) {
            yours = yours.next;
        }
        while (yours != null && yours.top == yours.offset) {
            yours = yours.next;
        }
        return yours == null;
    }

    public void reset() {
        this.first = null;
        this.current = null;
        this.offset = 0;
        this.top = 0;
        this.context = null;
    }

    public OutputStream outputStream() {
        return this;
    }

    public void writeByte(byte v) throws JonathanException {
        if (this.offset >= this.top) {
            this.prepare();
        }
        this.current.data[this.offset++] = v;
    }

    public void writeBoolean(boolean v) throws JonathanException {
        if (this.offset >= this.top) {
            this.prepare();
        }
        this.current.data[this.offset++] = (byte)(v ? 1 : 0);
    }

    public void writeChar8(char v) throws JonathanException {
        if (this.offset >= this.top) {
            this.prepare();
        }
        this.current.data[this.offset++] = (byte)v;
    }

    public void writeChar16(char v) throws JonathanException {
        if (this.top - this.offset < 2) {
            this.prepare();
        }
        byte[] data = this.current.data;
        data[this.offset++] = (byte)(v >>> 8);
        data[this.offset++] = (byte)v;
    }

    public void writeShort(short v) throws JonathanException {
        if (this.top - this.offset < 2) {
            this.prepare();
        }
        byte[] data = this.current.data;
        data[this.offset++] = (byte)(v >>> 8);
        data[this.offset++] = (byte)v;
    }

    public void writeInt(int v) throws JonathanException {
        if (this.top - this.offset < 4) {
            this.prepare();
        }
        byte[] data = this.current.data;
        data[this.offset++] = (byte)(v >>> 24);
        data[this.offset++] = (byte)(v >>> 16);
        data[this.offset++] = (byte)(v >>> 8);
        data[this.offset++] = (byte)v;
    }

    public void writeFloat(float v) throws JonathanException {
        int i = Float.floatToIntBits(v);
        if (this.top - this.offset < 4) {
            this.prepare();
        }
        byte[] data = this.current.data;
        data[this.offset++] = (byte)(i >>> 24);
        data[this.offset++] = (byte)(i >>> 16);
        data[this.offset++] = (byte)(i >>> 8);
        data[this.offset++] = (byte)i;
    }

    public void writeLong(long v) throws JonathanException {
        if (this.top - this.offset < 8) {
            this.prepare();
        }
        byte[] data = this.current.data;
        data[this.offset++] = (byte)(v >>> 56);
        data[this.offset++] = (byte)(v >>> 48);
        data[this.offset++] = (byte)(v >>> 40);
        data[this.offset++] = (byte)(v >>> 32);
        data[this.offset++] = (byte)(v >>> 24);
        data[this.offset++] = (byte)(v >>> 16);
        data[this.offset++] = (byte)(v >>> 8);
        data[this.offset++] = (byte)v;
    }

    public void writeDouble(double v) throws JonathanException {
        long l = Double.doubleToLongBits(v);
        if (this.top - this.offset < 8) {
            this.prepare();
        }
        byte[] data = this.current.data;
        data[this.offset++] = (byte)(l >>> 56);
        data[this.offset++] = (byte)(l >>> 48);
        data[this.offset++] = (byte)(l >>> 40);
        data[this.offset++] = (byte)(l >>> 32);
        data[this.offset++] = (byte)(l >>> 24);
        data[this.offset++] = (byte)(l >>> 16);
        data[this.offset++] = (byte)(l >>> 8);
        data[this.offset++] = (byte)l;
    }

    public void writeString8(String v) throws JonathanException {
        int len = v.length();
        this.writeInt(len + 1);
        byte[] data = this.current.data;
        int off = 0;
        int max = this.top - this.offset;
        while (max < len) {
            while (off < max) {
                data[this.offset++] = (byte)v.charAt(off++);
            }
            this.prepare();
            data = this.current.data;
            max = this.top - this.offset + off;
        }
        while (off < len) {
            data[this.offset++] = (byte)v.charAt(off++);
        }
        if (this.offset >= this.top) {
            this.prepare();
        }
        this.current.data[this.offset++] = 0;
    }

    public void writeString16(String v) throws JonathanException {
        throw new InternalException("Not implemented");
    }

    public void write(Chunk chunk) {
        if (this.current.next != null) {
            throw new InternalException("Illicit operation");
        }
        this.current.top = this.offset;
        this.current.next = chunk;
        Chunk c = chunk;
        while (c != null) {
            this.current = c;
            c = c.next;
        }
        this.offset = this.current.top;
        this.top = this.current.data.length;
    }

    public void writeByteArray(byte[] array, int off, int len) throws JonathanException {
        int max = this.top - this.offset;
        while (max < len) {
            if (max > 0) {
                System.arraycopy(array, off, this.current.data, this.offset, max);
                off += max;
                len -= max;
                this.offset = this.top;
            }
            this.prepare();
            max = this.top - this.offset;
        }
        System.arraycopy(array, off, this.current.data, this.offset, len);
        this.offset += len;
    }

    public void writeReference(Object v) throws JonathanException {
        try {
            this.initObjectStream();
            this.os.writeObject(v);
            this.os.drain();
        }
        catch (IOException e) {
            throw new JonathanException(e);
        }
    }

    public void writeValue(Object v) throws JonathanException {
        try {
            this.initObjectStream();
            this.os.writeObject(v);
            this.os.drain();
        }
        catch (IOException e) {
            throw new JonathanException(e);
        }
    }

    public void write(int b) throws IOException {
        try {
            if (this.top <= this.offset) {
                this.prepare();
            }
            this.current.data[this.offset++] = (byte)b;
        }
        catch (JonathanException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.writeByteArray(b, off, len);
        }
        catch (JonathanException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void close() {
        Chunk cur = this.first;
        while (cur != null) {
            Chunk next = cur.next;
            cur.release();
            cur = next;
        }
        this.first = null;
        this.current = null;
        this.offset = 0;
        this.top = 0;
        if (this.context != null) {
            this.context.release();
            this.context = null;
        }
    }

    protected void initObjectStream() throws IOException {
        if (this.os == null) {
            this.os = new RmiObjectOutputStream(this, this.domain);
        }
    }

    private void prepare() throws JonathanException {
        if (this.current == null) {
            Chunk chunk;
            this.first = chunk = this.chunkFactory.newChunk();
            this.current = chunk;
            this.offset = 0;
            this.top = this.current.data.length;
        } else if (this.current.next == null) {
            Chunk chunk;
            this.current.top = this.offset;
            this.current.next = chunk = this.chunkFactory.newChunk();
            this.current = chunk;
            this.offset = 0;
            this.top = this.current.data.length;
        } else {
            this.current = this.current.next;
            this.offset = this.current.offset;
            this.top = this.current.next != null ? this.current.top : this.current.data.length;
        }
    }
}

