/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.rmi.server.RMIClassLoader;
import org.objectweb.fractal.rmi.io.Ref;
import org.objectweb.jonathan.apis.binding.Identifier;
import org.objectweb.jonathan.apis.binding.NamingContext;
import org.objectweb.jonathan.apis.kernel.Context;
import org.objectweb.jonathan.apis.kernel.ContextFactory;

public class RmiObjectInputStream
extends ObjectInputStream {
    protected NamingContext domain;
    protected ContextFactory contextFactory;
    protected String codeBase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmiObjectInputStream(InputStream is, NamingContext domain, ContextFactory contextFactory) throws IOException {
        super(is);
        ClassLoader l;
        this.enableResolveObject(true);
        this.domain = domain;
        this.contextFactory = contextFactory;
        this.codeBase = this.readUTF();
        if (this.codeBase.length() == 0) {
            l = this.getClass().getClassLoader();
        } else {
            Thread t = Thread.currentThread();
            ClassLoader current = t.getContextClassLoader();
            try {
                t.setContextClassLoader(this.getClass().getClassLoader());
                l = RMIClassLoader.getClassLoader(this.codeBase);
            }
            finally {
                t.setContextClassLoader(current);
            }
        }
        if (l != null) {
            Thread.currentThread().setContextClassLoader(l);
        }
    }

    protected Object resolveObject(Object obj) throws IOException {
        if (obj instanceof Ref) {
            try {
                Ref ref = (Ref)obj;
                Identifier id = this.domain.decode(ref.id, 0, ref.id.length);
                Context hints = this.contextFactory.newContext();
                hints.addElement("interface_type", String.class, ref.type, '\u0000');
                Object newObj = id.bind(new Identifier[]{id}, hints);
                hints.release();
                return newObj;
            }
            catch (Exception e) {
                throw new IOException("cannot bind to object: " + e);
            }
        }
        return obj;
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            try {
                return RMIClassLoader.loadClass(this.codeBase, desc.getName());
            }
            catch (ClassNotFoundException e) {
                try {
                    return this.getClass().getClassLoader().loadClass(desc.getName());
                }
                catch (ClassNotFoundException e2) {
                    System.err.println("WARNING: " + e2.toString());
                    throw e2;
                }
            }
        }
        catch (IOException e) {
            System.err.println("WARNING: " + e.toString());
            throw e;
        }
    }
}

