/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi.stub;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.deployment.local.api.GenericInstallingFactory;
import org.objectweb.fractal.rmi.ClassGenerator;
import org.objectweb.fractal.rmi.stub.Skeleton;
import org.objectweb.fractal.rmi.stub.SkeletonFactory;
import org.objectweb.fractal.rmi.stub.Stub;
import org.objectweb.jonathan.apis.binding.ExportException;
import org.objectweb.jonathan.apis.binding.Identifier;
import org.objectweb.jonathan.apis.kernel.Context;
import org.objectweb.jonathan.apis.kernel.JonathanException;
import org.objectweb.jonathan.apis.presentation.MarshallerFactory;
import org.objectweb.jonathan.apis.protocols.RequestSession;
import org.objectweb.jonathan.apis.protocols.SessionIdentifier;
import org.objectweb.jonathan.apis.stub_factories.StubFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public class MyRmiStubFactory
implements StubFactory,
SkeletonFactory,
BindingController {
    private ClassGenerator classGenerator = null;
    private GenericInstallingFactory gif = null;
    protected MarshallerFactory marshallerFactory;
    protected LoggerFactory loggerFactory;
    protected Logger logger;

    public String[] listFc() {
        return new String[]{"marshaller-factory", "logger-factory", "class-generator", "component-factory"};
    }

    public Object lookupFc(String clientItfName) {
        if (clientItfName.equals("marshaller-factory")) {
            return this.marshallerFactory;
        }
        if (clientItfName.equals("logger-factory")) {
            return this.loggerFactory;
        }
        if (clientItfName.equals("class-generator")) {
            return this.classGenerator;
        }
        if (clientItfName.equals("component-factory")) {
            return this.gif;
        }
        return null;
    }

    public void bindFc(String clientItfName, Object serverItf) {
        if (clientItfName.equals("marshaller-factory")) {
            this.marshallerFactory = (MarshallerFactory)serverItf;
        } else if (clientItfName.equals("logger-factory")) {
            this.loggerFactory = (LoggerFactory)serverItf;
            this.logger = this.loggerFactory.getLogger(this.getClass().getName());
        } else if (clientItfName.equals("class-generator")) {
            this.classGenerator = (ClassGenerator)serverItf;
        } else if (clientItfName.equals("component-factory")) {
            this.gif = (GenericInstallingFactory)serverItf;
        }
    }

    public void unbindFc(String clientItfName) {
        if (clientItfName.equals("marshaller-factory")) {
            this.marshallerFactory = null;
        } else if (clientItfName.equals("logger-factory")) {
            this.loggerFactory = null;
            this.logger = null;
        } else if (clientItfName.equals("class-generator")) {
            this.classGenerator = null;
        } else if (clientItfName.equals("component-factory")) {
            this.gif = null;
        }
    }

    public Object newStub(SessionIdentifier sessionId, Identifier[] ids, Context hints) throws JonathanException {
        String implClassName = (String)hints.getValue("interface_type", '\u0000');
        Class implClass = null;
        Class stubClass = null;
        try {
            implClass = this.classGenerator.loadClass(implClassName);
            stubClass = this.classGenerator.generateClass(MyRmiStubFactory.getStubClassName(implClass.getName()));
        }
        catch (ClassNotFoundException e1) {
            implClassName = "org.objectweb.fractal.api.Component";
            try {
                implClass = this.classGenerator.loadClass(implClassName);
            }
            catch (ClassNotFoundException e) {
                e1 = e;
                e1.printStackTrace();
            }
            stubClass = this.classGenerator.generateClass(MyRmiStubFactory.getStubClassName(implClass.getName()));
        }
        try {
            if (ids.length != 1) {
                throw new JonathanException();
            }
            Stub stub = (Stub)stubClass.newInstance();
            stub.id = ids[0];
            stub.sessionId = sessionId;
            stub.marshallerFactory = this.marshallerFactory;
            if (this.logger != null && this.logger.isLoggable(BasicLevel.INFO)) {
                this.logger.log(BasicLevel.INFO, (Object)("Stub created for id " + ids[0]));
            }
            ClassLoader ld = stubClass.getClassLoader();
            int i = 0;
            while (ld != null) {
                ld = ld.getParent();
                ++i;
            }
            return stub;
        }
        catch (Exception e) {
            throw new JonathanException(e);
        }
    }

    public RequestSession newSkeleton(Object target) throws JonathanException {
        try {
            if (!(target instanceof Interface)) {
                throw new Exception("target object must implement Interface");
            }
            Class<?> implClass = target.getClass();
            Class<?>[] itfs = implClass.getInterfaces();
            if (itfs.length == 0) {
                throw new Exception("target object must implement an interface");
            }
            ClassLoader cl = null;
            Class skelClass = null;
            Component owner = ((Interface)target).getFcItfOwner();
            try {
                if (this.gif != null && (cl = this.gif.getFcLoaderForComponent(owner).getClassLoader()) != null) {
                    skelClass = this.classGenerator.generateClass(MyRmiStubFactory.getSkelClassName(itfs[0].getName()), cl);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (skelClass == null) {
                skelClass = this.classGenerator.generateClass(MyRmiStubFactory.getSkelClassName(itfs[0].getName()), this.getClass().getClassLoader());
            }
            Skeleton skel = (Skeleton)skelClass.newInstance();
            skel.target = target;
            if (this.logger != null && this.logger.isLoggable(BasicLevel.INFO)) {
                this.logger.log(BasicLevel.INFO, (Object)("Skeleton created for target " + target));
            }
            return skel;
        }
        catch (Exception e) {
            throw new ExportException(e);
        }
    }

    private static String getSkelClassName(String className) {
        if (className.startsWith("java.")) {
            return "skel." + className + "_JavaSkel";
        }
        return className + "_Skel";
    }

    private static String getStubClassName(String className) {
        if (className.startsWith("java.")) {
            return "stub." + className + "_JavaStub";
        }
        return className + "_Stub";
    }
}

