/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi.stub;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.Type;
import org.objectweb.jonathan.apis.kernel.JonathanException;
import org.objectweb.jonathan.apis.presentation.Marshaller;
import org.objectweb.jonathan.apis.presentation.UnMarshaller;
import org.objectweb.jonathan.apis.protocols.ReplySession;
import org.objectweb.jonathan.apis.protocols.RequestSession;

public abstract class Skeleton
implements RequestSession {
    protected Object target;

    public Object getTarget() {
        return this.target;
    }

    public abstract void send(UnMarshaller var1, ReplySession var2) throws JonathanException;

    protected void handleInterfaceMethods(UnMarshaller unmarshaller, ReplySession session, int methodIndex) throws JonathanException {
        Interface itf = (Interface)this.target;
        try {
            switch (methodIndex) {
                case -1: {
                    unmarshaller.close();
                    Component id = itf.getFcItfOwner();
                    Marshaller marshaller = session.prepareReply();
                    marshaller.writeValue(id);
                    session.send(marshaller);
                    session.close();
                    return;
                }
                case -2: {
                    unmarshaller.close();
                    String name = itf.getFcItfName();
                    Marshaller marshaller = session.prepareReply();
                    marshaller.writeValue(name);
                    session.send(marshaller);
                    session.close();
                    return;
                }
                case -3: {
                    unmarshaller.close();
                    Type type = itf.getFcItfType();
                    Marshaller marshaller = session.prepareReply();
                    marshaller.writeValue(type);
                    session.send(marshaller);
                    session.close();
                    return;
                }
                case -4: {
                    unmarshaller.close();
                    boolean internal = itf.isFcInternalItf();
                    Marshaller marshaller = session.prepareReply();
                    marshaller.writeBoolean(internal);
                    session.send(marshaller);
                    session.close();
                    return;
                }
            }
            throw new Exception("No such method");
        }
        catch (Exception e) {
            this.handleException(e, session);
            return;
        }
    }

    protected void handleException(Exception e, ReplySession session) throws JonathanException {
        try {
            Marshaller marshaller = session.prepareExceptionReply();
            marshaller.writeValue(e);
            session.send(marshaller);
        }
        catch (Exception f) {
            f.printStackTrace();
            throw new JonathanException("error during marshalling of exception by skeleton");
        }
        session.close();
    }

    protected Object replaceClassName(Object o) throws ClassNotFoundException {
        Object[] desc;
        if (o instanceof String) {
            return Class.forName((String)o);
        }
        if (o instanceof Object[] && (desc = (Object[])o).length == 2 && desc[1] instanceof String) {
            return new Object[]{desc[0], Class.forName((String)desc[1])};
        }
        return o;
    }

    protected Object replaceClassValue(Object o) {
        Object[] desc;
        if (o instanceof Class) {
            return ((Class)o).getName();
        }
        if (o instanceof Object[] && (desc = (Object[])o).length == 2 && desc[1] instanceof Class) {
            return new Object[]{desc[0], ((Class)desc[1]).getName()};
        }
        return o;
    }
}

