/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jonathan.apis.resources;

import org.objectweb.jonathan.apis.kernel.JonathanException;

public class Chunk {
    public byte[] data;
    public int top;
    public int offset;
    public Chunk next;

    public Chunk(byte[] data, int offset, int top) {
        this.data = data;
        this.offset = offset;
        this.top = top;
    }

    public Chunk duplicate() throws JonathanException {
        int len = this.top - this.offset;
        byte[] ndata = new byte[len];
        System.arraycopy(this.data, this.offset, ndata, 0, len);
        return new Chunk(ndata, 0, len);
    }

    public Chunk duplicate(int offset, int top) throws JonathanException {
        int len = top - offset;
        byte[] ndata = new byte[len];
        System.arraycopy(this.data, offset, ndata, 0, len);
        return new Chunk(ndata, 0, len);
    }

    public void release() {
        this.top = 0;
        this.offset = 0;
        this.next = null;
    }

    public String toString() {
        return "Chunk[data: " + this.data + " offset: " + this.offset + " top: " + this.top + "]";
    }
}

