/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jonathan.libs.resources;

import org.objectweb.jonathan.apis.resources.Chunk;
import org.objectweb.jonathan.apis.resources.ChunkFactory;
import org.objectweb.jonathan.libs.resources.LoggerProvider;
import org.objectweb.util.monolog.api.BasicLevel;

public class JChunkFactory
implements ChunkFactory {
    BigPoolChunk[] big_pool;
    int big_pool_size;
    int big_free;
    int big_size;
    SmallPoolChunk[] small_pool;
    int small_pool_size;
    int small_free;
    int small_size;
    public boolean verbose;

    public JChunkFactory() {
        this(5, 32768, 10, 8192, false);
    }

    public JChunkFactory(int big_pool_size, int big_size, int small_pool_size, int small_size, boolean verbose) {
        int i;
        this.big_pool_size = big_pool_size;
        this.big_size = big_size;
        this.small_pool_size = small_pool_size;
        this.small_size = small_size;
        this.verbose = verbose;
        this.big_free = big_pool_size;
        this.big_pool = new BigPoolChunk[this.big_free];
        for (i = 0; i < this.big_free; ++i) {
            this.big_pool[i] = new BigPoolChunk();
        }
        this.small_free = small_pool_size;
        this.small_pool = new SmallPoolChunk[this.small_free];
        for (i = 0; i < this.small_free; ++i) {
            this.small_pool[i] = new SmallPoolChunk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk newChunk() {
        SmallPoolChunk[] smallPoolChunkArray = this.small_pool;
        synchronized (this.small_pool) {
            SmallPoolChunk chunk = null;
            if (this.small_free > 0) {
                chunk = this.small_pool[--this.small_free];
                this.small_pool[this.small_free] = null;
            } else {
                if (LoggerProvider.logger != null && LoggerProvider.logger.isLoggable(BasicLevel.INFO)) {
                    LoggerProvider.logger.log(BasicLevel.INFO, (Object)"Allocating chunk outside small pool");
                }
                chunk = new SmallPoolChunk();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return chunk;
        }
    }

    public Chunk newChunk(int size) {
        if (size <= this.small_size) {
            return this.newSmallChunk();
        }
        if (size <= this.big_size) {
            return this.newBigChunk();
        }
        if (LoggerProvider.logger != null && LoggerProvider.logger.isLoggable(BasicLevel.INFO)) {
            LoggerProvider.logger.log(BasicLevel.INFO, (Object)("Chunk of size " + size + " requested."));
        }
        Chunk c = new Chunk(new byte[size], 0, 0);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Chunk newBigChunk() {
        BigPoolChunk[] bigPoolChunkArray = this.big_pool;
        synchronized (this.big_pool) {
            BigPoolChunk chunk = null;
            if (this.big_free > 0) {
                chunk = this.big_pool[--this.big_free];
                this.big_pool[this.big_free] = null;
            } else {
                if (LoggerProvider.logger != null && LoggerProvider.logger.isLoggable(BasicLevel.INFO)) {
                    LoggerProvider.logger.log(BasicLevel.INFO, (Object)"Allocating chunk outside big pool");
                }
                chunk = new BigPoolChunk();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return chunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Chunk newSmallChunk() {
        SmallPoolChunk[] smallPoolChunkArray = this.small_pool;
        synchronized (this.small_pool) {
            SmallPoolChunk chunk = null;
            if (this.small_free > 0) {
                chunk = this.small_pool[--this.small_free];
                this.small_pool[this.small_free] = null;
            } else {
                if (LoggerProvider.logger != null && LoggerProvider.logger.isLoggable(BasicLevel.INFO)) {
                    LoggerProvider.logger.log(BasicLevel.INFO, (Object)"Allocating chunk outside small pool");
                }
                chunk = new SmallPoolChunk();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return chunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToBigPool(BigPoolChunk resource) {
        BigPoolChunk[] bigPoolChunkArray = this.big_pool;
        synchronized (this.big_pool) {
            if (this.big_free < this.big_pool.length) {
                this.big_pool[this.big_free++] = resource;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToSmallPool(SmallPoolChunk resource) {
        SmallPoolChunk[] smallPoolChunkArray = this.small_pool;
        synchronized (this.small_pool) {
            if (this.small_free < this.small_pool.length) {
                this.small_pool[this.small_free++] = resource;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static final class Duplicate
    extends Chunk {
        PoolChunk target;

        Duplicate(PoolChunk chunk, int offset, int top) {
            super(chunk.data, offset, top);
            this.target = chunk;
            chunk.acquire();
        }

        public Chunk duplicate() {
            return new Duplicate(this.target, this.offset, this.top);
        }

        public Chunk duplicate(int offset, int top) {
            return new Duplicate(this.target, offset, top);
        }

        public void release() {
            this.next = null;
            this.target.release();
            this.target = null;
        }
    }

    final class BigPoolChunk
    extends PoolChunk {
        BigPoolChunk() {
            super(JChunkFactory.this.big_size);
        }

        public synchronized void release() {
            if (this.acquired == 1) {
                this.next = null;
                super.release();
                JChunkFactory.this.addToBigPool(this);
            } else {
                --this.acquired;
            }
        }
    }

    final class SmallPoolChunk
    extends PoolChunk {
        SmallPoolChunk() {
            super(JChunkFactory.this.small_size);
        }

        public synchronized void release() {
            if (this.acquired == 1) {
                this.next = null;
                super.release();
                JChunkFactory.this.addToSmallPool(this);
            } else {
                --this.acquired;
            }
        }
    }

    static class PoolChunk
    extends Chunk {
        protected int acquired = 1;

        PoolChunk(int size) {
            super(new byte[size], 0, 0);
        }

        public Chunk duplicate() {
            return new Duplicate(this, this.offset, this.top);
        }

        public Chunk duplicate(int offset, int top) {
            return new Duplicate(this, offset, top);
        }

        synchronized void acquire() {
            ++this.acquired;
        }
    }
}

