/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.fractal.adl.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.objectweb.deployment.scheduling.component.lib.AbstractFactoryProviderTask;
import org.objectweb.deployment.scheduling.core.api.Task;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.TaskMap;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.PrimitiveCompiler;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;
import org.objectweb.fractal.adl.types.TypeBuilder;
import org.objectweb.fractal.adl.types.TypeInterface;
import org.objectweb.fractal.api.control.BindingController;

public class TypeCompiler
implements BindingController,
PrimitiveCompiler {
    public static final String BUILDER_BINDING = "builder";
    public TypeBuilder builder;

    public String[] listFc() {
        return new String[]{BUILDER_BINDING};
    }

    public Object lookupFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            return this.builder;
        }
        return null;
    }

    public void bindFc(String itf, Object value) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = (TypeBuilder)value;
        }
    }

    public void unbindFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = null;
        }
    }

    public void compile(List path, ComponentContainer container, TaskMap tasks, Map context) throws ADLException {
        if (container instanceof InterfaceContainer) {
            try {
                tasks.getTask("type", (Object)container);
            }
            catch (NoSuchElementException e) {
                CreateTypeTask createTypeTask = new CreateTypeTask(this.builder, (InterfaceContainer)container);
                tasks.addTask("type", (Object)container, (Task)createTypeTask);
            }
        }
    }

    static class CreateTypeTask
    extends AbstractFactoryProviderTask {
        private TypeBuilder builder;
        private InterfaceContainer container;

        public CreateTypeTask(TypeBuilder builder, InterfaceContainer container) {
            this.builder = builder;
            this.container = container;
        }

        public void execute(Object context) throws Exception {
            if (this.getFactory() != null) {
                return;
            }
            ArrayList<Object> itfTypes = new ArrayList<Object>();
            Interface[] itfs = this.container.getInterfaces();
            int i = 0;
            while (i < itfs.length) {
                if (itfs[i] instanceof TypeInterface) {
                    TypeInterface itf = (TypeInterface)itfs[i];
                    Object itfType = this.builder.createInterfaceType(itf.getName(), itf.getSignature(), itf.getRole(), itf.getContingency(), itf.getCardinality(), context);
                    itfTypes.add(itfType);
                }
                ++i;
            }
            String name = null;
            if (this.container instanceof Definition) {
                name = ((Definition)this.container).getName();
            } else if (this.container instanceof Component) {
                name = ((Component)this.container).getName();
            }
            this.setFactory(this.builder.createComponentType(name, itfTypes.toArray(), context));
        }

        public String toString() {
            return "T" + System.identityHashCode((Object)this) + "[CreateTypeTask()]";
        }
    }
}

