/***
 * Jade-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105,
 * 78153 Le Chesnay Cedex - France
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */

package org.ow2.jasmine.jade.fractal.api.control;

import org.objectweb.fractal.api.control.AttributeController;

/**
 * A component interface to control the attributes of the component to which it
 * belongs. In opposition to
 * org.objectweb.fractal.api.control.AttributeController, the
 * {@link GenericAttributeController} provides generic getter/setter methods for
 * attributes. This way, you can dynamically add attributes to the component.
 *
 * @author <a href="mailto:noel.depalma@inrialpes.fr">Noel de palma</a>
 * @author <a href="mailto:julien.legrand@inrialpes.fr">Julien Legrand</a>
 */
public interface GenericAttributeController extends AttributeController {

    /**
     * retrieve an attribute identified by its name.
     *
     * @param name
     *            the name of the attribute to read.
     * @return the String value of the attribute identified by its name.
     * @throws NoSuchAttributeException
     *             if the given attribute is unknown.
     */
    String getAttribute(String name) throws NoSuchAttributeException;

    /**
     * set the value of an attribute identified by its name.
     *
     * @param name
     *            the name of the attribute to read.
     * @param value
     *            the value of the attribute.
     * @throws NoSuchAttributeException
     *             if the given attribute is unknown.
     */
    void setAttribute(String name, String value)
            throws NoSuchAttributeException;

    /**
     * Returns the names of the attribute of the component to which this
     * interface belongs.
     *
     * @return the names of the attributes of the component to which this
     *         interface belongs.
     */
    String[] listFcAtt();

}
