/***
 * Jade-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.fractal.api.control;

import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;

/**
 * A component interface to control the bindings of the component bound to the
 * component to which this interface belongs (oO). It is implicitely assumed
 * here that the component's type system makes a distinction between "client"
 * and "server" interfaces.
 * 
 * @author <a href="mailto:fabienne.boyer@inrialpes.fr">Fabienne Boyer</a>
 * @author <a href="mailto:noel.depalma@inrialpes.fr">Noel de palma</a>
 * 
 */
public interface ReverseBindingController {

	/**
	 * Register a reverse binding.
	 * 
	 * @param serverItfName
	 *            the name of a server interface of the component to which this
	 *            interface belongs.
	 * @param clientItf
	 *            the client interface which is bound to the server interface.
	 * @throws NoSuchInterfaceException
	 *             if there is no such client interface.
	 * @throws IllegalBindingException
	 *             if the binding cannot be registered.
	 * @throws IllegalLifeCycleException
	 *             if this component has a {@link LifeCycleController}
	 *             interface, but it is not in an appropriate state to perform
	 *             this operation.
	 */
	void bindSource(String serverItfName, Object clientItf)
			throws NoSuchInterfaceException, IllegalBindingException,
			IllegalLifeCycleException;

	/**
	 * Unregister a reverse binding.
	 * 
	 * @param serverItfName
	 *            the name of a server interface of the component to which this
	 *            interface belongs.
	 * @param clientItf
	 *            the client interface which is bound to the server interface.
	 *            client itf must implem hashcode & equals method
	 * @throws NoSuchInterfaceException
	 *             if there is no such client interface.
	 * @throws IllegalBindingException
	 *             if the binding cannot be registered.
	 * @throws IllegalLifeCycleException
	 *             if this component has a {@link LifeCycleController}
	 *             interface, but it is not in an appropriate state to perform
	 *             this operation.
	 */
	void unbindSource(String serverItfName, Object clientItf)
			throws NoSuchInterfaceException, IllegalBindingException,
			IllegalLifeCycleException;

	/**
	 * Lookup the reverse bindings of the component to which this controller
	 * interface belongs.
	 * 
	 * @param serverItfName
	 *            the name of a server interface of the component to which this
	 *            controller interface belongs.
	 * @return an array of interfaces bound to the server interface
	 * @throws NoSuchInterfaceException
	 *             if there is no such interface.
	 */
	Object[] lookupBindingSource(String serverItfName)
			throws NoSuchInterfaceException;

	/**
	 * Return an array of reverse bindings name of the component to which this
	 * controller interface belongs.
	 * 
	 * @return an array of String containing bindings name, null if no component
	 *         is bound to the component this interface belongs.
	 */
	String[] listSource();
}
