/***
 * Jade-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */

package org.ow2.jasmine.jade.fractal.fraclet.annotation.generator.template;

import java.util.List;

import org.objectweb.fractal.fraclet.annotation.FractalComponent;

import spoon.reflect.Factory;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtField;
import spoon.reflect.reference.CtTypeReference;
import spoon.template.Local;
import spoon.template.Parameter;
import spoon.template.Substitution;
import spoon.template.Template;
import spoon.template.TemplateParameterList;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.fraclet.annotation.GenericAttribute;

/**
 * @author <a href="mailto:julien.legrand@inrialpes.fr">Julien Legrand
 * 
 */
public class GenericAttributeTemplate implements Template {

    @Parameter
    TemplateParameterList<?> _listFcAtt_;

    @Parameter
    TemplateParameterList<?> _getAttribute_;

    @Parameter
    TemplateParameterList<?> _setAttribute_;

    @Local
    Factory spoonFactory;

    @Local
    CtStatementList<?> listFcAtt;

    @Local
    CtStatementList<?> getAttribute;

    @Local
    CtStatementList<?> setAttribute;

    /**
     * 
     */
    @Local
    public GenericAttributeTemplate(Factory spoonFactory, CtClass<?> target) {

        /*
         * 3 sub templates are used, one for each method to insert
         */
        this.spoonFactory = spoonFactory;
        listFcAtt = spoonFactory.Core().createStatementList();
        getAttribute = spoonFactory.Core().createStatementList();
        setAttribute = spoonFactory.Core().createStatementList();

        // if (target.getSuperclass()!=null){
        CtClass<?> parentTarget = target;
        while (parentTarget.getSuperclass() != null) {
            parentTarget = (CtClass<?>) target.getSuperclass().getDeclaration();
            if (parentTarget != null
                    && parentTarget.getAnnotation(FractalComponent.class) != null) {

                parseFields(target, parentTarget, spoonFactory);

            } else {
                break;
            }
        }
        parseFields(target, target, spoonFactory);

        /*
         * set the references to the list statements
         */
        _listFcAtt_ = listFcAtt;
        _getAttribute_ = getAttribute;
        _setAttribute_ = setAttribute;

    }

    @Local
    private void parseFields(CtClass<?> target, CtClass<?> parentTarget,
            Factory spoonFactory) {

        List<CtField<?>> fields=parentTarget.getFields();
        
        /*
         * iterate over target fields
         */
        for (CtField<?> field : fields) {
            
            /*
             * get the GenericAttribute annotation
             */
            GenericAttribute attributeAnnotation = field.getAnnotation(GenericAttribute.class);
            // if the field is not annotated continue
            if (attributeAnnotation == null)
                continue;
            
            if (!target.getSuperInterfaces().contains(spoonFactory.Type().createReference(GenericAttributeController.class))){
                target.getSuperInterfaces().add(spoonFactory.Type().createReference(GenericAttributeController.class));  
            }

            CtBlock<?> block = null;
            Template t = null;
            
            String attributeName = field.getSimpleName();
            String attributeValue = attributeAnnotation.value();
                
            /*
             * the ListFcAttTemplate
             */
            t = new ListFcAttributeTemplate(attributeName);
            block = Substitution.substituteMethodBody(target, t,
                    "addAttribute", spoonFactory.Type().createReference(List.class));
            listFcAtt.getStatements().add(block.getStatements().get(0));

            /*
             * the GetAttributeTemplate
             */
            t = new GetAttributeTemplate(attributeName);
            block = Substitution.substituteMethodBody(target, t, "getAttribute",
                    spoonFactory.Type().createReference(String.class));
            getAttribute.getStatements().add(block.getStatements().get(0));

            /*
             * the SetAttributeTemplate
             */
            t= new SetAttributeTemplate(attributeName, attributeValue);
            block = Substitution.substituteMethodBody(target, t, "setAttribute",new CtTypeReference<?>[]{
                    spoonFactory.Type().createReference(String.class),spoonFactory.Type().createReference(Object.class)});
            setAttribute.getStatements().add(block.getStatements().get(0));
                
            
        }
        
    }

}
