/*==============================================================================
 Fraclet annotation - Copyright (C) 2002-2006 INRIA Futurs / LIFL
 Fractal Component Model (contact: fractal@objectweb.org)

 This library is free software; you can redistribute it and/or modify it under 
 the terms of the GNU Lesser General Public License as published by the Free 
 Software Foundation; either version 2.1 of the License, or any later version.

 This library is distributed in the hope that it will be useful, but WITHOUT ANY 
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public License along 
 with this library; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 Initial developer(s): Nicolas Pessemier (nicolas.pessemier@lifl.fr)
 ==============================================================================*/

package org.ow2.jasmine.jade.fractal.fraclet.annotation.processor;

import java.util.List;

import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.LifeCycleType;
import org.objectweb.fractal.fraclet.annotation.Service;
import org.objectweb.fractal.fraclet.annotation.generator.ComponentADLGenerator;
import org.objectweb.fractal.fraclet.annotation.generator.template.LifeCycleTemplate;
import org.objectweb.fractal.fraclet.annotation.generator.template.LifeCycleTemplateStart;
import org.objectweb.fractal.fraclet.annotation.generator.template.LifeCycleTemplateStop;
import org.objectweb.fractal.fraclet.annotation.generator.template.RequiresTemplate;
import org.objectweb.fractal.fraclet.annotation.generator.template.util.NonTypedFractalAttributeException;

import org.ow2.jasmine.jade.fractal.fraclet.annotation.generator.template.GenericAttributeTemplate;

import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.template.Substitution;

/**
 * An annotation processor to manage the FractalComponent annotation (generation
 * of ".fractal" file).
 * 
 * @author Nicolas Pessemier <Nicolas.Pessemier@lifl.fr>
 * <p>
 * contributor : <a href="mailto:julien.legrand@inrialpes.fr">Julien Legrand</a>
 * 
 */
public class ComponentProcessor extends AbstractProcessor<CtClass<?>> {

    /**
     * A constructor for the ComponentProcessor
     * 
     * @param processedClass
     *            the CtClass processed
     */
    public void process(CtClass<?> processedClass) {

        FractalComponent fcAnnotation = processedClass
                .getAnnotation(FractalComponent.class);

        if (fcAnnotation != null) {
            
            new ComponentADLGenerator(processedClass, fcAnnotation);
            
            try {
                Substitution.insertAll(processedClass, new RequiresTemplate(
                        getFactory(), processedClass));
                List<CtElement> elts = processedClass
                        .getAnnotatedChildren(Service.class);
                if (elts.size() > 0)
                    elts.get(0).getAnnotations().remove(
                            elts.get(0).getAnnotation(
                                    getFactory().Type().createReference(
                                            Service.class)));

                /*
                 * Manage @Requires annotation
                 */
                new RequiresTemplate(getFactory(), processedClass);

                /*
                 * Manage @GenericAttribute annotation
                 */
                new GenericAttributeTemplate(getFactory(), processedClass);

            } catch (NonTypedFractalAttributeException e) {
                e.printStackTrace();
            }
        }

        /*
         * Manage @LifeCycle annotation
         */
        List<CtElement> elts = processedClass
                .getAnnotatedChildren(LifeCycle.class);

        boolean start = false, stop = false;

        CtMethod<?> startM = null, stopM = null;

        for (CtElement elt : elts) {
            LifeCycle annot = elt.getAnnotation(LifeCycle.class);

            if (annot.on().equals(LifeCycleType.START)) {
                start = true;
                startM = (CtMethod) elt;
                if (startM.getParameters().size() > 0)
                    System.err
                            .println("WARNING: a method annotated with @LifeCycle shouldn't "
                                    + "have parameters! Please revise your method signature.");
            }

            if (annot.on().equals(LifeCycleType.STOP)) {
                stop = true;
                stopM = (CtMethod) elt;
                if (stopM.getParameters().size() > 0)
                    System.err
                            .println("WARNING: a method annotated with @LifeCycle shouldn't "
                                    + "have parameters! Please revise your method signature.");

            }
        }

        if (start && !stop)
            Substitution.insertAll(processedClass, new LifeCycleTemplateStart(
                    startM));

        if (stop && !start)
            Substitution.insertAll(processedClass, new LifeCycleTemplateStop(
                    stopM));
        if (start && stop)
            Substitution.insertAll(processedClass, new LifeCycleTemplate(
                    startM, stopM));
        if (start || stop)
            if (!processedClass.getSuperInterfaces().contains(
                    getFactory().Type().createReference(
                            LifeCycleController.class))) {
                processedClass.getSuperInterfaces().add(
                        getFactory().Type().createReference(
                                LifeCycleController.class));
            }

    }
}
