/***
 * Julia: France Telecom's implementation of the Fractal API
 * Copyright (C) 2001-2002 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: Eric.Bruneton@rd.francetelecom.com
 *
 * Author: Eric Bruneton
 */

package org.ow2.jasmine.jade.fractal.julia;

import java.util.HashMap;
import java.util.Map;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.factory.Factory;
import org.objectweb.fractal.api.factory.GenericFactory;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.factory.ChainedInstantiationException;
import org.objectweb.fractal.julia.loader.Loader;
import org.objectweb.fractal.julia.type.BasicTypeFactoryMixin;
import org.ow2.jasmine.jade.fractal.julia.factory.JadeGenericFactoryMixin;

/**
 * These class is based on {@link org.objectweb.fractal.julia.Julia}
 * <p>
 * Provides access to the Julia bootstrap component modified for Jade requirements.
 * <p>
 * contributor : <a href="mailto:julien.legrand@inrialpes.fr">Julien Legrand</a>
 * 
 */
public class JuliaJade implements Factory, GenericFactory {

    /**
     * The bootstrap component.
     */
    private static Component bootstrapComponent;
    
    /**
     * The bootstrap description name defined in Julia configuration file 
     */
    private static final String bootstrapName = "bootstrap-with-name";

    // ------------------------------------------------------------------------
    // Constructor
    // ------------------------------------------------------------------------

    /**
     * 
     */
    public JuliaJade() {
        super();
    }

    // ------------------------------------------------------------------------
    // Implementation of Factory interface
    // ------------------------------------------------------------------------

    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.fractal.api.factory.Factory#getFcInstanceType()
     */
    public Type getFcInstanceType() {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.fractal.api.factory.Factory#getFcControllerDesc()
     */
    public Object getFcControllerDesc() {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.fractal.api.factory.Factory#getFcContentDesc()
     */
    public Object getFcContentDesc() {
        return null;
    }

    // ------------------------------------------------------------------------
    // Implementation of GenericFactory interface
    // ------------------------------------------------------------------------

    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.fractal.api.factory.Factory#newFcInstance()
     */
    public Component newFcInstance() throws InstantiationException {
        return newFcInstance(new HashMap());
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.objectweb.fractal.api.factory.GenericFactory#newFcInstance(org.objectweb.fractal.api.Type,
     *      java.lang.Object, java.lang.Object)
     */
    public Component newFcInstance(Type type, Object controllerDesc,
            Object contentDesc) throws InstantiationException {
        Map context;
        if (contentDesc instanceof Map) {
            context = (Map) contentDesc;
        } else {
            context = new HashMap();
        }
        return newFcInstance(context);
    }

    // ------------------------------------------------------------------------
    // Private Methods
    // ------------------------------------------------------------------------

    /**
     * @param context
     * @return
     * @throws InstantiationException
     */
    private Component newFcInstance(final Map context)
            throws InstantiationException {
        if (bootstrapComponent == null) {
            String boot = (String) context.get("julia.loader");
            if (boot == null) {
                boot = System.getProperty("julia.loader");
            }
            if (boot == null) {
                throw new InstantiationException(
                        "The julia.loader [system] property is not defined");
            }

            // creates the pre bootstrap controller components
            Loader loader;
            try {
                loader = (Loader) this.getClass().getClassLoader().loadClass(boot).newInstance();
                loader.init(context);
            } catch (Exception e) {
            	e.printStackTrace();
                throw new InstantiationException(
                        "Cannot find or instantiate the '"
                                + boot
                                + "' class specified in the julia.loader [system] property");
            }
            BasicTypeFactoryMixin typeFactory = new BasicTypeFactoryMixin();
            // BasicGenericFactoryMixin genericFactory = new BasicGenericFactoryMixin();
            JadeGenericFactoryMixin genericFactory = new JadeGenericFactoryMixin();
            genericFactory._this_weaveableL = loader;
            genericFactory._this_weaveableTF = typeFactory;

            // use the pre bootstrap component to create the real bootstrap
            // component
            ComponentType t = typeFactory.createFcType(new InterfaceType[0]);
            try {
                bootstrapComponent = genericFactory.newFcInstance(t,
                        bootstrapName, null);
                try {
                    ((Loader) bootstrapComponent.getFcInterface("loader"))
                            .init(context);
                } catch (NoSuchInterfaceException ignored) {
                }
            } catch (Exception e) {
                throw new ChainedInstantiationException(e, null,
                        "Cannot create the bootstrap component");
            }
        }
        return bootstrapComponent;
    }

}
