/***
 * Jade-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.fractal.julia.control.deployment;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.deployment.local.api.GenericInstallingFactory;
import org.objectweb.fractal.deployment.local.api.UndeploymentController;
import org.objectweb.fractal.deployment.local.api.UndeploymentException;

import org.ow2.jasmine.jade.fractal.api.control.GenericInstallingFactoryController;

/**
 * Provides an implementation of the
 * {@link org.objectweb.fractal.deployment.local.api.UndeploymentController}
 * interface.
 * 
 * @author <a href="mailto:jakub.kornas@inrialpes.fr">Jakub Kornas</a>
 * @author <a href="mailto:julien.legrand@inrialpes.fr">Julien Legrand</a>
 * 
 */
public class BasicUndeploymentControllerMixin implements UndeploymentController {
	
	// -------------------------------------------------------------------------
	// Private constructor
	// -------------------------------------------------------------------------

	private BasicUndeploymentControllerMixin() {
	}

	// ------------------------------------------------------------------------
	// Implementation of ComponentDeployer interface
	// ------------------------------------------------------------------------

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.objectweb.fractal.deployment.local.api.UndeploymentController#undeploy()
	 */
	public void undeploy() throws UndeploymentException {

		Component thisComponent;

		try {
			thisComponent = (Component) _this_weaveableC
					.getFcInterface("component");
		} catch (NoSuchInterfaceException e) {
			throw new UndeploymentException(e);
		}

		GenericInstallingFactoryController gfc;
		try {
			/*
			 * TODO: the reference to a factory should be a weaveable, immutable
			 * field injected at component creation ...
			 */
			gfc = (GenericInstallingFactoryController) _this_weaveableC
					.getFcInterface("generic-installing-factory-controller");
		} catch (NoSuchInterfaceException e) {
			throw new UndeploymentException(e);
		}

		GenericInstallingFactory gf = gfc.getGenericFactory();
		if (gf != null) {
			gf.undeployFcComponent(thisComponent);
		}
	}

	// ------------------------------------------------------------------------
	// Fields and methods required by the mixin class in the base class
	// -------------------------------------------------------------------------

	/**
	 * The <tt>weaveableC</tt> field required by this mixin. This field is
	 * supposed to reference the {@link Component} interface of the component to
	 * which this controller object belongs.
	 */

	public Component _this_weaveableC;

}
