/***
 * Jade-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.fractal.julia.control.deployment;

import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.deployment.local.api.UndeploymentController;
import org.objectweb.fractal.deployment.local.api.UndeploymentException;

/**
 * Provides basic checks to a {@link UndeploymentController}. <br>
 * <br>
 * <b>Requirements</b>
 * <ul>
 * <li>none.</li>
 * </ul>
 * 
 * @author <a href="mailto:julien.legrand@inrialpes.fr">Julien Legrand</a>
 */
public abstract class CheckBindingMixin implements UndeploymentController {

	// -------------------------------------------------------------------------
	// Private constructor
	// -------------------------------------------------------------------------

	private CheckBindingMixin() {
	}

	// -------------------------------------------------------------------------
	// Fields and methods added and overriden by the mixin class
	// -------------------------------------------------------------------------

	/**
	 * Checks that the component this controller belongs to is not bound, and
	 * then calls the overriden method.
	 */
	public void undeploy() throws UndeploymentException {

		String[] itfs = _this_weaveableBC.listFc();

		for (int i = 0; i < itfs.length; i++) {

			try {

				Object o = _this_weaveableBC.lookupFc(itfs[i]);
				if (o != null) {
					throw new UndeploymentException(
							"Component is bound to other components. Unbind it before undeployment");
				}

			} catch (NoSuchInterfaceException ignored) {
			}
		}

		_super_undeploy();

	}

	// -------------------------------------------------------------------------
	// Fields and methods required by the mixin class in the base class
	// -------------------------------------------------------------------------

	/**
	 * The <tt>weaveableOptBC</tt> field required by this mixin. This field is
	 * supposed to reference the {@link BindingController} interface of the
	 * component to which this controller object belongs.
	 */

	public BindingController _this_weaveableBC;

	/**
	 * The {@link UndeploymentController#undeploy undeploy} method overriden by
	 * this mixin.
	 */

	public abstract void _super_undeploy() throws UndeploymentException;

}
