/***
 * Jade-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.fractal.julia.control.deployment;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.deployment.local.api.UndeploymentController;
import org.objectweb.fractal.deployment.local.api.UndeploymentException;
import org.objectweb.fractal.util.Fractal;

/**
 * This mixin check if the component the {@link UndeploymentController} belongs
 * to is a sub-component of composite(s). If so, it removes the component from
 * composite(s)
 * 
 * @author <a href="mailto:julien.legrand@inrialpes.fr">Julien Legrand</a>
 */
public abstract class RemoveFcSubComponentUndeploymentMixin implements
		UndeploymentController {

	// -------------------------------------------------------------------------
	// Private constructor
	// -------------------------------------------------------------------------

	private RemoveFcSubComponentUndeploymentMixin() {
	}

	// -------------------------------------------------------------------------
	// Fields and methods added and overriden by the mixin class
	// -------------------------------------------------------------------------

	/**
	 * Remove the component from its parent component and then calls the
	 * overriden method.
	 */
	public void undeploy() throws UndeploymentException {

		Component[] parents = _this_weaveableSC.getFcSuperComponents();

		if (parents.length > 0) {

			for (Component parent : parents) {

				try {

					ContentController cc = Fractal.getContentController(parent);
					cc.removeFcSubComponent((Component)_this_weaveableC.getFcInterface("component"));

				} catch (Exception e) {
					throw new ChainedUndeploymentException(e, _this_weaveableC,
							e.getMessage());
				}
			}
		}

		_super_undeploy();
	}

	// -------------------------------------------------------------------------
	// Fields and methods required by the mixin class in the base class
	// -------------------------------------------------------------------------

	/**
	 * The <tt>weaveableOptC</tt> field required by this mixin. This field is
	 * supposed to reference the {@link Component} interface of the component to
	 * which this controller object belongs.
	 */

	public Component _this_weaveableC;

	/**
	 * The {@link SuperController} interface of the component to which this
	 * controller object belongs.
	 */

	public SuperController _this_weaveableSC;

	/**
	 * The {@link UndeploymentController#undeploy undeploy} method overriden by
	 * this mixin.
	 */

	public abstract void _super_undeploy() throws UndeploymentException;

}
