/***
 * Jade-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.fractal.julia.control.factory;

import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.deployment.local.api.GenericInstallingFactory;
import org.objectweb.fractal.julia.Controller;
import org.objectweb.fractal.julia.InitializationContext;

import org.ow2.jasmine.jade.fractal.api.control.GenericInstallingFactoryController;

/**
 * Provides an implementation of the
 * {@link org.ow2.jasmine.jade.fractal.api.control.GenericInstallingFactoryController}
 * interface.
 * 
 * @author <a href="mailto:jakub.kornas@inrialpes.fr">Jakub Kornas</a>
 * 
 */
public abstract class GenericInstallingFactoryControllerMixin implements
		Controller, GenericInstallingFactoryController {

	/**
	 * The GenericInstallingFactory which instantiated the component this
	 * controller belongs.
	 */
	private GenericInstallingFactory factory;

	// -------------------------------------------------------------------------
	// Private constructor
	// -------------------------------------------------------------------------
	private GenericInstallingFactoryControllerMixin() {
	}

	// -------------------------------------------------------------------------
	// Fields and methods added and overriden by the mixin class
	// -------------------------------------------------------------------------

	public void initFcController(final InitializationContext ic)
			throws InstantiationException {
		_super_initFcController(ic);
	}

	// -------------------------------------------------------------------------
	// Implementation of the GenericInstallingFactoryController interface
	// -------------------------------------------------------------------------

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.ow2.jasmine.jade.fractal.api.control.GenericInstallingFactoryController#getGenericFactory()
	 */
	public GenericInstallingFactory getGenericFactory() {
		return this.factory;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.ow2.jasmine.jade.fractal.api.control.GenericInstallingFactoryController#setGenericFactory(org.objectweb.fractal.deployment.local.api.GenericInstallingFactory)
	 */
	public void setGenericFactory(GenericInstallingFactory factory) {
		this.factory = factory;
	}

	// -------------------------------------------------------------------------
	// Fields and methods required by the mixin class in the base class
	// -------------------------------------------------------------------------

	public abstract void _super_initFcController(InitializationContext ic)
			throws InstantiationException;

}
