/***
 * Jade-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.fractal.julia.control.genericattribute;

import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.julia.Controller;
import org.objectweb.fractal.julia.InitializationContext;

import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;

/**
 * Provide a basic implementation of the {@link GenericAttributeController}
 * interface. This mixin is used for container component.
 * 
 * @author <a href="mailto:noel.depalma@inrialpes.fr">Noel de palma</a>
 * @author <a href="mailto:julien.legrand@inrialpes.fr">Julien Legrand</a>
 */
public abstract class GenericAttributeControllerMixin implements Controller,
		GenericAttributeController {

	/**
	 * The implementation cmp.
	 */
	public Object innerImpl;

	// -------------------------------------------------------------------------
	// Private constructor
	// -------------------------------------------------------------------------
	private GenericAttributeControllerMixin() {
	}

	// -------------------------------------------------------------------------
	// Fields and methods added and overriden by the mixin class
	// -------------------------------------------------------------------------
	public void initFcController(final InitializationContext ic)
			throws InstantiationException {
		innerImpl = ic.content;
		_super_initFcController(ic);
	}

	// -------------------------------------------------------------------------
	// Implementation of the GenericAttributeController interface
	// -------------------------------------------------------------------------

	/**
	 * retrieve an attribute identified by its name.
	 * 
	 * @param name
	 *            the name of the attribute to read.
	 * @return the String value of the attribute identified by its name. null if
	 *         the implementation does not implements
	 *         GenericAttributeController.
	 * @throws NoSuchAttributeException
	 *             if the given attribute is unknow.
	 */
	public String getAttribute(String name) throws NoSuchAttributeException {
		if (innerImpl instanceof GenericAttributeController) {
			return ((GenericAttributeController) innerImpl).getAttribute(name);
		} else {
			return null;
		}
	}

	/**
	 * Returns the names of the attribute of the component to which this
	 * interface belongs.
	 * 
	 * @return the names of the attributes of the component to which this
	 *         interface belongs.
	 */

	public String[] listFcAtt() {
		if (innerImpl instanceof GenericAttributeController) {
			return ((GenericAttributeController) innerImpl).listFcAtt();
		} else {
			return null;
		}
	}

	/**
	 * set the value of an attribute identified by its name and notify the
	 * update to the metalevel.
	 * 
	 * @param name
	 *            the name of the attribute to read.
	 * @param value
	 *            the value of the attribute.
	 * @throws NoSuchAttributeException
	 *             if the given attribute is unknow.
	 */
	public void setAttribute(String name, String value)
			throws NoSuchAttributeException {

		if (innerImpl instanceof GenericAttributeController) {
			if (value != null)
				((GenericAttributeController) innerImpl).setAttribute(name,
						value);
		} else {
			// throw new NoSuchAttributeException("Not a
			// GenericAttributeController");
		}

	}

	// -------------------------------------------------------------------------
	// Fields and methods required by the mixin class in the base class
	// -------------------------------------------------------------------------
	public abstract void _super_initFcController(InitializationContext ic)
			throws InstantiationException;

}
